/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;

public class BlockConduit
extends BlockTransparent {
    @Override
    public int getId() {
        return 412;
    }

    @Override
    public String getName() {
        return "Conduit";
    }

    @Override
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (item.getBlock() != null && item.getBlock().getId() == 412 && target.getId() == 412) {
            return false;
        }
        this.getLevel().setBlock((Vector3)this, this, true, true);
        CompoundTag nbt = new CompoundTag().putString("id", "Conduit").putInt("x", (int)block.x).putInt("y", (int)block.y).putInt("z", (int)block.z).putBoolean("IsMovable", true);
        BlockEntity entity = BlockEntity.createBlockEntity("Conduit", this.getLevel().getChunk((int)block.x >> 4, (int)block.z >> 4), nbt, new Object[0]);
        if (entity != null) {
            entity.scheduleUpdate();
        }
        return true;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DIAMOND_BLOCK_COLOR;
    }

    @Override
    public double getMinX() {
        return this.x + 0.3125;
    }

    @Override
    public double getMinY() {
        return this.y + 0.3125;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.3125;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.6875;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.6875;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.6875;
    }
}

