/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBubbleColumn;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockFormEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.utils.BlockColor;

public class BlockMagma
extends BlockSolid {
    @Override
    public int getId() {
        return 213;
    }

    @Override
    public String getName() {
        return "Magma Block";
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 30.0;
    }

    @Override
    public int getLightLevel() {
        return 3;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (!entity.hasEffect(12)) {
            if (entity instanceof Player) {
                Player p = (Player)entity;
                if (p.getInventory().getBoots().getEnchantment(25) != null) {
                    return;
                }
                if (!(p.isCreative() || p.isSpectator() || p.isSneaking())) {
                    entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.LAVA, 1.0f));
                }
            } else {
                entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.LAVA, 1.0f));
            }
        }
    }

    @Override
    public int onUpdate(int type) {
        BlockFormEvent event;
        Block up;
        if (type == 1 && (up = this.up()) instanceof BlockWater && (up.getDamage() == 0 || up.getDamage() == 8) && !(event = new BlockFormEvent(up, new BlockBubbleColumn(1))).isCancelled()) {
            if (event.getNewState().getWaterloggingLevel() > 0) {
                this.getLevel().setBlock(up, 1, new BlockWater(), true, false);
            }
            this.getLevel().setBlock(up, 0, event.getNewState(), true, true);
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.NETHERRACK_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

