/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockChest;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityChest;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import java.util.Map;

public class BlockTrappedChest
extends BlockChest {
    public BlockTrappedChest() {
        this(0);
    }

    public BlockTrappedChest(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 146;
    }

    @Override
    public String getName() {
        return "Trapped Chest";
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        BlockEntityChest blockEntity;
        int[] faces = new int[]{2, 5, 3, 4};
        BlockEntityChest chest = null;
        this.setDamage(faces[player != null ? player.getDirection().getHorizontalIndex() : 0]);
        for (BlockFace side : BlockFace.Plane.HORIZONTAL) {
            BlockEntity blockEntity2;
            Block c;
            if ((this.getDamage() == 4 || this.getDamage() == 5) && (side == BlockFace.WEST || side == BlockFace.EAST) || (this.getDamage() == 3 || this.getDamage() == 2) && (side == BlockFace.NORTH || side == BlockFace.SOUTH) || !((c = this.getSide(side)) instanceof BlockTrappedChest) || c.getDamage() != this.getDamage() || !((blockEntity2 = this.getLevel().getBlockEntity(c)) instanceof BlockEntityChest) || ((BlockEntityChest)blockEntity2).isPaired()) continue;
            chest = (BlockEntityChest)blockEntity2;
            break;
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        CompoundTag nbt = new CompoundTag("").putList(new ListTag("Items")).putString("id", "Chest").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        if ((blockEntity = (BlockEntityChest)BlockEntity.createBlockEntity("Chest", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0])) == null) {
            return false;
        }
        if (chest != null) {
            chest.pairWith(blockEntity);
            blockEntity.pairWith(chest);
        }
        return true;
    }

    @Override
    public int getWeakPower(BlockFace face) {
        int playerCount = 0;
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityChest) {
            playerCount = ((BlockEntityChest)blockEntity).getInventory().getViewers().size();
        }
        return playerCount < 0 ? 0 : (playerCount > 15 ? 15 : playerCount);
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return side == BlockFace.UP ? this.getWeakPower(side) : 0;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }
}

