/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.randomitem;

import cn.nukkit.item.Item;
import cn.nukkit.item.randomitem.ConstantItemSelector;
import cn.nukkit.item.randomitem.RandomItem;
import cn.nukkit.item.randomitem.Selector;
import cn.nukkit.utils.DyeColor;

public final class Fishing {
    public static final Selector ROOT_FISHING = RandomItem.putSelector(new Selector(RandomItem.ROOT));
    public static final Selector FISHES = RandomItem.putSelector(new Selector(ROOT_FISHING), 0.85f);
    public static final Selector TREASURES = RandomItem.putSelector(new Selector(ROOT_FISHING), 0.05f);
    public static final Selector JUNKS = RandomItem.putSelector(new Selector(ROOT_FISHING), 0.1f);
    public static final Selector FISH = RandomItem.putSelector(new ConstantItemSelector(349, FISHES), 0.6f);
    public static final Selector SALMON = RandomItem.putSelector(new ConstantItemSelector(460, FISHES), 0.25f);
    public static final Selector CLOWNFISH = RandomItem.putSelector(new ConstantItemSelector(461, FISHES), 0.02f);
    public static final Selector PUFFERFISH = RandomItem.putSelector(new ConstantItemSelector(462, FISHES), 0.13f);
    public static final Selector TREASURE_BOW = RandomItem.putSelector(new ConstantItemSelector(261, TREASURES), 0.1667f);
    public static final Selector TREASURE_ENCHANTED_BOOK = RandomItem.putSelector(new ConstantItemSelector(403, TREASURES), 0.1667f);
    public static final Selector TREASURE_FISHING_ROD = RandomItem.putSelector(new ConstantItemSelector(346, TREASURES), 0.1667f);
    public static final Selector TREASURE_NAME_TAG = RandomItem.putSelector(new ConstantItemSelector(421, TREASURES), 0.1667f);
    public static final Selector TREASURE_SADDLE = RandomItem.putSelector(new ConstantItemSelector(329, TREASURES), 0.1667f);
    public static final Selector JUNK_BOWL = RandomItem.putSelector(new ConstantItemSelector(281, JUNKS), 0.12f);
    public static final Selector JUNK_FISHING_ROD = RandomItem.putSelector(new ConstantItemSelector(346, JUNKS), 0.024f);
    public static final Selector JUNK_LEATHER = RandomItem.putSelector(new ConstantItemSelector(334, JUNKS), 0.12f);
    public static final Selector JUNK_LEATHER_BOOTS = RandomItem.putSelector(new ConstantItemSelector(301, JUNKS), 0.12f);
    public static final Selector JUNK_ROTTEN_FLESH = RandomItem.putSelector(new ConstantItemSelector(367, JUNKS), 0.12f);
    public static final Selector JUNK_STICK = RandomItem.putSelector(new ConstantItemSelector(280, JUNKS), 0.06f);
    public static final Selector JUNK_STRING_ITEM = RandomItem.putSelector(new ConstantItemSelector(287, JUNKS), 0.06f);
    public static final Selector JUNK_WATTER_BOTTLE = RandomItem.putSelector(new ConstantItemSelector(373, 0, JUNKS), 0.12f);
    public static final Selector JUNK_BONE = RandomItem.putSelector(new ConstantItemSelector(352, JUNKS), 0.12f);
    public static final Selector JUNK_INK_SAC = RandomItem.putSelector(new ConstantItemSelector(351, DyeColor.BLACK.getDyeData(), 10, JUNKS), 0.012f);
    public static final Selector JUNK_TRIPWIRE_HOOK = RandomItem.putSelector(new ConstantItemSelector(131, JUNKS), 0.12f);

    public static Item getFishingResult(Item rod) {
        int fortuneLevel = 0;
        int lureLevel = 0;
        if (rod != null) {
            if (rod.getEnchantment(23) != null) {
                fortuneLevel = rod.getEnchantment(23).getLevel();
            } else if (rod.getEnchantment(24) != null) {
                lureLevel = rod.getEnchantment(24).getLevel();
            }
        }
        return Fishing.getFishingResult(fortuneLevel, lureLevel);
    }

    public static Item getFishingResult(int fortuneLevel, int lureLevel) {
        float treasureChance = Fishing.limitRange(0.0f, 1.0f, 0.05f + 0.01f * (float)fortuneLevel - 0.01f * (float)lureLevel);
        float junkChance = Fishing.limitRange(0.0f, 1.0f, 0.05f - 0.025f * (float)fortuneLevel - 0.01f * (float)lureLevel);
        float fishChance = Fishing.limitRange(0.0f, 1.0f, 1.0f - treasureChance - junkChance);
        RandomItem.putSelector(FISHES, fishChance);
        RandomItem.putSelector(TREASURES, treasureChance);
        RandomItem.putSelector(JUNKS, junkChance);
        Object result = RandomItem.selectFrom(ROOT_FISHING);
        if (result instanceof Item) {
            return (Item)result;
        }
        return null;
    }

    private static float limitRange(float min, float max, float value) {
        if (value >= max) {
            return max;
        }
        if (value <= min) {
            return min;
        }
        return value;
    }
}

