/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalBlockPalette {
    private static final Logger log;
    private static final Int2IntMap legacyToRuntimeId;
    private static final Int2IntMap runtimeIdToLegacy;
    private static final Long2IntMap hyperToRuntimeId;
    private static final Long2LongMap runtimeIdToHyper;
    private static final Int2ObjectMap<String> legacyIdToString;
    private static final Map<String, Integer> stringToLegacyId;
    private static final AtomicInteger runtimeIdAllocator;
    public static final byte[] BLOCK_PALETTE;
    private static final Int2ObjectMap<IntSet> unknownRuntimeIds;

    private static void register(int id, int meta, int runtimeId) {
        if (meta <= 64) {
            int legacyId = id << 6 | meta;
            legacyToRuntimeId.put(legacyId, runtimeId);
        } else {
            long hyperId = (long)id << 32 | (long)meta;
            hyperToRuntimeId.put(hyperId, runtimeId);
        }
    }

    public static int getOrCreateRuntimeId(int id, int meta) {
        int runtimeId;
        if (id == 0) {
            meta = 0;
        }
        if (meta <= 64) {
            int legacyId = id << 6 | meta;
            runtimeId = legacyToRuntimeId.get(legacyId);
        } else {
            long hyperId = (long)id << 32 | (long)meta;
            runtimeId = hyperToRuntimeId.get(hyperId);
        }
        if (runtimeId == -1) {
            runtimeId = legacyToRuntimeId.get(15872);
            if (((IntSet)unknownRuntimeIds.computeIfAbsent(id, k -> new IntOpenHashSet(5))).add(meta)) {
                log.error("Found an unknown BlockId:Meta combination: " + id + ":" + meta + ", replacing with an \"UPDATE!\" block.");
            }
        }
        return runtimeId;
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", replaceWith="getOrCreateRuntimeId(int id, int meta)", since="1.3.0.0-PN")
    public static int getOrCreateRuntimeId(int legacyId) throws NoSuchElementException {
        return GlobalBlockPalette.getOrCreateRuntimeId(legacyId >> 6, legacyId & 0x3F);
    }

    public static int getLegacyId(int runtimeId) {
        return runtimeIdToLegacy.get(runtimeId);
    }

    public static String getName(int id) {
        return (String)legacyIdToString.get(id);
    }

    /*
     * WARNING - void declaration
     */
    static {
        ListTag tag;
        Object states;
        log = LogManager.getLogger(GlobalBlockPalette.class);
        legacyToRuntimeId = new Int2IntOpenHashMap();
        runtimeIdToLegacy = new Int2IntOpenHashMap();
        hyperToRuntimeId = new Long2IntOpenHashMap();
        runtimeIdToHyper = new Long2LongOpenHashMap();
        legacyIdToString = new Int2ObjectOpenHashMap();
        stringToLegacyId = new HashMap<String, Integer>();
        runtimeIdAllocator = new AtomicInteger(0);
        unknownRuntimeIds = new Int2ObjectOpenHashMap();
        legacyToRuntimeId.defaultReturnValue(-1);
        runtimeIdToLegacy.defaultReturnValue(-1);
        hyperToRuntimeId.defaultReturnValue(-1);
        runtimeIdToHyper.defaultReturnValue(-1L);
        LinkedHashMap<CompoundTag, List<CompoundTag>> metaOverrides = new LinkedHashMap<CompoundTag, List<CompoundTag>>();
        try (InputStream stream = Server.class.getClassLoader().getResourceAsStream("runtime_block_states_overrides.dat");){
            if (stream == null) {
                throw new AssertionError((Object)"Unable to locate block state nbt");
            }
            Throwable throwable = null;
            try (BufferedInputStream buffered = new BufferedInputStream(stream);){
                states = NBTIO.read(buffered).getList("Overrides", CompoundTag.class);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (CompoundTag compoundTag : ((ListTag)states).getAll()) {
                if (!compoundTag.contains("block") || !compoundTag.contains("LegacyStates")) continue;
                metaOverrides.put(compoundTag.getCompound("block").remove("version"), compoundTag.getList("LegacyStates", CompoundTag.class).getAll());
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            InputStream stream = Server.class.getClassLoader().getResourceAsStream("runtime_block_states.dat");
            states = null;
            try {
                if (stream == null) {
                    throw new AssertionError((Object)"Unable to locate block state nbt");
                }
                Throwable throwable = null;
                try (BufferedInputStream buffered2 = new BufferedInputStream(stream);){
                    tag = (ListTag)NBTIO.readTag(buffered2, ByteOrder.LITTLE_ENDIAN, false);
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable buffered2) {
                states = buffered2;
                throw buffered2;
            }
            finally {
                if (stream != null) {
                    if (states != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable buffered2) {
                            ((Throwable)states).addSuppressed(buffered2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        for (CompoundTag state : tag.getAll()) {
            void var5_19;
            int runtimeId = runtimeIdAllocator.getAndIncrement();
            List list = (List)metaOverrides.get(state.getCompound("block").copy().remove("version"));
            if (list == null) {
                if (!state.contains("LegacyStates")) continue;
                List<CompoundTag> list2 = state.getList("LegacyStates", CompoundTag.class).getAll();
            }
            String name = state.getCompound("block").getString("name");
            CompoundTag firstState = (CompoundTag)var5_19.get(0);
            int firstId = firstState.getInt("id");
            int firstMeta = firstState.getInt("val");
            GlobalBlockPalette.register(firstId, firstMeta, runtimeId);
            stringToLegacyId.put(name, firstId);
            for (CompoundTag legacyState : var5_19) {
                int newBlockId = legacyState.getInt("id");
                int meta = legacyState.getInt("val");
                GlobalBlockPalette.register(newBlockId, meta, runtimeId);
            }
            state.remove("meta");
            state.remove("LegacyStates");
        }
        try {
            BLOCK_PALETTE = NBTIO.write(tag, ByteOrder.LITTLE_ENDIAN, true);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

