/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.generic;

import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockWall;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.Chunk;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.Faceable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class BaseChunk
extends BaseFullChunk
implements Chunk {
    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.0.0-PN")
    public static final int CONTENT_VERSION = 1;
    protected ChunkSection[] sections;

    @Override
    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.0.0-PN")
    public void backwardCompatibilityUpdate(Level level) {
        super.backwardCompatibilityUpdate(level);
        boolean updated = false;
        block0: for (ChunkSection section : this.sections) {
            int contentVersion = section.getContentVersion();
            if (contentVersion >= 1) continue;
            WallUpdater wallUpdater = new WallUpdater(level, section);
            boolean sectionUpdated = this.walk(section, new GroupedUpdaters(wallUpdater, new StemUpdater(level, section, 105, 103), new StemUpdater(level, section, 104, 86)));
            updated = updated || sectionUpdated;
            int attempts = 0;
            while (sectionUpdated) {
                if (attempts++ >= 5) {
                    int x = this.getX() << 4 | 6;
                    int y = section.getY() << 4 | 6;
                    int z = this.getZ() << 4 | 6;
                    Server.getInstance().getLogger().warning("The chunk section at x:" + x + ", y:" + y + ", z:" + z + " failed to complete the backward compatibility update 1 after " + attempts + " attempts");
                    continue block0;
                }
                sectionUpdated = this.walk(section, wallUpdater);
            }
        }
        if (updated) {
            this.setChanged();
        }
    }

    @Override
    public BaseChunk clone() {
        BaseChunk chunk = (BaseChunk)super.clone();
        if (this.biomes != null) {
            chunk.biomes = (byte[])this.biomes.clone();
        }
        chunk.heightMap = (byte[])this.getHeightMapArray().clone();
        if (this.sections != null && this.sections[0] != null) {
            chunk.sections = new ChunkSection[this.sections.length];
            for (int i = 0; i < this.sections.length; ++i) {
                chunk.sections[i] = this.sections[i].copy();
            }
        }
        return chunk;
    }

    private void removeInvalidTile(int x, int y, int z) {
        BlockEntity entity = this.getTile(x, y, z);
        if (entity != null && !entity.isBlockEntityValid()) {
            this.removeBlockEntity(entity);
        }
    }

    @Override
    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(x, y, z, 0);
    }

    @Override
    public int getFullBlock(int x, int y, int z, int layer) {
        return this.sections[y >> 4].getFullBlock(x, y & 0xF, z, layer);
    }

    @Override
    public int[] getBlockState(int x, int y, int z, int layer) {
        return this.sections[y >> 4].getBlockState(x, y & 0xF, z, layer);
    }

    @Override
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId) {
        return this.setBlockAtLayer(x, y, z, layer, blockId, 0);
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId) {
        return this.setBlock(x, y, z, blockId, 0);
    }

    @Override
    public Block getAndSetBlock(int x, int y, int z, Block block) {
        return this.getAndSetBlock(x, y, z, 0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getAndSetBlock(int x, int y, int z, int layer, Block block) {
        int Y = y >> 4;
        try {
            this.setChanged();
            Block block2 = this.sections[Y].getAndSetBlock(x, y & 0xF, z, layer, block);
            return block2;
        }
        catch (ChunkException e) {
            try {
                this.setInternalSection(Y, (ChunkSection)this.providerClass.getMethod("createChunkSection", Integer.TYPE).invoke((Object)this.providerClass, Y));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                Server.getInstance().getLogger().logException(e1);
            }
            Block block3 = this.sections[Y].getAndSetBlock(x, y & 0xF, z, layer, block);
            return block3;
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    public boolean setFullBlockId(int x, int y, int z, int fullId) {
        return this.setFullBlockId(x, y, z, 0, fullId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    public boolean setFullBlockId(int x, int y, int z, int layer, int fullId) {
        int Y = y >> 4;
        try {
            this.setChanged();
            boolean bl = this.sections[Y].setFullBlockId(x, y & 0xF, z, layer, fullId);
            return bl;
        }
        catch (ChunkException e) {
            try {
                this.setInternalSection(Y, (ChunkSection)this.providerClass.getMethod("createChunkSection", Integer.TYPE).invoke((Object)this.providerClass, Y));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                Server.getInstance().getLogger().logException(e1);
            }
            boolean bl = this.sections[Y].setFullBlockId(x, y & 0xF, z, layer, fullId);
            return bl;
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId, int meta) {
        return this.setBlockAtLayer(x, y, z, 0, blockId, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId, int meta) {
        int Y = y >> 4;
        try {
            this.setChanged();
            boolean bl = this.sections[Y].setBlockAtLayer(x, y & 0xF, z, layer, blockId, meta);
            return bl;
        }
        catch (ChunkException e) {
            try {
                this.setInternalSection(Y, (ChunkSection)this.providerClass.getMethod("createChunkSection", Integer.TYPE).invoke((Object)this.providerClass, Y));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                Server.getInstance().getLogger().logException(e1);
            }
            boolean bl = this.sections[Y].setBlockAtLayer(x, y & 0xF, z, layer, blockId, meta);
            return bl;
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    public void setBlockId(int x, int y, int z, int id) {
        this.setBlockId(x, y, z, 0, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockId(int x, int y, int z, int layer, int id) {
        int Y = y >> 4;
        try {
            this.sections[Y].setBlockId(x, y & 0xF, z, layer, id);
            this.setChanged();
        }
        catch (ChunkException e) {
            try {
                this.setInternalSection(Y, (ChunkSection)this.providerClass.getMethod("createChunkSection", Integer.TYPE).invoke((Object)this.providerClass, Y));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                Server.getInstance().getLogger().logException(e1);
            }
            this.sections[Y].setBlockId(x, y & 0xF, z, layer, id);
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.getBlockId(x, y, z, 0);
    }

    @Override
    public int getBlockId(int x, int y, int z, int layer) {
        return this.sections[y >> 4].getBlockId(x, y & 0xF, z, layer);
    }

    @Override
    public int getBlockData(int x, int y, int z) {
        return this.getBlockData(x, y, z, 0);
    }

    @Override
    public int getBlockData(int x, int y, int z, int layer) {
        return this.sections[y >> 4].getBlockData(x, y & 0xF, z, layer);
    }

    @Override
    public void setBlockData(int x, int y, int z, int data) {
        this.setBlockData(x, y, z, 0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockData(int x, int y, int z, int layer, int data) {
        int Y = y >> 4;
        try {
            this.sections[Y].setBlockData(x, y & 0xF, z, layer, data);
            this.setChanged();
        }
        catch (ChunkException e) {
            try {
                this.setInternalSection(Y, (ChunkSection)this.providerClass.getMethod("createChunkSection", Integer.TYPE).invoke((Object)this.providerClass, Y));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                Server.getInstance().getLogger().logException(e1);
            }
            this.sections[Y].setBlockData(x, y & 0xF, z, layer, data);
        }
        finally {
            this.removeInvalidTile(x, y, z);
        }
    }

    @Override
    public int getBlockSkyLight(int x, int y, int z) {
        return this.sections[y >> 4].getBlockSkyLight(x, y & 0xF, z);
    }

    @Override
    public void setBlockSkyLight(int x, int y, int z, int level) {
        int Y = y >> 4;
        try {
            this.sections[Y].setBlockSkyLight(x, y & 0xF, z, level);
            this.setChanged();
        }
        catch (ChunkException e) {
            try {
                this.setInternalSection(Y, (ChunkSection)this.providerClass.getMethod("createChunkSection", Integer.TYPE).invoke((Object)this.providerClass, Y));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                Server.getInstance().getLogger().logException(e1);
            }
            this.sections[Y].setBlockSkyLight(x, y & 0xF, z, level);
        }
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.sections[y >> 4].getBlockLight(x, y & 0xF, z);
    }

    @Override
    public void setBlockLight(int x, int y, int z, int level) {
        int Y = y >> 4;
        try {
            this.sections[Y].setBlockLight(x, y & 0xF, z, level);
            this.setChanged();
        }
        catch (ChunkException e) {
            try {
                this.setInternalSection(Y, (ChunkSection)this.providerClass.getMethod("createChunkSection", Integer.TYPE).invoke((Object)this.providerClass, Y));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                Server.getInstance().getLogger().logException(e1);
            }
            this.sections[Y].setBlockLight(x, y & 0xF, z, level);
        }
    }

    @Override
    public boolean isSectionEmpty(float fY) {
        return this.sections[(int)fY] instanceof EmptyChunkSection;
    }

    @Override
    public ChunkSection getSection(float fY) {
        return this.sections[(int)fY];
    }

    @Override
    public boolean setSection(float fY, ChunkSection section) {
        byte[] emptyIdArray = new byte[4096];
        byte[] emptyDataArray = new byte[2048];
        this.sections[(int)fY] = Arrays.equals(emptyIdArray, section.getIdArray()) && Arrays.equals(emptyDataArray, section.getDataArray()) ? EmptyChunkSection.EMPTY[(int)fY] : section;
        this.setChanged();
        return true;
    }

    private void setInternalSection(float fY, ChunkSection section) {
        this.sections[(int)fY] = section;
        this.setChanged();
    }

    @Override
    public boolean load() throws IOException {
        return this.load(true);
    }

    @Override
    public boolean load(boolean generate) throws IOException {
        return this.getProvider() != null && this.getProvider().getChunk(this.getX(), this.getZ(), true) != null;
    }

    @Override
    public byte[] getBlockIdArray(int layer) {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        for (int y = 0; y < 16; ++y) {
            buffer.put(this.sections[y].getIdArray(layer));
        }
        return buffer.array();
    }

    @Override
    public byte[] getBlockDataArray(int layer) {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        for (int y = 0; y < 16; ++y) {
            buffer.put(this.sections[y].getDataArray(layer));
        }
        return buffer.array();
    }

    @Override
    public byte[] getBlockSkyLightArray() {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        for (int y = 0; y < 16; ++y) {
            buffer.put(this.sections[y].getSkyLightArray());
        }
        return buffer.array();
    }

    @Override
    public byte[] getBlockLightArray() {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        for (int y = 0; y < 16; ++y) {
            buffer.put(this.sections[y].getLightArray());
        }
        return buffer.array();
    }

    @Override
    public ChunkSection[] getSections() {
        return this.sections;
    }

    @Override
    public byte[] getHeightMapArray() {
        return this.heightMap;
    }

    @Override
    public LevelProvider getProvider() {
        return this.provider;
    }

    private boolean walk(ChunkSection section, Updater updater) {
        int offsetX = this.getX() << 4;
        int offsetZ = this.getZ() << 4;
        int offsetY = section.getY() << 4;
        boolean updated = false;
        for (int x = 0; x <= 15; ++x) {
            for (int z = 0; z <= 15; ++z) {
                for (int y = 0; y <= 15; ++y) {
                    int[] state = section.getBlockState(x, y, z, 0);
                    updated |= updater.update(offsetX, offsetY, offsetZ, x, y, z, state[0], state[1]);
                }
            }
        }
        return updated;
    }

    private class GroupedUpdaters
    implements Updater {
        private final Updater[] updaters;

        public GroupedUpdaters(Updater ... updaters) {
            this.updaters = updaters;
        }

        @Override
        public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, int blockId, int meta) {
            for (Updater updater : this.updaters) {
                if (!updater.update(offsetX, offsetY, offsetZ, x, y, z, blockId, meta)) continue;
                return true;
            }
            return false;
        }
    }

    private class StemUpdater
    implements Updater {
        private final Level level;
        private final ChunkSection section;
        private final int stemId;
        private final int productId;

        @Override
        public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, int blockId, int meta) {
            if (blockId != this.stemId) {
                return false;
            }
            for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
                int sideId = this.level.getBlockIdAt(offsetX + x + blockFace.getXOffset(), offsetY + y, offsetZ + z + blockFace.getZOffset());
                if (sideId != this.productId) continue;
                Block blockStem = Block.get(blockId, meta, this.level, offsetX + x, offsetY + y, offsetZ + z, 0);
                ((Faceable)((Object)blockStem)).setBlockFace(blockFace);
                this.section.setBlockData(x, y, z, 0, blockStem.getDamage());
                return true;
            }
            return false;
        }

        public StemUpdater(Level level, ChunkSection section, int stemId, int productId) {
            this.level = level;
            this.section = section;
            this.stemId = stemId;
            this.productId = productId;
        }
    }

    private class WallUpdater
    implements Updater {
        private final Level level;
        private final ChunkSection section;

        @Override
        public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, int blockId, int meta) {
            if (blockId != 139) {
                return false;
            }
            BlockWall blockWall = (BlockWall)Block.get(blockId, meta, this.level, offsetX + x, offsetY + y, offsetZ + z, 0);
            if (blockWall.autoConfigureState()) {
                this.section.setBlockData(x, y, z, 0, blockWall.getDamage());
                return true;
            }
            return false;
        }

        public WallUpdater(Level level, ChunkSection section) {
            this.level = level;
            this.section = section;
        }
    }

    @FunctionalInterface
    private static interface Updater {
        public boolean update(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }
}

