/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network;

import cn.nukkit.Nukkit;
import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.nbt.stream.FastByteArrayOutputStream;
import cn.nukkit.network.AdvancedSourceInterface;
import cn.nukkit.network.SourceInterface;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.AddItemEntityPacket;
import cn.nukkit.network.protocol.AddPaintingPacket;
import cn.nukkit.network.protocol.AddPlayerPacket;
import cn.nukkit.network.protocol.AdventureSettingsPacket;
import cn.nukkit.network.protocol.AnimatePacket;
import cn.nukkit.network.protocol.AvailableCommandsPacket;
import cn.nukkit.network.protocol.AvailableEntityIdentifiersPacket;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.network.protocol.BiomeDefinitionListPacket;
import cn.nukkit.network.protocol.BlockEntityDataPacket;
import cn.nukkit.network.protocol.BlockEventPacket;
import cn.nukkit.network.protocol.BlockPickRequestPacket;
import cn.nukkit.network.protocol.BookEditPacket;
import cn.nukkit.network.protocol.BossEventPacket;
import cn.nukkit.network.protocol.ChangeDimensionPacket;
import cn.nukkit.network.protocol.ChunkRadiusUpdatedPacket;
import cn.nukkit.network.protocol.ClientCacheStatusPacket;
import cn.nukkit.network.protocol.ClientboundMapItemDataPacket;
import cn.nukkit.network.protocol.CodeBuilderPacket;
import cn.nukkit.network.protocol.CommandRequestPacket;
import cn.nukkit.network.protocol.CompletedUsingItemPacket;
import cn.nukkit.network.protocol.ContainerClosePacket;
import cn.nukkit.network.protocol.ContainerOpenPacket;
import cn.nukkit.network.protocol.ContainerSetDataPacket;
import cn.nukkit.network.protocol.CraftingDataPacket;
import cn.nukkit.network.protocol.CraftingEventPacket;
import cn.nukkit.network.protocol.CreativeContentPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.DebugInfoPacket;
import cn.nukkit.network.protocol.DisconnectPacket;
import cn.nukkit.network.protocol.EmoteListPacket;
import cn.nukkit.network.protocol.EmotePacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import cn.nukkit.network.protocol.EntityFallPacket;
import cn.nukkit.network.protocol.GameRulesChangedPacket;
import cn.nukkit.network.protocol.HurtArmorPacket;
import cn.nukkit.network.protocol.InteractPacket;
import cn.nukkit.network.protocol.InventoryContentPacket;
import cn.nukkit.network.protocol.InventorySlotPacket;
import cn.nukkit.network.protocol.InventoryTransactionPacket;
import cn.nukkit.network.protocol.ItemFrameDropItemPacket;
import cn.nukkit.network.protocol.LecternUpdatePacket;
import cn.nukkit.network.protocol.LevelChunkPacket;
import cn.nukkit.network.protocol.LevelEventGenericPacket;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.network.protocol.LevelSoundEventPacket;
import cn.nukkit.network.protocol.LevelSoundEventPacketV1;
import cn.nukkit.network.protocol.LoginPacket;
import cn.nukkit.network.protocol.MapCreateLockedCopyPacket;
import cn.nukkit.network.protocol.MapInfoRequestPacket;
import cn.nukkit.network.protocol.MobArmorEquipmentPacket;
import cn.nukkit.network.protocol.MobEquipmentPacket;
import cn.nukkit.network.protocol.ModalFormRequestPacket;
import cn.nukkit.network.protocol.ModalFormResponsePacket;
import cn.nukkit.network.protocol.MoveEntityAbsolutePacket;
import cn.nukkit.network.protocol.MoveEntityDeltaPacket;
import cn.nukkit.network.protocol.MovePlayerPacket;
import cn.nukkit.network.protocol.NetworkChunkPublisherUpdatePacket;
import cn.nukkit.network.protocol.NetworkStackLatencyPacket;
import cn.nukkit.network.protocol.OnScreenTextureAnimationPacket;
import cn.nukkit.network.protocol.PacketViolationWarningPacket;
import cn.nukkit.network.protocol.PlaySoundPacket;
import cn.nukkit.network.protocol.PlayStatusPacket;
import cn.nukkit.network.protocol.PlayerActionPacket;
import cn.nukkit.network.protocol.PlayerArmorDamagePacket;
import cn.nukkit.network.protocol.PlayerEnchantOptionsPacket;
import cn.nukkit.network.protocol.PlayerHotbarPacket;
import cn.nukkit.network.protocol.PlayerInputPacket;
import cn.nukkit.network.protocol.PlayerListPacket;
import cn.nukkit.network.protocol.PlayerSkinPacket;
import cn.nukkit.network.protocol.RemoveEntityPacket;
import cn.nukkit.network.protocol.RequestChunkRadiusPacket;
import cn.nukkit.network.protocol.ResourcePackChunkDataPacket;
import cn.nukkit.network.protocol.ResourcePackChunkRequestPacket;
import cn.nukkit.network.protocol.ResourcePackClientResponsePacket;
import cn.nukkit.network.protocol.ResourcePackDataInfoPacket;
import cn.nukkit.network.protocol.ResourcePackStackPacket;
import cn.nukkit.network.protocol.ResourcePacksInfoPacket;
import cn.nukkit.network.protocol.RespawnPacket;
import cn.nukkit.network.protocol.RiderJumpPacket;
import cn.nukkit.network.protocol.ScriptCustomEventPacket;
import cn.nukkit.network.protocol.ServerSettingsRequestPacket;
import cn.nukkit.network.protocol.ServerSettingsResponsePacket;
import cn.nukkit.network.protocol.SetCommandsEnabledPacket;
import cn.nukkit.network.protocol.SetDifficultyPacket;
import cn.nukkit.network.protocol.SetEntityDataPacket;
import cn.nukkit.network.protocol.SetEntityLinkPacket;
import cn.nukkit.network.protocol.SetEntityMotionPacket;
import cn.nukkit.network.protocol.SetHealthPacket;
import cn.nukkit.network.protocol.SetLocalPlayerAsInitializedPacket;
import cn.nukkit.network.protocol.SetPlayerGameTypePacket;
import cn.nukkit.network.protocol.SetSpawnPositionPacket;
import cn.nukkit.network.protocol.SetTimePacket;
import cn.nukkit.network.protocol.SetTitlePacket;
import cn.nukkit.network.protocol.ShowCreditsPacket;
import cn.nukkit.network.protocol.SpawnExperienceOrbPacket;
import cn.nukkit.network.protocol.SpawnParticleEffectPacket;
import cn.nukkit.network.protocol.StartGamePacket;
import cn.nukkit.network.protocol.TakeItemEntityPacket;
import cn.nukkit.network.protocol.TextPacket;
import cn.nukkit.network.protocol.UpdateAttributesPacket;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import cn.nukkit.network.protocol.UpdatePlayerGameTypePacket;
import cn.nukkit.network.protocol.UpdateSoftEnumPacket;
import cn.nukkit.network.protocol.UpdateTradePacket;
import cn.nukkit.network.protocol.VideoStreamConnectPacket;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.ThreadCache;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.VarInt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Network {
    private static final Logger log = LogManager.getLogger(Network.class);
    private static final ThreadLocal<Inflater> INFLATER_RAW = ThreadLocal.withInitial(() -> new Inflater(true));
    private static final ThreadLocal<Deflater> DEFLATER_RAW = ThreadLocal.withInitial(() -> new Deflater(7, true));
    private static final ThreadLocal<byte[]> BUFFER = ThreadLocal.withInitial(() -> new byte[0x200000]);
    public static final byte CHANNEL_NONE = 0;
    public static final byte CHANNEL_PRIORITY = 1;
    public static final byte CHANNEL_WORLD_CHUNKS = 2;
    public static final byte CHANNEL_MOVEMENT = 3;
    public static final byte CHANNEL_BLOCKS = 4;
    public static final byte CHANNEL_WORLD_EVENTS = 5;
    public static final byte CHANNEL_ENTITY_SPAWNING = 6;
    public static final byte CHANNEL_TEXT = 7;
    public static final byte CHANNEL_END = 31;
    private Class<? extends DataPacket>[] packetPool = new Class[256];
    private final Server server;
    private final Set<SourceInterface> interfaces = new HashSet<SourceInterface>();
    private final Set<AdvancedSourceInterface> advancedInterfaces = new HashSet<AdvancedSourceInterface>();
    private double upload = 0.0;
    private double download = 0.0;
    private String name;
    private String subName;

    public Network(Server server) {
        this.registerPackets();
        this.server = server;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public static byte[] inflateRaw(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = INFLATER_RAW.get();
        inflater.reset();
        inflater.setInput(data);
        inflater.finished();
        FastByteArrayOutputStream bos = (FastByteArrayOutputStream)ThreadCache.fbaos.get();
        bos.reset();
        byte[] buf = BUFFER.get();
        while (!inflater.finished()) {
            int i = inflater.inflate(buf);
            bos.write(buf, 0, i);
        }
        return bos.toByteArray();
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public static byte[] deflateRaw(byte[] data, int level) throws IOException {
        Deflater deflater = DEFLATER_RAW.get();
        deflater.reset();
        deflater.setLevel(level);
        deflater.setInput(data);
        deflater.finish();
        FastByteArrayOutputStream bos = (FastByteArrayOutputStream)ThreadCache.fbaos.get();
        bos.reset();
        byte[] buffer = BUFFER.get();
        while (!deflater.finished()) {
            int i = deflater.deflate(buffer);
            bos.write(buffer, 0, i);
        }
        return bos.toByteArray();
    }

    @Since(value="1.3.0.0-PN")
    public static byte[] deflateRaw(byte[][] datas, int level) throws IOException {
        Deflater deflater = DEFLATER_RAW.get();
        deflater.reset();
        deflater.setLevel(level);
        FastByteArrayOutputStream bos = (FastByteArrayOutputStream)ThreadCache.fbaos.get();
        bos.reset();
        byte[] buffer = BUFFER.get();
        for (byte[] data : datas) {
            deflater.setInput(data);
            while (!deflater.needsInput()) {
                int i = deflater.deflate(buffer);
                bos.write(buffer, 0, i);
            }
        }
        deflater.finish();
        while (!deflater.finished()) {
            int i = deflater.deflate(buffer);
            bos.write(buffer, 0, i);
        }
        return bos.toByteArray();
    }

    public void addStatistics(double upload, double download) {
        this.upload += upload;
        this.download += download;
    }

    public double getUpload() {
        return this.upload;
    }

    public double getDownload() {
        return this.download;
    }

    public void resetStatistics() {
        this.upload = 0.0;
        this.download = 0.0;
    }

    public Set<SourceInterface> getInterfaces() {
        return this.interfaces;
    }

    public void processInterfaces() {
        for (SourceInterface interfaz : this.interfaces) {
            try {
                interfaz.process();
            }
            catch (Exception e) {
                if (Nukkit.DEBUG > 1) {
                    this.server.getLogger().logException(e);
                }
                interfaz.emergencyShutdown();
                this.unregisterInterface(interfaz);
                log.fatal(this.server.getLanguage().translateString("nukkit.server.networkError", new String[]{interfaz.getClass().getName(), Utils.getExceptionMessage(e)}));
            }
        }
    }

    public void registerInterface(SourceInterface interfaz) {
        this.interfaces.add(interfaz);
        if (interfaz instanceof AdvancedSourceInterface) {
            this.advancedInterfaces.add((AdvancedSourceInterface)interfaz);
            ((AdvancedSourceInterface)interfaz).setNetwork(this);
        }
        interfaz.setName(this.name + "!@#" + this.subName);
    }

    public void unregisterInterface(SourceInterface sourceInterface) {
        this.interfaces.remove(sourceInterface);
        if (sourceInterface instanceof AdvancedSourceInterface) {
            this.advancedInterfaces.remove(sourceInterface);
        }
    }

    public void setName(String name) {
        this.name = name;
        this.updateName();
    }

    public String getName() {
        return this.name;
    }

    public String getSubName() {
        return this.subName;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    public void updateName() {
        for (SourceInterface interfaz : this.interfaces) {
            interfaz.setName(this.name + "!@#" + this.subName);
        }
    }

    public void registerPacket(byte id, Class<? extends DataPacket> clazz) {
        this.packetPool[id & 0xFF] = clazz;
    }

    public Server getServer() {
        return this.server;
    }

    public void processBatch(BatchPacket packet, Player player) {
        byte[] data;
        try {
            data = Network.inflateRaw(packet.payload);
        }
        catch (Exception e) {
            log.warn("Failed to decompress a batch packet from " + player.getName(), (Throwable)e);
            return;
        }
        int len = data.length;
        BinaryStream stream = new BinaryStream(data);
        try {
            ArrayList<DataPacket> packets = new ArrayList<DataPacket>();
            int count = 0;
            while (stream.offset < len) {
                if (++count >= 1000) {
                    player.close("", "Illegal Batch Packet");
                    return;
                }
                byte[] buf = stream.getByteArray();
                DataPacket pk = this.getPacketFromBuffer(buf);
                if (pk == null) continue;
                try {
                    pk.decode();
                }
                catch (Exception e) {
                    log.warn("Unable to decode {} from {}", (Object)pk.getClass().getSimpleName(), (Object)player.getName());
                    log.throwing((Throwable)e);
                    if (log.isTraceEnabled()) {
                        log.trace("Dumping Packet\n{}", (Object)ByteBufUtil.prettyHexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])packet.payload)));
                    }
                    throw e;
                }
                packets.add(pk);
            }
            this.processPackets(player, packets);
        }
        catch (Exception e) {
            MainLogger.getLogger().error("Error whilst decoding batch packet", e);
        }
    }

    public void processPackets(Player player, List<DataPacket> packets) {
        if (packets.isEmpty()) {
            return;
        }
        packets.forEach(player::handleDataPacket);
    }

    private DataPacket getPacketFromBuffer(byte[] buffer) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
        DataPacket pk = this.getPacket((byte)VarInt.readUnsignedVarInt(stream));
        if (pk != null) {
            pk.setBuffer(buffer, buffer.length - stream.available());
        }
        return pk;
    }

    public DataPacket getPacket(byte id) {
        Class<? extends DataPacket> clazz = this.packetPool[id & 0xFF];
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                Server.getInstance().getLogger().logException(e);
            }
        }
        return null;
    }

    public void sendPacket(InetSocketAddress socketAddress, ByteBuf payload) {
        for (AdvancedSourceInterface sourceInterface : this.advancedInterfaces) {
            sourceInterface.sendRawPacket(socketAddress, payload);
        }
    }

    public void blockAddress(InetAddress address) {
        for (AdvancedSourceInterface sourceInterface : this.advancedInterfaces) {
            sourceInterface.blockAddress(address);
        }
    }

    public void blockAddress(InetAddress address, int timeout) {
        for (AdvancedSourceInterface sourceInterface : this.advancedInterfaces) {
            sourceInterface.blockAddress(address, timeout);
        }
    }

    public void unblockAddress(InetAddress address) {
        for (AdvancedSourceInterface sourceInterface : this.advancedInterfaces) {
            sourceInterface.unblockAddress(address);
        }
    }

    private void registerPackets() {
        this.packetPool = new Class[256];
        this.registerPacket((byte)13, AddEntityPacket.class);
        this.registerPacket((byte)15, AddItemEntityPacket.class);
        this.registerPacket((byte)22, AddPaintingPacket.class);
        this.registerPacket((byte)12, AddPlayerPacket.class);
        this.registerPacket((byte)55, AdventureSettingsPacket.class);
        this.registerPacket((byte)44, AnimatePacket.class);
        this.registerPacket((byte)76, AvailableCommandsPacket.class);
        this.registerPacket((byte)-1, BatchPacket.class);
        this.registerPacket((byte)56, BlockEntityDataPacket.class);
        this.registerPacket((byte)26, BlockEventPacket.class);
        this.registerPacket((byte)34, BlockPickRequestPacket.class);
        this.registerPacket((byte)97, BookEditPacket.class);
        this.registerPacket((byte)74, BossEventPacket.class);
        this.registerPacket((byte)61, ChangeDimensionPacket.class);
        this.registerPacket((byte)70, ChunkRadiusUpdatedPacket.class);
        this.registerPacket((byte)67, ClientboundMapItemDataPacket.class);
        this.registerPacket((byte)77, CommandRequestPacket.class);
        this.registerPacket((byte)47, ContainerClosePacket.class);
        this.registerPacket((byte)46, ContainerOpenPacket.class);
        this.registerPacket((byte)51, ContainerSetDataPacket.class);
        this.registerPacket((byte)52, CraftingDataPacket.class);
        this.registerPacket((byte)53, CraftingEventPacket.class);
        this.registerPacket((byte)5, DisconnectPacket.class);
        this.registerPacket((byte)27, EntityEventPacket.class);
        this.registerPacket((byte)37, EntityFallPacket.class);
        this.registerPacket((byte)58, LevelChunkPacket.class);
        this.registerPacket((byte)72, GameRulesChangedPacket.class);
        this.registerPacket((byte)38, HurtArmorPacket.class);
        this.registerPacket((byte)33, InteractPacket.class);
        this.registerPacket((byte)49, InventoryContentPacket.class);
        this.registerPacket((byte)50, InventorySlotPacket.class);
        this.registerPacket((byte)30, InventoryTransactionPacket.class);
        this.registerPacket((byte)71, ItemFrameDropItemPacket.class);
        this.registerPacket((byte)25, LevelEventPacket.class);
        this.registerPacket((byte)24, LevelSoundEventPacketV1.class);
        this.registerPacket((byte)1, LoginPacket.class);
        this.registerPacket((byte)68, MapInfoRequestPacket.class);
        this.registerPacket((byte)32, MobArmorEquipmentPacket.class);
        this.registerPacket((byte)31, MobEquipmentPacket.class);
        this.registerPacket((byte)100, ModalFormRequestPacket.class);
        this.registerPacket((byte)101, ModalFormResponsePacket.class);
        this.registerPacket((byte)18, MoveEntityAbsolutePacket.class);
        this.registerPacket((byte)19, MovePlayerPacket.class);
        this.registerPacket((byte)36, PlayerActionPacket.class);
        this.registerPacket((byte)57, PlayerInputPacket.class);
        this.registerPacket((byte)63, PlayerListPacket.class);
        this.registerPacket((byte)48, PlayerHotbarPacket.class);
        this.registerPacket((byte)86, PlaySoundPacket.class);
        this.registerPacket((byte)2, PlayStatusPacket.class);
        this.registerPacket((byte)14, RemoveEntityPacket.class);
        this.registerPacket((byte)69, RequestChunkRadiusPacket.class);
        this.registerPacket((byte)6, ResourcePacksInfoPacket.class);
        this.registerPacket((byte)7, ResourcePackStackPacket.class);
        this.registerPacket((byte)8, ResourcePackClientResponsePacket.class);
        this.registerPacket((byte)82, ResourcePackDataInfoPacket.class);
        this.registerPacket((byte)83, ResourcePackChunkDataPacket.class);
        this.registerPacket((byte)84, ResourcePackChunkRequestPacket.class);
        this.registerPacket((byte)93, PlayerSkinPacket.class);
        this.registerPacket((byte)45, RespawnPacket.class);
        this.registerPacket((byte)20, RiderJumpPacket.class);
        this.registerPacket((byte)59, SetCommandsEnabledPacket.class);
        this.registerPacket((byte)60, SetDifficultyPacket.class);
        this.registerPacket((byte)39, SetEntityDataPacket.class);
        this.registerPacket((byte)41, SetEntityLinkPacket.class);
        this.registerPacket((byte)40, SetEntityMotionPacket.class);
        this.registerPacket((byte)42, SetHealthPacket.class);
        this.registerPacket((byte)62, SetPlayerGameTypePacket.class);
        this.registerPacket((byte)43, SetSpawnPositionPacket.class);
        this.registerPacket((byte)88, SetTitlePacket.class);
        this.registerPacket((byte)10, SetTimePacket.class);
        this.registerPacket((byte)102, ServerSettingsRequestPacket.class);
        this.registerPacket((byte)103, ServerSettingsResponsePacket.class);
        this.registerPacket((byte)75, ShowCreditsPacket.class);
        this.registerPacket((byte)66, SpawnExperienceOrbPacket.class);
        this.registerPacket((byte)11, StartGamePacket.class);
        this.registerPacket((byte)17, TakeItemEntityPacket.class);
        this.registerPacket((byte)9, TextPacket.class);
        this.registerPacket((byte)29, UpdateAttributesPacket.class);
        this.registerPacket((byte)21, UpdateBlockPacket.class);
        this.registerPacket((byte)80, UpdateTradePacket.class);
        this.registerPacket((byte)111, MoveEntityDeltaPacket.class);
        this.registerPacket((byte)113, SetLocalPlayerAsInitializedPacket.class);
        this.registerPacket((byte)115, NetworkStackLatencyPacket.class);
        this.registerPacket((byte)114, UpdateSoftEnumPacket.class);
        this.registerPacket((byte)121, NetworkChunkPublisherUpdatePacket.class);
        this.registerPacket((byte)119, AvailableEntityIdentifiersPacket.class);
        this.registerPacket((byte)120, LevelSoundEventPacket.class);
        this.registerPacket((byte)117, ScriptCustomEventPacket.class);
        this.registerPacket((byte)118, SpawnParticleEffectPacket.class);
        this.registerPacket((byte)122, BiomeDefinitionListPacket.class);
        this.registerPacket((byte)123, LevelSoundEventPacket.class);
        this.registerPacket((byte)124, LevelEventGenericPacket.class);
        this.registerPacket((byte)125, LecternUpdatePacket.class);
        this.registerPacket((byte)126, VideoStreamConnectPacket.class);
        this.registerPacket((byte)-127, ClientCacheStatusPacket.class);
        this.registerPacket((byte)-125, MapCreateLockedCopyPacket.class);
        this.registerPacket((byte)-118, EmotePacket.class);
        this.registerPacket((byte)-126, OnScreenTextureAnimationPacket.class);
        this.registerPacket((byte)-114, CompletedUsingItemPacket.class);
        this.registerPacket((byte)-106, CodeBuilderPacket.class);
        this.registerPacket((byte)-111, CreativeContentPacket.class);
        this.registerPacket((byte)-101, DebugInfoPacket.class);
        this.registerPacket((byte)-104, EmoteListPacket.class);
        this.registerPacket((byte)-100, PacketViolationWarningPacket.class);
        this.registerPacket((byte)-107, PlayerArmorDamagePacket.class);
        this.registerPacket((byte)-110, PlayerEnchantOptionsPacket.class);
        this.registerPacket((byte)-105, UpdatePlayerGameTypePacket.class);
    }
}

