/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol.types;

import cn.nukkit.Player;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.inventory.BeaconInventory;
import cn.nukkit.inventory.EnchantInventory;
import cn.nukkit.inventory.GrindstoneInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.transaction.action.CraftingTakeResultAction;
import cn.nukkit.inventory.transaction.action.CraftingTransferMaterialAction;
import cn.nukkit.inventory.transaction.action.CreativeInventoryAction;
import cn.nukkit.inventory.transaction.action.DropItemAction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.InventoryTransactionPacket;
import java.util.Optional;

public class NetworkInventoryAction {
    public static final int SOURCE_CONTAINER = 0;
    public static final int SOURCE_WORLD = 2;
    public static final int SOURCE_CREATIVE = 3;
    public static final int SOURCE_TODO = 99999;
    public static final int SOURCE_CRAFT_SLOT = 100;
    public static final int SOURCE_TYPE_CRAFTING_ADD_INGREDIENT = -2;
    public static final int SOURCE_TYPE_CRAFTING_REMOVE_INGREDIENT = -3;
    public static final int SOURCE_TYPE_CRAFTING_RESULT = -4;
    public static final int SOURCE_TYPE_CRAFTING_USE_INGREDIENT = -5;
    public static final int SOURCE_TYPE_ANVIL_INPUT = -10;
    public static final int SOURCE_TYPE_ANVIL_MATERIAL = -11;
    public static final int SOURCE_TYPE_ANVIL_RESULT = -12;
    public static final int SOURCE_TYPE_ANVIL_OUTPUT = -13;
    public static final int SOURCE_TYPE_ENCHANT_INPUT = -15;
    public static final int SOURCE_TYPE_ENCHANT_MATERIAL = -16;
    public static final int SOURCE_TYPE_ENCHANT_OUTPUT = -17;
    public static final int SOURCE_TYPE_TRADING_INPUT_1 = -20;
    public static final int SOURCE_TYPE_TRADING_INPUT_2 = -21;
    public static final int SOURCE_TYPE_TRADING_USE_INPUTS = -22;
    public static final int SOURCE_TYPE_TRADING_OUTPUT = -23;
    public static final int SOURCE_TYPE_BEACON = -24;
    public static final int SOURCE_TYPE_CONTAINER_DROP_CONTENTS = -100;
    public int sourceType;
    public int windowId;
    public long unknown;
    public int inventorySlot;
    public Item oldItem;
    public Item newItem;
    @Since(value="1.3.0.0-PN")
    public int stackNetworkId;

    public NetworkInventoryAction read(InventoryTransactionPacket packet) {
        this.sourceType = (int)packet.getUnsignedVarInt();
        switch (this.sourceType) {
            case 0: {
                this.windowId = packet.getVarInt();
                break;
            }
            case 2: {
                this.unknown = packet.getUnsignedVarInt();
                break;
            }
            case 3: {
                break;
            }
            case 100: 
            case 99999: {
                this.windowId = packet.getVarInt();
                switch (this.windowId) {
                    case -13: 
                    case -12: 
                    case -11: 
                    case -10: 
                    case -5: 
                    case -4: {
                        packet.isCraftingPart = true;
                    }
                }
            }
        }
        this.inventorySlot = (int)packet.getUnsignedVarInt();
        this.oldItem = packet.getSlot();
        this.newItem = packet.getSlot();
        if (packet.hasNetworkIds) {
            this.stackNetworkId = packet.getVarInt();
        }
        return this;
    }

    public void write(InventoryTransactionPacket packet) {
        packet.putUnsignedVarInt(this.sourceType);
        switch (this.sourceType) {
            case 0: {
                packet.putVarInt(this.windowId);
                break;
            }
            case 2: {
                packet.putUnsignedVarInt(this.unknown);
                break;
            }
            case 3: {
                break;
            }
            case 100: 
            case 99999: {
                packet.putVarInt(this.windowId);
            }
        }
        packet.putUnsignedVarInt(this.inventorySlot);
        packet.putSlot(this.oldItem);
        packet.putSlot(this.newItem);
        if (packet.hasNetworkIds) {
            packet.putVarInt(this.stackNetworkId);
        }
    }

    public InventoryAction createInventoryAction(Player player) {
        switch (this.sourceType) {
            case 0: {
                Inventory window;
                if (this.windowId == 120) {
                    this.inventorySlot += 36;
                    this.windowId = 0;
                }
                if ((window = player.getWindowById(this.windowId)) != null) {
                    return new SlotChangeAction(window, this.inventorySlot, this.oldItem, this.newItem);
                }
                player.getServer().getLogger().debug("Player " + player.getName() + " has no open container with window ID " + this.windowId);
                return null;
            }
            case 2: {
                if (this.inventorySlot != 0) {
                    player.getServer().getLogger().debug("Only expecting drop-item world actions from the client!");
                    return null;
                }
                return new DropItemAction(this.oldItem, this.newItem);
            }
            case 3: {
                int type;
                switch (this.inventorySlot) {
                    case 0: {
                        type = 0;
                        break;
                    }
                    case 1: {
                        type = 1;
                        break;
                    }
                    default: {
                        player.getServer().getLogger().debug("Unexpected creative action type " + this.inventorySlot);
                        return null;
                    }
                }
                return new CreativeInventoryAction(this.oldItem, this.newItem, type);
            }
            case 100: 
            case 99999: {
                Inventory inv;
                switch (this.windowId) {
                    case -3: 
                    case -2: {
                        return new SlotChangeAction(player.getCraftingGrid(), this.inventorySlot, this.oldItem, this.newItem);
                    }
                    case -100: {
                        Optional<Inventory> inventory = player.getTopWindow();
                        if (!inventory.isPresent()) {
                            return null;
                        }
                        return new SlotChangeAction(inventory.get(), this.inventorySlot, this.oldItem, this.newItem);
                    }
                    case -4: {
                        return new CraftingTakeResultAction(this.oldItem, this.newItem);
                    }
                    case -5: {
                        return new CraftingTransferMaterialAction(this.oldItem, this.newItem, this.inventorySlot);
                    }
                }
                if (this.windowId >= -13 && this.windowId <= -10) {
                    inv = player.getWindowById(2);
                    if (inv instanceof AnvilInventory) {
                        AnvilInventory anvil = (AnvilInventory)inv;
                        switch (this.windowId) {
                            case -10: {
                                this.inventorySlot = 0;
                                return new CraftingTransferMaterialAction(this.oldItem, this.newItem, this.inventorySlot);
                            }
                            case -11: {
                                this.inventorySlot = 1;
                                return new CraftingTransferMaterialAction(this.oldItem, this.newItem, this.inventorySlot);
                            }
                            case -13: {
                                break;
                            }
                            case -12: {
                                this.inventorySlot = 2;
                                anvil.setNewItemName(this.oldItem.getCustomName());
                                anvil.updateResult();
                                return new CraftingTakeResultAction(this.oldItem, this.newItem);
                            }
                        }
                    } else if (inv instanceof GrindstoneInventory) {
                        switch (this.windowId) {
                            case -10: {
                                this.inventorySlot = 0;
                                return new CraftingTransferMaterialAction(this.oldItem, this.newItem, this.inventorySlot);
                            }
                            case -11: {
                                this.inventorySlot = 1;
                                return new CraftingTransferMaterialAction(this.oldItem, this.newItem, this.inventorySlot);
                            }
                            case -13: {
                                break;
                            }
                            case -12: {
                                this.inventorySlot = 2;
                                return new CraftingTakeResultAction(this.oldItem, this.newItem);
                            }
                        }
                    } else {
                        player.getServer().getLogger().debug("Player " + player.getName() + " has no open anvil or grindstone inventory");
                        return null;
                    }
                }
                if (this.windowId >= -17 && this.windowId <= -15) {
                    inv = player.getWindowById(3);
                    if (!(inv instanceof EnchantInventory)) {
                        player.getServer().getLogger().debug("Player " + player.getName() + " has no open enchant inventory");
                        return null;
                    }
                    EnchantInventory enchant = (EnchantInventory)inv;
                    switch (this.windowId) {
                        case -15: {
                            if (this.inventorySlot == 0) break;
                            return null;
                        }
                        case -16: {
                            if (this.inventorySlot == 1) break;
                            return null;
                        }
                        case -17: {
                            if (this.inventorySlot != 0) {
                                return null;
                            }
                            if (Item.get(351, 4).equals(this.newItem, true, false)) {
                                this.inventorySlot = 2;
                                if (this.newItem.getCount() < 1 || this.newItem.getCount() > 3) {
                                    return null;
                                }
                                Item material = enchant.getItem(1);
                                int toRemove = this.newItem.getCount();
                                if (material.getId() == 351 || material.getDamage() == 4 || material.getCount() >= toRemove) break;
                                return null;
                            }
                            Item toEnchant = enchant.getItem(0);
                            Item material = enchant.getItem(1);
                            if (toEnchant.equals(this.newItem, true, true) && (material.getId() == 351 && material.getDamage() == 4 || player.isCreative())) {
                                this.inventorySlot = 3;
                                enchant.setItem(3, this.oldItem, false);
                                break;
                            }
                            return null;
                        }
                    }
                    return new SlotChangeAction(enchant, this.inventorySlot, this.oldItem, this.newItem);
                }
                if (this.windowId == -24) {
                    inv = player.getWindowById(4);
                    if (!(inv instanceof BeaconInventory)) {
                        player.getServer().getLogger().debug("Player " + player.getName() + " has no open beacon inventory");
                        return null;
                    }
                    BeaconInventory beacon = (BeaconInventory)inv;
                    this.inventorySlot = 0;
                    return new SlotChangeAction(beacon, this.inventorySlot, this.oldItem, this.newItem);
                }
                player.getServer().getLogger().debug("Player " + player.getName() + " has no open container with window ID " + this.windowId);
                return null;
            }
        }
        player.getServer().getLogger().debug("Unknown inventory source type " + this.sourceType);
        return null;
    }

    public String toString() {
        return "NetworkInventoryAction(sourceType=" + this.sourceType + ", windowId=" + this.windowId + ", unknown=" + this.unknown + ", inventorySlot=" + this.inventorySlot + ", oldItem=" + this.oldItem + ", newItem=" + this.newItem + ", stackNetworkId=" + this.stackNetworkId + ")";
    }
}

