/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.Server;
import cn.nukkit.utils.PlayerDataSerializer;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.UUID;

public class DefaultPlayerDataSerializer
implements PlayerDataSerializer {
    private final Server server;

    @Override
    public Optional<InputStream> read(String name, UUID uuid) throws IOException {
        String path = this.server.getDataPath() + "players/" + name + ".dat";
        File file = new File(path);
        if (!file.exists()) {
            return Optional.empty();
        }
        return Optional.of(new FileInputStream(file));
    }

    @Override
    public OutputStream write(String name, UUID uuid) throws IOException {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        String path = this.server.getDataPath() + "players/" + name + ".dat";
        File file = new File(path);
        return new FileOutputStream(file);
    }

    public DefaultPlayerDataSerializer(Server server) {
        this.server = server;
    }
}

