/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBeacon;
import cn.nukkit.inventory.BeaconInventory;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;

public class BlockBeacon
extends BlockTransparent {
    @Override
    public int getId() {
        return 138;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        return "Beacon";
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            BlockEntity t = this.getLevel().getBlockEntity(this);
            if (t instanceof BlockEntityBeacon) {
                BlockEntityBeacon beacon = (BlockEntityBeacon)t;
            } else {
                CompoundTag nbt = new CompoundTag("").putString("id", "Beacon").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
                BlockEntityBeacon beacon = (BlockEntityBeacon)BlockEntity.createBlockEntity("Beacon", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
                if (beacon == null) {
                    return false;
                }
            }
            player.addWindow(new BeaconInventory(player.getUIInventory(), this), 4);
        }
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean blockSuccess = super.place(item, block, target, face, fx, fy, fz, player);
        if (blockSuccess) {
            CompoundTag nbt = new CompoundTag("").putString("id", "Beacon").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
            BlockEntityBeacon beacon = (BlockEntityBeacon)BlockEntity.createBlockEntity("Beacon", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
            if (beacon == null) {
                return false;
            }
        }
        return blockSuccess;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DIAMOND_BLOCK_COLOR;
    }

    @Override
    public boolean canBePulled() {
        return false;
    }
}

