/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockEndPortalFrame
extends BlockTransparentMeta
implements Faceable {
    private static final int[] FACES = new int[]{2, 3, 0, 1};

    public BlockEndPortalFrame() {
        this(0);
    }

    public BlockEndPortalFrame(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 120;
    }

    @Override
    public double getResistance() {
        return 1.8E7;
    }

    @Override
    public double getHardness() {
        return -1.0;
    }

    @Override
    public int getLightLevel() {
        return 1;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public String getName() {
        return "End Portal Frame";
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public double getMaxY() {
        return this.y + ((this.getDamage() & 4) > 0 ? 1.0 : 0.8125);
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean canBePulled() {
        return false;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return (this.getDamage() & 4) != 0 ? 15 : 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if ((this.getDamage() & 4) == 0 && player != null && item.getId() == 381) {
            this.setDamage(this.getDamage() + 4);
            this.getLevel().setBlock((Vector3)this, this, true, true);
            this.getLevel().addLevelSoundEvent(this, 173);
            return true;
        }
        return false;
    }

    @Since(value="1.3.0.0-PN")
    public void createPortal() {
        Vector3 centerSpot = this.searchCenter();
        if (centerSpot != null) {
            int z;
            int x;
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    if ((x == -2 || x == 2) && (z == -2 || z == 2) || x != -2 && x != 2 && z != -2 && z != 2 || this.checkFrame(this.getLevel().getBlock(centerSpot.add(x, 0.0, z)), x, z)) continue;
                    return;
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    Vector3 vector3 = centerSpot.add(x, 0.0, z);
                    if (this.getLevel().getBlock(vector3).getId() != 0) {
                        this.getLevel().useBreakOn(vector3);
                    }
                    this.getLevel().setBlock(vector3, Block.get(119));
                }
            }
        }
    }

    private Vector3 searchCenter() {
        Block iBlock;
        Block block;
        for (int x = -2; x <= 2; ++x) {
            if (x == 0) continue;
            block = this.getLevel().getBlock(this.add(x, 0.0, 0.0));
            iBlock = this.getLevel().getBlock(this.add(x * 2, 0.0, 0.0));
            if (!this.checkFrame(block)) continue;
            if ((x == -1 || x == 1) && this.checkFrame(iBlock)) {
                return ((BlockEndPortalFrame)block).searchCenter();
            }
            for (int z = -4; z <= 4; ++z) {
                if (z == 0 || !this.checkFrame(block = this.getLevel().getBlock(this.add(x, 0.0, z)))) continue;
                return this.add(x / 2, 0.0, z / 2);
            }
        }
        for (int z = -2; z <= 2; ++z) {
            if (z == 0) continue;
            block = this.getLevel().getBlock(this.add(0.0, 0.0, z));
            iBlock = this.getLevel().getBlock(this.add(0.0, 0.0, z * 2));
            if (!this.checkFrame(block)) continue;
            if ((z == -1 || z == 1) && this.checkFrame(iBlock)) {
                return ((BlockEndPortalFrame)block).searchCenter();
            }
            for (int x = -4; x <= 4; ++x) {
                if (x == 0 || !this.checkFrame(block = this.getLevel().getBlock(this.add(x, 0.0, z)))) continue;
                return this.add(x / 2, 0.0, z / 2);
            }
        }
        return null;
    }

    private boolean checkFrame(Block block) {
        return block.getId() == this.getId() && (block.getDamage() & 4) == 4;
    }

    private boolean checkFrame(Block block, int x, int z) {
        return block.getId() == this.getId() && block.getDamage() - 4 == (x == -2 ? 3 : (x == 2 ? 1 : (z == -2 ? 0 : (z == 2 ? 2 : -1))));
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(FACES[player != null ? player.getDirection().getHorizontalIndex() : 0]);
        this.getLevel().setBlock((Vector3)block, this, true);
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GREEN_BLOCK_COLOR;
    }
}

