/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.block.BlockSnowLayer;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockTNT;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.event.block.BlockBurnEvent;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.event.block.BlockIgniteEvent;
import cn.nukkit.event.entity.EntityCombustByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.GameRule;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class BlockFire
extends BlockFlowable {
    public BlockFire() {
        this(0);
    }

    public BlockFire(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 51;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public String getName() {
        return "Fire Block";
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (!entity.hasEffect(12)) {
            entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.FIRE, 1.0f));
        }
        EntityCombustByBlockEvent ev = new EntityCombustByBlockEvent(this, entity, 8);
        if (entity instanceof EntityArrow) {
            ev.setCancelled();
        }
        Server.getInstance().getPluginManager().callEvent(ev);
        if (!ev.isCancelled() && entity.isAlive() && entity.noDamageTicks == 0) {
            entity.setOnFire(ev.getDuration());
        }
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[0];
    }

    @Override
    public int onUpdate(int type) {
        block15: {
            int meta;
            ThreadLocalRandom random;
            boolean forever;
            block17: {
                block16: {
                    BlockFadeEvent event;
                    if (type == 1 || type == 2) {
                        if (!this.isBlockTopFacingSurfaceSolid(this.down()) && !this.canNeighborBurn()) {
                            BlockFadeEvent event2 = new BlockFadeEvent(this, BlockFire.get(0));
                            this.level.getServer().getPluginManager().callEvent(event2);
                            if (!event2.isCancelled()) {
                                this.level.setBlock((Vector3)this, event2.getNewState(), true);
                            }
                        }
                        return 1;
                    }
                    if (type != 3 || !this.level.gameRules.getBoolean(GameRule.DO_FIRE_TICK)) break block15;
                    forever = this.down().getId() == 87 || this.down().getId() == 213;
                    random = ThreadLocalRandom.current();
                    if (!this.isBlockTopFacingSurfaceSolid(this.down()) && !this.canNeighborBurn()) {
                        event = new BlockFadeEvent(this, BlockFire.get(0));
                        this.level.getServer().getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            this.level.setBlock((Vector3)this, event.getNewState(), true);
                        }
                    }
                    if (forever || !this.getLevel().isRaining() || !this.getLevel().canBlockSeeSky(this) && !this.getLevel().canBlockSeeSky(this.east()) && !this.getLevel().canBlockSeeSky(this.west()) && !this.getLevel().canBlockSeeSky(this.south()) && !this.getLevel().canBlockSeeSky(this.north())) break block16;
                    event = new BlockFadeEvent(this, BlockFire.get(0));
                    this.level.getServer().getPluginManager().callEvent(event);
                    if (!event.isCancelled()) {
                        this.level.setBlock((Vector3)this, event.getNewState(), true);
                    }
                    break block15;
                }
                meta = this.getDamage();
                if (meta < 15) {
                    int newMeta = meta + random.nextInt(3);
                    this.setDamage(Math.min(newMeta, 15));
                    this.getLevel().setBlock((Vector3)this, this, true);
                }
                this.getLevel().scheduleUpdate(this, this.tickRate() + random.nextInt(10));
                if (forever || this.canNeighborBurn()) break block17;
                if (this.isBlockTopFacingSurfaceSolid(this.down()) && meta <= 3) break block15;
                BlockFadeEvent event = new BlockFadeEvent(this, BlockFire.get(0));
                this.level.getServer().getPluginManager().callEvent(event);
                if (event.isCancelled()) break block15;
                this.level.setBlock((Vector3)this, event.getNewState(), true);
                break block15;
            }
            if (!forever && this.down().getBurnAbility() <= 0 && meta == 15 && random.nextInt(4) == 0) {
                BlockFadeEvent event = new BlockFadeEvent(this, BlockFire.get(0));
                this.level.getServer().getPluginManager().callEvent(event);
                if (!event.isCancelled()) {
                    this.level.setBlock((Vector3)this, event.getNewState(), true);
                }
            } else {
                int o = 0;
                this.tryToCatchBlockOnFire(this.east(), 300 + o, meta);
                this.tryToCatchBlockOnFire(this.west(), 300 + o, meta);
                this.tryToCatchBlockOnFire(this.down(), 250 + o, meta);
                this.tryToCatchBlockOnFire(this.up(), 250 + o, meta);
                this.tryToCatchBlockOnFire(this.south(), 300 + o, meta);
                this.tryToCatchBlockOnFire(this.north(), 300 + o, meta);
                for (int x = (int)(this.x - 1.0); x <= (int)(this.x + 1.0); ++x) {
                    for (int z = (int)(this.z - 1.0); z <= (int)(this.z + 1.0); ++z) {
                        for (int y = (int)(this.y - 1.0); y <= (int)(this.y + 4.0); ++y) {
                            int t;
                            Block block;
                            int chance;
                            if (x == (int)this.x && y == (int)this.y && z == (int)this.z) continue;
                            int k = 100;
                            if ((double)y > this.y + 1.0) {
                                k = (int)((double)k + ((double)y - (this.y + 1.0)) * 100.0);
                            }
                            if ((chance = this.getChanceOfNeighborsEncouragingFire(block = this.getLevel().getBlock(new Vector3(x, y, z)))) <= 0 || (t = (chance + 40 + this.getLevel().getServer().getDifficulty() * 7) / (meta + 30)) <= 0 || random.nextInt(k) > t) continue;
                            int damage = meta + random.nextInt(5) / 4;
                            if (damage > 15) {
                                damage = 15;
                            }
                            BlockIgniteEvent e = new BlockIgniteEvent(block, this, null, BlockIgniteEvent.BlockIgniteCause.SPREAD);
                            this.level.getServer().getPluginManager().callEvent(e);
                            if (e.isCancelled()) continue;
                            this.getLevel().setBlock((Vector3)block, Block.get(51, damage), true);
                            this.getLevel().scheduleUpdate(block, this.tickRate());
                        }
                    }
                }
            }
        }
        return 0;
    }

    private void tryToCatchBlockOnFire(Block block, int bound, int damage) {
        int burnAbility = block.getBurnAbility();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (((Random)random).nextInt(bound) < burnAbility) {
            if (((Random)random).nextInt(damage + 10) < 5) {
                int meta = damage + ((Random)random).nextInt(5) / 4;
                if (meta > 15) {
                    meta = 15;
                }
                BlockIgniteEvent e = new BlockIgniteEvent(block, this, null, BlockIgniteEvent.BlockIgniteCause.SPREAD);
                this.level.getServer().getPluginManager().callEvent(e);
                if (!e.isCancelled()) {
                    this.getLevel().setBlock((Vector3)block, Block.get(51, meta), true);
                    this.getLevel().scheduleUpdate(block, this.tickRate());
                }
            } else {
                BlockBurnEvent ev = new BlockBurnEvent(block);
                this.getLevel().getServer().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    this.getLevel().setBlock((Vector3)block, Block.get(0), true);
                }
            }
            if (block instanceof BlockTNT) {
                ((BlockTNT)block).prime();
            }
        }
    }

    private int getChanceOfNeighborsEncouragingFire(Block block) {
        if (block.getId() != 0) {
            return 0;
        }
        int chance = 0;
        chance = Math.max(chance, block.east().getBurnChance());
        chance = Math.max(chance, block.west().getBurnChance());
        chance = Math.max(chance, block.down().getBurnChance());
        chance = Math.max(chance, block.up().getBurnChance());
        chance = Math.max(chance, block.south().getBurnChance());
        chance = Math.max(chance, block.north().getBurnChance());
        return chance;
    }

    public boolean canNeighborBurn() {
        for (BlockFace face : BlockFace.values()) {
            if (this.getSide(face).getBurnChance() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockTopFacingSurfaceSolid(Block block) {
        if (block != null) {
            if (block.isSolid()) {
                return true;
            }
            if (block instanceof BlockStairs && (block.getDamage() & 4) == 4) {
                return true;
            }
            if (block instanceof BlockSlab && (block.getDamage() & 8) == 8) {
                return true;
            }
            if (block instanceof BlockSnowLayer && (block.getDamage() & 7) == 7) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int tickRate() {
        return 30;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.LAVA_BLOCK_COLOR;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return this;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(0));
    }
}

