/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockID;
import cn.nukkit.entity.Entity;
import cn.nukkit.inventory.Fuel;
import cn.nukkit.item.ItemAcaciaSign;
import cn.nukkit.item.ItemApple;
import cn.nukkit.item.ItemAppleGold;
import cn.nukkit.item.ItemAppleGoldEnchanted;
import cn.nukkit.item.ItemArrow;
import cn.nukkit.item.ItemAxeDiamond;
import cn.nukkit.item.ItemAxeGold;
import cn.nukkit.item.ItemAxeIron;
import cn.nukkit.item.ItemAxeStone;
import cn.nukkit.item.ItemAxeWood;
import cn.nukkit.item.ItemBanner;
import cn.nukkit.item.ItemBannerPattern;
import cn.nukkit.item.ItemBed;
import cn.nukkit.item.ItemBeefRaw;
import cn.nukkit.item.ItemBeetroot;
import cn.nukkit.item.ItemBeetrootSoup;
import cn.nukkit.item.ItemBirchSign;
import cn.nukkit.item.ItemBlazePowder;
import cn.nukkit.item.ItemBlazeRod;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemBoat;
import cn.nukkit.item.ItemBone;
import cn.nukkit.item.ItemBook;
import cn.nukkit.item.ItemBookAndQuill;
import cn.nukkit.item.ItemBookEnchanted;
import cn.nukkit.item.ItemBookWritten;
import cn.nukkit.item.ItemBootsChain;
import cn.nukkit.item.ItemBootsDiamond;
import cn.nukkit.item.ItemBootsGold;
import cn.nukkit.item.ItemBootsIron;
import cn.nukkit.item.ItemBootsLeather;
import cn.nukkit.item.ItemBow;
import cn.nukkit.item.ItemBowl;
import cn.nukkit.item.ItemBread;
import cn.nukkit.item.ItemBrewingStand;
import cn.nukkit.item.ItemBrick;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.ItemCake;
import cn.nukkit.item.ItemCampfire;
import cn.nukkit.item.ItemCarrot;
import cn.nukkit.item.ItemCarrotGolden;
import cn.nukkit.item.ItemCarrotOnAStick;
import cn.nukkit.item.ItemCauldron;
import cn.nukkit.item.ItemChestplateChain;
import cn.nukkit.item.ItemChestplateDiamond;
import cn.nukkit.item.ItemChestplateGold;
import cn.nukkit.item.ItemChestplateIron;
import cn.nukkit.item.ItemChestplateLeather;
import cn.nukkit.item.ItemChickenCooked;
import cn.nukkit.item.ItemChickenRaw;
import cn.nukkit.item.ItemChorusFruit;
import cn.nukkit.item.ItemClay;
import cn.nukkit.item.ItemClock;
import cn.nukkit.item.ItemClownfish;
import cn.nukkit.item.ItemCoal;
import cn.nukkit.item.ItemCompass;
import cn.nukkit.item.ItemCookie;
import cn.nukkit.item.ItemDarkOakSign;
import cn.nukkit.item.ItemDiamond;
import cn.nukkit.item.ItemDoorAcacia;
import cn.nukkit.item.ItemDoorBirch;
import cn.nukkit.item.ItemDoorDarkOak;
import cn.nukkit.item.ItemDoorIron;
import cn.nukkit.item.ItemDoorJungle;
import cn.nukkit.item.ItemDoorSpruce;
import cn.nukkit.item.ItemDoorWood;
import cn.nukkit.item.ItemDriedKelp;
import cn.nukkit.item.ItemDye;
import cn.nukkit.item.ItemEgg;
import cn.nukkit.item.ItemElytra;
import cn.nukkit.item.ItemEmerald;
import cn.nukkit.item.ItemEmptyMap;
import cn.nukkit.item.ItemEndCrystal;
import cn.nukkit.item.ItemEnderEye;
import cn.nukkit.item.ItemEnderPearl;
import cn.nukkit.item.ItemExpBottle;
import cn.nukkit.item.ItemFeather;
import cn.nukkit.item.ItemFireCharge;
import cn.nukkit.item.ItemFirework;
import cn.nukkit.item.ItemFish;
import cn.nukkit.item.ItemFishCooked;
import cn.nukkit.item.ItemFishingRod;
import cn.nukkit.item.ItemFlint;
import cn.nukkit.item.ItemFlintSteel;
import cn.nukkit.item.ItemFlowerPot;
import cn.nukkit.item.ItemGhastTear;
import cn.nukkit.item.ItemGlassBottle;
import cn.nukkit.item.ItemGlowstoneDust;
import cn.nukkit.item.ItemGunpowder;
import cn.nukkit.item.ItemHelmetChain;
import cn.nukkit.item.ItemHelmetDiamond;
import cn.nukkit.item.ItemHelmetGold;
import cn.nukkit.item.ItemHelmetIron;
import cn.nukkit.item.ItemHelmetLeather;
import cn.nukkit.item.ItemHoeDiamond;
import cn.nukkit.item.ItemHoeGold;
import cn.nukkit.item.ItemHoeIron;
import cn.nukkit.item.ItemHoeStone;
import cn.nukkit.item.ItemHoeWood;
import cn.nukkit.item.ItemHoneyBottle;
import cn.nukkit.item.ItemHoneycomb;
import cn.nukkit.item.ItemHopper;
import cn.nukkit.item.ItemHorseArmorDiamond;
import cn.nukkit.item.ItemHorseArmorGold;
import cn.nukkit.item.ItemHorseArmorIron;
import cn.nukkit.item.ItemHorseArmorLeather;
import cn.nukkit.item.ItemID;
import cn.nukkit.item.ItemIngotGold;
import cn.nukkit.item.ItemIngotIron;
import cn.nukkit.item.ItemItemFrame;
import cn.nukkit.item.ItemJungleSign;
import cn.nukkit.item.ItemKelp;
import cn.nukkit.item.ItemLeather;
import cn.nukkit.item.ItemLeggingsChain;
import cn.nukkit.item.ItemLeggingsDiamond;
import cn.nukkit.item.ItemLeggingsGold;
import cn.nukkit.item.ItemLeggingsIron;
import cn.nukkit.item.ItemLeggingsLeather;
import cn.nukkit.item.ItemMagmaCream;
import cn.nukkit.item.ItemMap;
import cn.nukkit.item.ItemMelon;
import cn.nukkit.item.ItemMelonGlistering;
import cn.nukkit.item.ItemMinecart;
import cn.nukkit.item.ItemMinecartChest;
import cn.nukkit.item.ItemMinecartHopper;
import cn.nukkit.item.ItemMinecartTNT;
import cn.nukkit.item.ItemMushroomStew;
import cn.nukkit.item.ItemMuttonCooked;
import cn.nukkit.item.ItemMuttonRaw;
import cn.nukkit.item.ItemNameTag;
import cn.nukkit.item.ItemNetherBrick;
import cn.nukkit.item.ItemNetherStar;
import cn.nukkit.item.ItemNetherWart;
import cn.nukkit.item.ItemNuggetGold;
import cn.nukkit.item.ItemPainting;
import cn.nukkit.item.ItemPaper;
import cn.nukkit.item.ItemPickaxeDiamond;
import cn.nukkit.item.ItemPickaxeGold;
import cn.nukkit.item.ItemPickaxeIron;
import cn.nukkit.item.ItemPickaxeStone;
import cn.nukkit.item.ItemPickaxeWood;
import cn.nukkit.item.ItemPorkchopCooked;
import cn.nukkit.item.ItemPorkchopRaw;
import cn.nukkit.item.ItemPotato;
import cn.nukkit.item.ItemPotatoBaked;
import cn.nukkit.item.ItemPotatoPoisonous;
import cn.nukkit.item.ItemPotion;
import cn.nukkit.item.ItemPotionLingering;
import cn.nukkit.item.ItemPotionSplash;
import cn.nukkit.item.ItemPrismarineCrystals;
import cn.nukkit.item.ItemPrismarineShard;
import cn.nukkit.item.ItemPufferfish;
import cn.nukkit.item.ItemPumpkinPie;
import cn.nukkit.item.ItemQuartz;
import cn.nukkit.item.ItemRabbitCooked;
import cn.nukkit.item.ItemRabbitFoot;
import cn.nukkit.item.ItemRabbitRaw;
import cn.nukkit.item.ItemRabbitStew;
import cn.nukkit.item.ItemRecord11;
import cn.nukkit.item.ItemRecord13;
import cn.nukkit.item.ItemRecordBlocks;
import cn.nukkit.item.ItemRecordCat;
import cn.nukkit.item.ItemRecordChirp;
import cn.nukkit.item.ItemRecordFar;
import cn.nukkit.item.ItemRecordMall;
import cn.nukkit.item.ItemRecordMellohi;
import cn.nukkit.item.ItemRecordStal;
import cn.nukkit.item.ItemRecordStrad;
import cn.nukkit.item.ItemRecordWait;
import cn.nukkit.item.ItemRecordWard;
import cn.nukkit.item.ItemRedstone;
import cn.nukkit.item.ItemRedstoneComparator;
import cn.nukkit.item.ItemRedstoneRepeater;
import cn.nukkit.item.ItemRottenFlesh;
import cn.nukkit.item.ItemSaddle;
import cn.nukkit.item.ItemSalmon;
import cn.nukkit.item.ItemSalmonCooked;
import cn.nukkit.item.ItemSeedsBeetroot;
import cn.nukkit.item.ItemSeedsMelon;
import cn.nukkit.item.ItemSeedsPumpkin;
import cn.nukkit.item.ItemSeedsWheat;
import cn.nukkit.item.ItemShears;
import cn.nukkit.item.ItemShield;
import cn.nukkit.item.ItemShovelDiamond;
import cn.nukkit.item.ItemShovelGold;
import cn.nukkit.item.ItemShovelIron;
import cn.nukkit.item.ItemShovelStone;
import cn.nukkit.item.ItemShovelWood;
import cn.nukkit.item.ItemShulkerShell;
import cn.nukkit.item.ItemSign;
import cn.nukkit.item.ItemSkull;
import cn.nukkit.item.ItemSlimeball;
import cn.nukkit.item.ItemSnowball;
import cn.nukkit.item.ItemSpawnEgg;
import cn.nukkit.item.ItemSpiderEye;
import cn.nukkit.item.ItemSpiderEyeFermented;
import cn.nukkit.item.ItemSpruceSign;
import cn.nukkit.item.ItemSteak;
import cn.nukkit.item.ItemStick;
import cn.nukkit.item.ItemString;
import cn.nukkit.item.ItemSugar;
import cn.nukkit.item.ItemSugarcane;
import cn.nukkit.item.ItemSuspiciousStew;
import cn.nukkit.item.ItemSweetBerries;
import cn.nukkit.item.ItemSwordDiamond;
import cn.nukkit.item.ItemSwordGold;
import cn.nukkit.item.ItemSwordIron;
import cn.nukkit.item.ItemSwordStone;
import cn.nukkit.item.ItemSwordWood;
import cn.nukkit.item.ItemTotem;
import cn.nukkit.item.ItemTrident;
import cn.nukkit.item.ItemTurtleShell;
import cn.nukkit.item.ItemWheat;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.Level;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Item
implements Cloneable,
BlockID,
ItemID {
    protected static String UNKNOWN_STR = "Unknown";
    public static Class[] list = null;
    protected Block block = null;
    protected final int id;
    protected int meta;
    protected boolean hasMeta = true;
    private byte[] tags = new byte[0];
    private CompoundTag cachedNBT = null;
    public int count;
    protected int durability = 0;
    protected String name;
    private static final ArrayList<Item> creative = new ArrayList();

    public Item(int id) {
        this(id, 0, 1, UNKNOWN_STR);
    }

    public Item(int id, Integer meta) {
        this(id, meta, 1, UNKNOWN_STR);
    }

    public Item(int id, Integer meta, int count) {
        this(id, meta, count, UNKNOWN_STR);
    }

    public Item(int id, Integer meta, int count, String name) {
        this.id = id;
        if (meta != null && meta >= 0) {
            this.meta = meta & 0xFFFF;
        } else {
            this.hasMeta = false;
        }
        this.count = count;
        this.name = name;
    }

    public boolean hasMeta() {
        return this.hasMeta;
    }

    public boolean canBeActivated() {
        return false;
    }

    public static void init() {
        if (list == null) {
            list = new Class[65535];
            Item.list[256] = ItemShovelIron.class;
            Item.list[257] = ItemPickaxeIron.class;
            Item.list[258] = ItemAxeIron.class;
            Item.list[259] = ItemFlintSteel.class;
            Item.list[260] = ItemApple.class;
            Item.list[261] = ItemBow.class;
            Item.list[262] = ItemArrow.class;
            Item.list[263] = ItemCoal.class;
            Item.list[264] = ItemDiamond.class;
            Item.list[265] = ItemIngotIron.class;
            Item.list[266] = ItemIngotGold.class;
            Item.list[267] = ItemSwordIron.class;
            Item.list[268] = ItemSwordWood.class;
            Item.list[269] = ItemShovelWood.class;
            Item.list[270] = ItemPickaxeWood.class;
            Item.list[271] = ItemAxeWood.class;
            Item.list[272] = ItemSwordStone.class;
            Item.list[273] = ItemShovelStone.class;
            Item.list[274] = ItemPickaxeStone.class;
            Item.list[275] = ItemAxeStone.class;
            Item.list[276] = ItemSwordDiamond.class;
            Item.list[277] = ItemShovelDiamond.class;
            Item.list[278] = ItemPickaxeDiamond.class;
            Item.list[279] = ItemAxeDiamond.class;
            Item.list[280] = ItemStick.class;
            Item.list[281] = ItemBowl.class;
            Item.list[282] = ItemMushroomStew.class;
            Item.list[283] = ItemSwordGold.class;
            Item.list[284] = ItemShovelGold.class;
            Item.list[285] = ItemPickaxeGold.class;
            Item.list[286] = ItemAxeGold.class;
            Item.list[287] = ItemString.class;
            Item.list[288] = ItemFeather.class;
            Item.list[289] = ItemGunpowder.class;
            Item.list[290] = ItemHoeWood.class;
            Item.list[291] = ItemHoeStone.class;
            Item.list[292] = ItemHoeIron.class;
            Item.list[293] = ItemHoeDiamond.class;
            Item.list[294] = ItemHoeGold.class;
            Item.list[295] = ItemSeedsWheat.class;
            Item.list[296] = ItemWheat.class;
            Item.list[297] = ItemBread.class;
            Item.list[298] = ItemHelmetLeather.class;
            Item.list[299] = ItemChestplateLeather.class;
            Item.list[300] = ItemLeggingsLeather.class;
            Item.list[301] = ItemBootsLeather.class;
            Item.list[302] = ItemHelmetChain.class;
            Item.list[303] = ItemChestplateChain.class;
            Item.list[304] = ItemLeggingsChain.class;
            Item.list[305] = ItemBootsChain.class;
            Item.list[306] = ItemHelmetIron.class;
            Item.list[307] = ItemChestplateIron.class;
            Item.list[308] = ItemLeggingsIron.class;
            Item.list[309] = ItemBootsIron.class;
            Item.list[310] = ItemHelmetDiamond.class;
            Item.list[311] = ItemChestplateDiamond.class;
            Item.list[312] = ItemLeggingsDiamond.class;
            Item.list[313] = ItemBootsDiamond.class;
            Item.list[314] = ItemHelmetGold.class;
            Item.list[315] = ItemChestplateGold.class;
            Item.list[316] = ItemLeggingsGold.class;
            Item.list[317] = ItemBootsGold.class;
            Item.list[318] = ItemFlint.class;
            Item.list[319] = ItemPorkchopRaw.class;
            Item.list[320] = ItemPorkchopCooked.class;
            Item.list[321] = ItemPainting.class;
            Item.list[322] = ItemAppleGold.class;
            Item.list[323] = ItemSign.class;
            Item.list[324] = ItemDoorWood.class;
            Item.list[325] = ItemBucket.class;
            Item.list[328] = ItemMinecart.class;
            Item.list[329] = ItemSaddle.class;
            Item.list[330] = ItemDoorIron.class;
            Item.list[331] = ItemRedstone.class;
            Item.list[332] = ItemSnowball.class;
            Item.list[333] = ItemBoat.class;
            Item.list[334] = ItemLeather.class;
            Item.list[335] = ItemKelp.class;
            Item.list[336] = ItemBrick.class;
            Item.list[337] = ItemClay.class;
            Item.list[338] = ItemSugarcane.class;
            Item.list[339] = ItemPaper.class;
            Item.list[340] = ItemBook.class;
            Item.list[341] = ItemSlimeball.class;
            Item.list[342] = ItemMinecartChest.class;
            Item.list[344] = ItemEgg.class;
            Item.list[345] = ItemCompass.class;
            Item.list[346] = ItemFishingRod.class;
            Item.list[347] = ItemClock.class;
            Item.list[348] = ItemGlowstoneDust.class;
            Item.list[349] = ItemFish.class;
            Item.list[350] = ItemFishCooked.class;
            Item.list[351] = ItemDye.class;
            Item.list[352] = ItemBone.class;
            Item.list[353] = ItemSugar.class;
            Item.list[354] = ItemCake.class;
            Item.list[355] = ItemBed.class;
            Item.list[356] = ItemRedstoneRepeater.class;
            Item.list[357] = ItemCookie.class;
            Item.list[358] = ItemMap.class;
            Item.list[359] = ItemShears.class;
            Item.list[360] = ItemMelon.class;
            Item.list[361] = ItemSeedsPumpkin.class;
            Item.list[362] = ItemSeedsMelon.class;
            Item.list[363] = ItemBeefRaw.class;
            Item.list[364] = ItemSteak.class;
            Item.list[365] = ItemChickenRaw.class;
            Item.list[366] = ItemChickenCooked.class;
            Item.list[367] = ItemRottenFlesh.class;
            Item.list[368] = ItemEnderPearl.class;
            Item.list[369] = ItemBlazeRod.class;
            Item.list[370] = ItemGhastTear.class;
            Item.list[371] = ItemNuggetGold.class;
            Item.list[372] = ItemNetherWart.class;
            Item.list[373] = ItemPotion.class;
            Item.list[374] = ItemGlassBottle.class;
            Item.list[375] = ItemSpiderEye.class;
            Item.list[376] = ItemSpiderEyeFermented.class;
            Item.list[377] = ItemBlazePowder.class;
            Item.list[378] = ItemMagmaCream.class;
            Item.list[379] = ItemBrewingStand.class;
            Item.list[380] = ItemCauldron.class;
            Item.list[381] = ItemEnderEye.class;
            Item.list[382] = ItemMelonGlistering.class;
            Item.list[383] = ItemSpawnEgg.class;
            Item.list[384] = ItemExpBottle.class;
            Item.list[385] = ItemFireCharge.class;
            Item.list[386] = ItemBookAndQuill.class;
            Item.list[387] = ItemBookWritten.class;
            Item.list[388] = ItemEmerald.class;
            Item.list[389] = ItemItemFrame.class;
            Item.list[390] = ItemFlowerPot.class;
            Item.list[391] = ItemCarrot.class;
            Item.list[392] = ItemPotato.class;
            Item.list[393] = ItemPotatoBaked.class;
            Item.list[394] = ItemPotatoPoisonous.class;
            Item.list[395] = ItemEmptyMap.class;
            Item.list[396] = ItemCarrotGolden.class;
            Item.list[397] = ItemSkull.class;
            Item.list[398] = ItemCarrotOnAStick.class;
            Item.list[399] = ItemNetherStar.class;
            Item.list[400] = ItemPumpkinPie.class;
            Item.list[401] = ItemFirework.class;
            Item.list[403] = ItemBookEnchanted.class;
            Item.list[404] = ItemRedstoneComparator.class;
            Item.list[405] = ItemNetherBrick.class;
            Item.list[406] = ItemQuartz.class;
            Item.list[407] = ItemMinecartTNT.class;
            Item.list[408] = ItemMinecartHopper.class;
            Item.list[409] = ItemPrismarineShard.class;
            Item.list[410] = ItemHopper.class;
            Item.list[411] = ItemRabbitRaw.class;
            Item.list[412] = ItemRabbitCooked.class;
            Item.list[413] = ItemRabbitStew.class;
            Item.list[414] = ItemRabbitFoot.class;
            Item.list[416] = ItemHorseArmorLeather.class;
            Item.list[417] = ItemHorseArmorIron.class;
            Item.list[418] = ItemHorseArmorGold.class;
            Item.list[419] = ItemHorseArmorDiamond.class;
            Item.list[421] = ItemNameTag.class;
            Item.list[422] = ItemPrismarineCrystals.class;
            Item.list[423] = ItemMuttonRaw.class;
            Item.list[424] = ItemMuttonCooked.class;
            Item.list[426] = ItemEndCrystal.class;
            Item.list[427] = ItemDoorSpruce.class;
            Item.list[428] = ItemDoorBirch.class;
            Item.list[429] = ItemDoorJungle.class;
            Item.list[430] = ItemDoorAcacia.class;
            Item.list[431] = ItemDoorDarkOak.class;
            Item.list[432] = ItemChorusFruit.class;
            Item.list[434] = ItemBannerPattern.class;
            Item.list[438] = ItemPotionSplash.class;
            Item.list[441] = ItemPotionLingering.class;
            Item.list[444] = ItemElytra.class;
            Item.list[445] = ItemShulkerShell.class;
            Item.list[446] = ItemBanner.class;
            Item.list[450] = ItemTotem.class;
            Item.list[455] = ItemTrident.class;
            Item.list[457] = ItemBeetroot.class;
            Item.list[458] = ItemSeedsBeetroot.class;
            Item.list[459] = ItemBeetrootSoup.class;
            Item.list[460] = ItemSalmon.class;
            Item.list[461] = ItemClownfish.class;
            Item.list[462] = ItemPufferfish.class;
            Item.list[463] = ItemSalmonCooked.class;
            Item.list[464] = ItemDriedKelp.class;
            Item.list[466] = ItemAppleGoldEnchanted.class;
            Item.list[469] = ItemTurtleShell.class;
            Item.list[472] = ItemSpruceSign.class;
            Item.list[473] = ItemBirchSign.class;
            Item.list[474] = ItemJungleSign.class;
            Item.list[475] = ItemAcaciaSign.class;
            Item.list[476] = ItemDarkOakSign.class;
            Item.list[477] = ItemSweetBerries.class;
            Item.list[510] = ItemRecord11.class;
            Item.list[501] = ItemRecordCat.class;
            Item.list[500] = ItemRecord13.class;
            Item.list[502] = ItemRecordBlocks.class;
            Item.list[503] = ItemRecordChirp.class;
            Item.list[504] = ItemRecordFar.class;
            Item.list[509] = ItemRecordWard.class;
            Item.list[505] = ItemRecordMall.class;
            Item.list[506] = ItemRecordMellohi.class;
            Item.list[507] = ItemRecordStal.class;
            Item.list[508] = ItemRecordStrad.class;
            Item.list[511] = ItemRecordWait.class;
            Item.list[513] = ItemShield.class;
            Item.list[720] = ItemCampfire.class;
            Item.list[734] = ItemSuspiciousStew.class;
            Item.list[736] = ItemHoneycomb.class;
            Item.list[737] = ItemHoneyBottle.class;
            for (int i = 0; i < 256; ++i) {
                if (Block.list[i] == null) continue;
                Item.list[i] = Block.list[i];
            }
        }
        Item.initCreativeItems();
    }

    private static void initCreativeItems() {
        Item.clearCreativeItems();
        Config config = new Config(1);
        config.load(Server.class.getClassLoader().getResourceAsStream("creativeitems.json"));
        List<Map> list = config.getMapList("items");
        for (Map map : list) {
            try {
                Item.addCreativeItem(Item.fromJson(map));
            }
            catch (Exception e) {
                MainLogger.getLogger().logException(e);
            }
        }
    }

    public static void clearCreativeItems() {
        creative.clear();
    }

    public static ArrayList<Item> getCreativeItems() {
        return new ArrayList<Item>(creative);
    }

    public static void addCreativeItem(Item item) {
        creative.add(item.clone());
    }

    public static void removeCreativeItem(Item item) {
        int index = Item.getCreativeItemIndex(item);
        if (index != -1) {
            creative.remove(index);
        }
    }

    public static boolean isCreativeItem(Item item) {
        for (Item aCreative : creative) {
            if (!item.equals(aCreative, !item.isTool())) continue;
            return true;
        }
        return false;
    }

    public static Item getCreativeItem(int index) {
        return index >= 0 && index < creative.size() ? creative.get(index) : null;
    }

    public static int getCreativeItemIndex(Item item) {
        for (int i = 0; i < creative.size(); ++i) {
            if (!item.equals(creative.get(i), !item.isTool())) continue;
            return i;
        }
        return -1;
    }

    public static Item getBlock(int id) {
        return Item.getBlock(id, 0);
    }

    public static Item getBlock(int id, Integer meta) {
        return Item.getBlock(id, meta, 1);
    }

    public static Item getBlock(int id, Integer meta, int count) {
        return Item.getBlock(id, meta, count, new byte[0]);
    }

    public static Item getBlock(int id, Integer meta, int count, byte[] tags) {
        if (id > 255) {
            id = 255 - id;
        }
        return Item.get(id, meta, count, tags);
    }

    public static Item get(int id) {
        return Item.get(id, 0);
    }

    public static Item get(int id, Integer meta) {
        return Item.get(id, meta, 1);
    }

    public static Item get(int id, Integer meta, int count) {
        return Item.get(id, meta, count, new byte[0]);
    }

    public static Item get(int id, Integer meta, int count, byte[] tags) {
        try {
            Class c = null;
            if (id < 0) {
                int blockId = 255 - id;
                c = Block.list[blockId];
            } else {
                c = list[id];
            }
            Item item = c == null ? new Item(id, meta, count) : (id < 256 ? (meta >= 0 ? new ItemBlock(Block.get(id, meta), meta, count) : new ItemBlock(Block.get(id), meta, count)) : (Item)c.getConstructor(Integer.class, Integer.TYPE).newInstance(meta, count));
            if (tags.length != 0) {
                item.setCompoundTag(tags);
            }
            return item;
        }
        catch (Exception e) {
            return new Item(id, meta, count).setCompoundTag(tags);
        }
    }

    public static Item fromString(String str) {
        String[] b = str.trim().replace(' ', '_').replace("minecraft:", "").split(":");
        int id = 0;
        int meta = 0;
        Pattern integerPattern = Pattern.compile("^-?[1-9]\\d*$");
        if (integerPattern.matcher(b[0]).matches()) {
            id = Integer.valueOf(b[0]);
        } else {
            try {
                id = BlockID.class.getField(b[0].toUpperCase()).getInt(null);
                if (id > 255) {
                    id = 255 - id;
                }
            }
            catch (Exception ignore1) {
                try {
                    id = ItemID.class.getField(b[0].toUpperCase()).getInt(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (b.length != 1) {
            meta = Integer.valueOf(b[1]) & 0xFFFF;
        }
        return Item.get(id, meta);
    }

    public static Item fromJson(Map<String, Object> data) {
        String nbt = (String)data.get("nbt_b64");
        byte[] nbtBytes = nbt != null ? Base64.getDecoder().decode(nbt) : ((nbt = (String)data.getOrDefault("nbt_hex", null)) == null ? new byte[]{} : Utils.parseHexBinary(nbt));
        return Item.get(Utils.toInt(data.get("id")), Utils.toInt(data.getOrDefault("damage", 0)), Utils.toInt(data.getOrDefault("count", 1)), nbtBytes);
    }

    public static Item[] fromStringMultiple(String str) {
        String[] b = str.split(",");
        Item[] items = new Item[b.length - 1];
        for (int i = 0; i < b.length; ++i) {
            items[i] = Item.fromString(b[i]);
        }
        return items;
    }

    public Item setCompoundTag(CompoundTag tag) {
        this.setNamedTag(tag);
        return this;
    }

    public Item setCompoundTag(byte[] tags) {
        this.tags = tags;
        this.cachedNBT = null;
        return this;
    }

    public byte[] getCompoundTag() {
        return this.tags;
    }

    public boolean hasCompoundTag() {
        return this.tags != null && this.tags.length > 0;
    }

    public boolean hasCustomBlockData() {
        if (!this.hasCompoundTag()) {
            return false;
        }
        CompoundTag tag = this.getNamedTag();
        return tag.contains("BlockEntityTag") && tag.get("BlockEntityTag") instanceof CompoundTag;
    }

    public Item clearCustomBlockData() {
        if (!this.hasCompoundTag()) {
            return this;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("BlockEntityTag") && tag.get("BlockEntityTag") instanceof CompoundTag) {
            tag.remove("BlockEntityTag");
            this.setNamedTag(tag);
        }
        return this;
    }

    public Item setCustomBlockData(CompoundTag compoundTag) {
        CompoundTag tags = compoundTag.copy();
        tags.setName("BlockEntityTag");
        CompoundTag tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag();
        tag.putCompound("BlockEntityTag", tags);
        this.setNamedTag(tag);
        return this;
    }

    public CompoundTag getCustomBlockData() {
        Tag bet;
        if (!this.hasCompoundTag()) {
            return null;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("BlockEntityTag") && (bet = tag.get("BlockEntityTag")) instanceof CompoundTag) {
            return (CompoundTag)bet;
        }
        return null;
    }

    public boolean hasEnchantments() {
        if (!this.hasCompoundTag()) {
            return false;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("ench")) {
            Tag enchTag = tag.get("ench");
            return enchTag instanceof ListTag;
        }
        return false;
    }

    public Enchantment getEnchantment(int id) {
        return this.getEnchantment((short)(id & 0xFFFF));
    }

    public Enchantment getEnchantment(short id) {
        if (!this.hasEnchantments()) {
            return null;
        }
        for (CompoundTag entry : this.getNamedTag().getList("ench", CompoundTag.class).getAll()) {
            Enchantment e;
            if (entry.getShort("id") != id || (e = Enchantment.getEnchantment(entry.getShort("id"))) == null) continue;
            e.setLevel(entry.getShort("lvl"), false);
            return e;
        }
        return null;
    }

    public void addEnchantment(Enchantment ... enchantments) {
        ListTag<Object> ench;
        CompoundTag tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag();
        if (!tag.contains("ench")) {
            ench = new ListTag("ench");
            tag.putList(ench);
        } else {
            ench = tag.getList("ench", CompoundTag.class);
        }
        for (Enchantment enchantment : enchantments) {
            boolean found = false;
            for (int k = 0; k < ench.size(); ++k) {
                CompoundTag entry = (CompoundTag)ench.get(k);
                if (entry.getShort("id") != enchantment.getId()) continue;
                ench.add(k, new CompoundTag().putShort("id", enchantment.getId()).putShort("lvl", enchantment.getLevel()));
                found = true;
                break;
            }
            if (found) continue;
            ench.add(new CompoundTag().putShort("id", enchantment.getId()).putShort("lvl", enchantment.getLevel()));
        }
        this.setNamedTag(tag);
    }

    public Enchantment[] getEnchantments() {
        if (!this.hasEnchantments()) {
            return new Enchantment[0];
        }
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        ListTag<CompoundTag> ench = this.getNamedTag().getList("ench", CompoundTag.class);
        for (CompoundTag entry : ench.getAll()) {
            Enchantment e = Enchantment.getEnchantment(entry.getShort("id"));
            if (e == null) continue;
            e.setLevel(entry.getShort("lvl"), false);
            enchantments.add(e);
        }
        return enchantments.toArray(new Enchantment[0]);
    }

    public boolean hasCustomName() {
        if (!this.hasCompoundTag()) {
            return false;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("display")) {
            Tag tag1 = tag.get("display");
            return tag1 instanceof CompoundTag && ((CompoundTag)tag1).contains("Name") && ((CompoundTag)tag1).get("Name") instanceof StringTag;
        }
        return false;
    }

    public String getCustomName() {
        Tag tag1;
        if (!this.hasCompoundTag()) {
            return "";
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("display") && (tag1 = tag.get("display")) instanceof CompoundTag && ((CompoundTag)tag1).contains("Name") && ((CompoundTag)tag1).get("Name") instanceof StringTag) {
            return ((CompoundTag)tag1).getString("Name");
        }
        return "";
    }

    public Item setCustomName(String name) {
        CompoundTag tag;
        if (name == null || name.equals("")) {
            this.clearCustomName();
        }
        if ((tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag()).contains("display") && tag.get("display") instanceof CompoundTag) {
            tag.getCompound("display").putString("Name", name);
        } else {
            tag.putCompound("display", new CompoundTag("display").putString("Name", name));
        }
        this.setNamedTag(tag);
        return this;
    }

    public Item clearCustomName() {
        if (!this.hasCompoundTag()) {
            return this;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("display") && tag.get("display") instanceof CompoundTag) {
            tag.getCompound("display").remove("Name");
            if (tag.getCompound("display").isEmpty()) {
                tag.remove("display");
            }
            this.setNamedTag(tag);
        }
        return this;
    }

    public String[] getLore() {
        CompoundTag nbt;
        ListTag<StringTag> lore;
        Tag tag = this.getNamedTagEntry("display");
        ArrayList<String> lines = new ArrayList<String>();
        if (tag instanceof CompoundTag && (lore = (nbt = (CompoundTag)tag).getList("Lore", StringTag.class)).size() > 0) {
            for (StringTag stringTag : lore.getAll()) {
                lines.add(stringTag.data);
            }
        }
        return lines.toArray(new String[0]);
    }

    public Item setLore(String ... lines) {
        CompoundTag tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag();
        ListTag<StringTag> lore = new ListTag<StringTag>("Lore");
        for (String line : lines) {
            lore.add(new StringTag("", line));
        }
        if (!tag.contains("display")) {
            tag.putCompound("display", new CompoundTag("display").putList(lore));
        } else {
            tag.getCompound("display").putList(lore);
        }
        this.setNamedTag(tag);
        return this;
    }

    public Tag getNamedTagEntry(String name) {
        CompoundTag tag = this.getNamedTag();
        if (tag != null) {
            return tag.contains(name) ? tag.get(name) : null;
        }
        return null;
    }

    public CompoundTag getNamedTag() {
        if (!this.hasCompoundTag()) {
            return null;
        }
        if (this.cachedNBT == null) {
            this.cachedNBT = Item.parseCompoundTag(this.tags);
        }
        if (this.cachedNBT != null) {
            this.cachedNBT.setName("");
        }
        return this.cachedNBT;
    }

    public Item setNamedTag(CompoundTag tag) {
        if (tag.isEmpty()) {
            return this.clearNamedTag();
        }
        tag.setName(null);
        this.cachedNBT = tag;
        this.tags = this.writeCompoundTag(tag);
        return this;
    }

    public Item clearNamedTag() {
        return this.setCompoundTag(new byte[0]);
    }

    public static CompoundTag parseCompoundTag(byte[] tag) {
        try {
            return NBTIO.read(tag, ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] writeCompoundTag(CompoundTag tag) {
        try {
            tag.setName("");
            return NBTIO.write(tag, ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isNull() {
        return this.count <= 0 || this.id == 0;
    }

    public final String getName() {
        return this.hasCustomName() ? this.getCustomName() : this.name;
    }

    public final boolean canBePlaced() {
        return this.block != null && this.block.canBePlaced();
    }

    public Block getBlock() {
        if (this.block != null) {
            return this.block.clone();
        }
        return Block.get(0);
    }

    public int getId() {
        return this.id;
    }

    public int getDamage() {
        return this.meta;
    }

    public void setDamage(Integer meta) {
        if (meta != null) {
            this.meta = meta & 0xFFFF;
        } else {
            this.hasMeta = false;
        }
    }

    public int getMaxStackSize() {
        return 64;
    }

    public final Short getFuelTime() {
        if (!Fuel.duration.containsKey(this.id)) {
            return null;
        }
        if (this.id != 325 || this.meta == 10) {
            return Fuel.duration.get(this.id);
        }
        return null;
    }

    public boolean useOn(Entity entity) {
        return false;
    }

    public boolean useOn(Block block) {
        return false;
    }

    public boolean isTool() {
        return false;
    }

    public int getMaxDurability() {
        return -1;
    }

    public int getTier() {
        return 0;
    }

    public boolean isPickaxe() {
        return false;
    }

    public boolean isAxe() {
        return false;
    }

    public boolean isSword() {
        return false;
    }

    public boolean isShovel() {
        return false;
    }

    public boolean isHoe() {
        return false;
    }

    public boolean isShears() {
        return false;
    }

    public boolean isArmor() {
        return false;
    }

    public boolean isHelmet() {
        return false;
    }

    public boolean isChestplate() {
        return false;
    }

    public boolean isLeggings() {
        return false;
    }

    public boolean isBoots() {
        return false;
    }

    public int getEnchantAbility() {
        return 0;
    }

    public int getAttackDamage() {
        return 1;
    }

    public int getArmorPoints() {
        return 0;
    }

    public int getToughness() {
        return 0;
    }

    public boolean isUnbreakable() {
        return false;
    }

    public boolean onUse(Player player, int ticksUsed) {
        return false;
    }

    public boolean onRelease(Player player, int ticksUsed) {
        return false;
    }

    public final String toString() {
        return "Item " + this.name + " (" + this.id + ":" + (!this.hasMeta ? "?" : Integer.valueOf(this.meta)) + ")x" + this.count + (this.hasCompoundTag() ? " tags:0x" + Binary.bytesToHexString(this.getCompoundTag()) : "");
    }

    public int getDestroySpeed(Block block, Player player) {
        return 1;
    }

    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        return false;
    }

    public boolean onClickAir(Player player, Vector3 directionVector) {
        return false;
    }

    public final boolean equals(Object item) {
        return item instanceof Item && this.equals((Item)item, true);
    }

    public final boolean equals(Item item, boolean checkDamage) {
        return this.equals(item, checkDamage, true);
    }

    public final boolean equals(Item item, boolean checkDamage, boolean checkCompound) {
        if (!(this.getId() != item.getId() || checkDamage && this.getDamage() != item.getDamage())) {
            if (checkCompound) {
                if (Arrays.equals(this.getCompoundTag(), item.getCompoundTag())) {
                    return true;
                }
                if (this.hasCompoundTag() && item.hasCompoundTag()) {
                    return this.getNamedTag().equals(item.getNamedTag());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public final boolean equalsExact(Item other) {
        return this.equals(other, true, true) && this.count == other.count;
    }

    public final boolean equalsIgnoringEnchantmentOrder(Item item, boolean checkDamage) {
        CompoundTag tag;
        int i;
        CompoundTag otherTags;
        if (!this.equals(item, checkDamage, false)) {
            return false;
        }
        if (Arrays.equals(this.getCompoundTag(), item.getCompoundTag())) {
            return true;
        }
        if (!this.hasCompoundTag() || !item.hasCompoundTag()) {
            return false;
        }
        CompoundTag thisTags = this.getNamedTag();
        if (thisTags.equals(otherTags = item.getNamedTag())) {
            return true;
        }
        if (!(thisTags.contains("ench") && otherTags.contains("ench") && thisTags.get("ench") instanceof ListTag && otherTags.get("ench") instanceof ListTag && thisTags.getList("ench").size() == otherTags.getList("ench").size())) {
            return false;
        }
        ListTag<CompoundTag> thisEnchantmentTags = thisTags.getList("ench", CompoundTag.class);
        ListTag<CompoundTag> otherEnchantmentTags = otherTags.getList("ench", CompoundTag.class);
        int size = thisEnchantmentTags.size();
        Int2IntArrayMap enchantments = new Int2IntArrayMap(size);
        enchantments.defaultReturnValue(Integer.MIN_VALUE);
        for (i = 0; i < size; ++i) {
            tag = thisEnchantmentTags.get(i);
            enchantments.put(tag.getShort("id"), tag.getShort("lvl"));
        }
        for (i = 0; i < size; ++i) {
            tag = otherEnchantmentTags.get(i);
            if (enchantments.get(tag.getShort("id")) == tag.getShort("lvl")) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public final boolean deepEquals(Item item) {
        return this.equals(item, true);
    }

    @Deprecated
    public final boolean deepEquals(Item item, boolean checkDamage) {
        return this.equals(item, checkDamage, true);
    }

    @Deprecated
    public final boolean deepEquals(Item item, boolean checkDamage, boolean checkCompound) {
        return this.equals(item, checkDamage, checkCompound);
    }

    public Item clone() {
        try {
            Item item = (Item)super.clone();
            item.tags = (byte[])this.tags.clone();
            return item;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

