/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.item.Item;

@Since(value="1.2.1.0-PN")
@PowerNukkitOnly
public class ItemBannerPattern
extends Item {
    public static final int PATTERN_CREEPER_CHARGE = 0;
    public static final int PATTERN_SKULL_CHARGE = 1;
    public static final int PATTERN_FLOWER_CHARGE = 2;
    public static final int PATTERN_THING = 3;
    public static final int PATTERN_FIELD_MASONED = 4;
    public static final int PATTERN_BORDURE_INDENTED = 5;

    public ItemBannerPattern() {
        this((Integer)0, 1);
    }

    public ItemBannerPattern(Integer meta) {
        this(meta, 1);
    }

    public ItemBannerPattern(Integer meta, int count) {
        super(434, meta, count, "Bone");
        this.updateName();
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public void setDamage(Integer meta) {
        super.setDamage(meta);
        this.updateName();
    }

    protected void updateName() {
        switch (this.meta % 6) {
            case 0: {
                this.name = "Creeper Charge Banner Pattern";
                return;
            }
            case 1: {
                this.name = "Skull Charge Banner Pattern";
                return;
            }
            case 2: {
                this.name = "Flower Charge Banner Pattern";
                return;
            }
            case 3: {
                this.name = "Thing Banner Pattern";
                return;
            }
            case 4: {
                this.name = "Field Banner Pattern";
                return;
            }
            case 5: {
                this.name = "Bordure Idented Banner Pattern";
                return;
            }
        }
        this.name = "Banner Pattern";
    }
}

