/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.nbt.tag.CompoundTag;

public interface ChunkSection {
    public int getY();

    public int getBlockId(int var1, int var2, int var3);

    public int getBlockId(int var1, int var2, int var3, int var4);

    public void setBlockId(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN", replaceWith="setBlockAtLayer(int x, int y, int z, int layer, int blockId, int meta)")
    public boolean setFullBlockId(int var1, int var2, int var3, int var4, int var5);

    public int getBlockData(int var1, int var2, int var3);

    public int getBlockData(int var1, int var2, int var3, int var4);

    public void setBlockData(int var1, int var2, int var3, int var4);

    public void setBlockData(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    public int getFullBlock(int var1, int var2, int var3);

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public int[] getBlockState(int x, int y, int z) {
        return this.getBlockState(x, y, z, 0);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public int[] getBlockState(int x, int y, int z, int layer) {
        return new int[]{this.getBlockId(x, y, z, layer), this.getBlockData(x, y, z, layer)};
    }

    public Block getAndSetBlock(int var1, int var2, int var3, int var4, Block var5);

    public Block getAndSetBlock(int var1, int var2, int var3, Block var4);

    public void setBlockId(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN", replaceWith="setBlock(int x, int y, int z, int blockId, int meta)")
    public boolean setFullBlockId(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    public int getFullBlock(int var1, int var2, int var3, int var4);

    public boolean setBlockAtLayer(int var1, int var2, int var3, int var4, int var5);

    public boolean setBlock(int var1, int var2, int var3, int var4);

    public boolean setBlock(int var1, int var2, int var3, int var4, int var5);

    public boolean setBlockAtLayer(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getBlockSkyLight(int var1, int var2, int var3);

    public void setBlockSkyLight(int var1, int var2, int var3, int var4);

    public int getBlockLight(int var1, int var2, int var3);

    public void setBlockLight(int var1, int var2, int var3, int var4);

    public byte[] getIdExtraArray(int var1);

    public byte[] getIdArray(int var1);

    public byte[] getIdArray();

    public byte[] getDataArray();

    public byte[] getDataArray(int var1);

    default public byte[] getDataExtraArray() {
        return this.getDataExtraArray(0);
    }

    public byte[] getDataExtraArray(int var1);

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public byte[][] getHyperDataArray() {
        return this.getHyperDataArray(0);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public byte[][] getHyperDataArray(int layer) {
        return new byte[0][];
    }

    public byte[] getSkyLightArray();

    public byte[] getLightArray();

    public boolean isEmpty();

    public byte[] getBytes();

    public int getMaximumLayer();

    public CompoundTag toNBT();

    public ChunkSection copy();

    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.0.0-PN")
    default public int getContentVersion() {
        return 0;
    }

    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.1.0-PN")
    default public void setContentVersion(int contentVersion) {
    }
}

