/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.Server;
import cn.nukkit.utils.Logger;
import cn.nukkit.utils.MainLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;

public class Watchdog
extends Thread {
    private final Server server;
    private final long time;
    public boolean running;
    private boolean responding = true;

    public Watchdog(Server server, long time) {
        this.server = server;
        this.time = time;
        this.running = true;
        this.setName("Watchdog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        this.running = false;
        Watchdog watchdog = this;
        synchronized (watchdog) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            long current = this.server.getNextTick();
            if (current != 0L) {
                long diff = System.currentTimeMillis() - current;
                if (!this.responding && diff > this.time * 2L) {
                    System.exit(1);
                }
                if (this.server.isRunning() && diff > this.time) {
                    if (this.responding) {
                        MainLogger logger = this.server.getLogger();
                        logger.emergency("--------- Server stopped responding --------- (" + Math.round((double)diff / 1000.0) + "s)");
                        logger.emergency("Please report this to PowerNukkit:");
                        logger.emergency(" - https://github.com/PowerNukkit/PowerNukkit/issues/new");
                        logger.emergency("---------------- Main thread ----------------");
                        Watchdog.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(this.server.getPrimaryThread().getId(), Integer.MAX_VALUE), logger);
                        logger.emergency("---------------- All threads ----------------");
                        ThreadInfo[] threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
                        for (int i = 0; i < threads.length; ++i) {
                            if (i != 0) {
                                logger.emergency("------------------------------");
                            }
                            Watchdog.dumpThread(threads[i], logger);
                        }
                        logger.emergency("---------------------------------------------");
                        this.responding = false;
                        this.server.forceShutdown();
                    }
                } else {
                    this.responding = true;
                }
            }
            try {
                Watchdog watchdog = this;
                synchronized (watchdog) {
                    this.wait(Math.max(this.time / 4L, 1000L));
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private static void dumpThread(ThreadInfo thread, Logger logger) {
        logger.emergency("Current Thread: " + thread.getThreadName());
        logger.emergency("\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + (Object)((Object)thread.getThreadState()));
        if (thread.getLockedMonitors().length != 0) {
            logger.emergency("\tThread is waiting on monitor(s):");
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                logger.emergency("\t\tLocked on:" + monitor.getLockedStackFrame());
            }
        }
        logger.emergency("\tStack:");
        for (StackTraceElement stack : thread.getStackTrace()) {
            logger.emergency("\t\t" + stack);
        }
    }
}

