/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingData;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsHistory;
import co.aikar.timings.TimingsManager;

public class FullServerTickTiming
extends Timing {
    private static final TimingIdentifier IDENTIFIER = new TimingIdentifier(TimingIdentifier.DEFAULT_GROUP.name, "Full Server Tick", null);
    final TimingData minuteData = new TimingData(this.id);
    double avgFreeMemory = -1.0;
    double avgUsedMemory = -1.0;

    FullServerTickTiming() {
        super(IDENTIFIER);
        TimingsManager.TIMING_MAP.put(IDENTIFIER, this);
    }

    @Override
    public Timing startTiming() {
        if (TimingsManager.needsFullReset) {
            TimingsManager.resetTimings();
        } else if (TimingsManager.needsRecheckEnabled) {
            TimingsManager.recheckEnabled();
        }
        super.startTiming();
        return this;
    }

    @Override
    public void stopTiming() {
        super.stopTiming();
        if (!this.enabled) {
            return;
        }
        if (TimingsHistory.timedTicks % 20L == 0L) {
            Runtime runtime = Runtime.getRuntime();
            double usedMemory = runtime.totalMemory() - runtime.freeMemory();
            double freeMemory = (double)runtime.maxMemory() - usedMemory;
            this.avgFreeMemory = this.avgFreeMemory == -1.0 ? freeMemory : this.avgFreeMemory * 0.9833333333333333 + freeMemory * 0.016666666666666666;
            this.avgUsedMemory = this.avgUsedMemory == -1.0 ? usedMemory : this.avgUsedMemory * 0.9833333333333333 + usedMemory * 0.016666666666666666;
        }
        long start = System.nanoTime();
        TimingsManager.tick();
        long diff = System.nanoTime() - start;
        TimingsManager.CURRENT = Timings.timingsTickTimer;
        Timings.timingsTickTimer.addDiff(diff);
        --this.record.curTickCount;
        this.minuteData.curTickTotal = this.record.curTickTotal;
        this.minuteData.curTickCount = 1;
        boolean violated = this.isViolated();
        this.minuteData.tick(violated);
        Timings.timingsTickTimer.tick(violated);
        this.tick(violated);
        if (TimingsHistory.timedTicks % 1200L == 0L) {
            TimingsManager.MINUTE_REPORTS.add(new TimingsHistory.MinuteReport());
            TimingsHistory.resetTicks(false);
            this.minuteData.reset();
        }
        if (TimingsHistory.timedTicks % (long)Timings.getHistoryInterval() == 0L) {
            TimingsManager.HISTORY.add(new TimingsHistory());
            TimingsManager.resetTimings();
        }
    }

    boolean isViolated() {
        return this.record.curTickTotal > 50000000;
    }
}

