/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDoubleSlabStone;
import cn.nukkit.block.BlockSlabStone3;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.utils.BlockColor;

public class BlockDoubleSlabStone3
extends BlockDoubleSlabStone {
    public static final int END_STONE_BRICKS = 0;
    public static final int SMOOTH_RED_SANDSTONE = 1;
    public static final int POLISHED_ANDESITE = 2;
    public static final int ANDESITE = 3;
    public static final int DIORITE = 4;
    public static final int POLISHED_DIORITE = 5;
    public static final int GRANITE = 6;
    public static final int POLISHED_GRANITE = 7;

    public BlockDoubleSlabStone3() {
        this(0);
    }

    public BlockDoubleSlabStone3(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 422;
    }

    @Override
    public double getResistance() {
        return this.getToolType() > 1 ? 30.0 : 15.0;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"End Stone Brick", "Smooth Red Sandstone", "Polished Andesite", "Andesite", "Diorite", "Polished Diorite", "Granite", "Polisehd Granite"};
        return "Double " + names[this.getDamage() & 7] + " Slab";
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockSlabStone3(), (Integer)(this.getDamage() & 7));
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            Item drop = Block.get(417, this.getDamage() & 7).toItem();
            drop.setCount(2);
            return new Item[]{drop};
        }
        return new Item[0];
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            case 0: {
                return BlockColor.SAND_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.ORANGE_BLOCK_COLOR;
            }
            default: {
                return BlockColor.STONE_BLOCK_COLOR;
            }
            case 4: 
            case 5: {
                return BlockColor.QUARTZ_BLOCK_COLOR;
            }
            case 6: 
            case 7: 
        }
        return BlockColor.DIRT_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

