/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import cn.nukkit.utils.BlockColor;

public class BlockEntityCauldron
extends BlockEntitySpawnable {
    public static final int POTION_TYPE_EMPTY = 65535;
    public static final int POTION_TYPE_NORMAL = 0;
    public static final int POTION_TYPE_SPLASH = 1;
    public static final int POTION_TYPE_LINGERING = 2;
    public static final int POTION_TYPE_LAVA = 61851;

    public BlockEntityCauldron(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        int potionId;
        int potionType;
        if (!this.namedTag.contains("PotionId")) {
            this.namedTag.putShort("PotionId", 65535);
        }
        int n = potionType = ((potionId = this.namedTag.getShort("PotionId")) & 0xFFFF) == 65535 ? 65535 : 0;
        if (this.namedTag.getBoolean("SplashPotion")) {
            potionType = 1;
            this.namedTag.remove("SplashPotion");
        }
        if (!this.namedTag.contains("PotionType")) {
            this.namedTag.putShort("PotionType", potionType);
        }
        super.initBlockEntity();
    }

    public int getPotionId() {
        return this.namedTag.getShort("PotionId");
    }

    public void setPotionId(int potionId) {
        this.namedTag.putShort("PotionId", potionId);
        this.spawnToAll();
    }

    public boolean hasPotion() {
        return this.getPotionId() != 65535;
    }

    public void setPotionType(int potionType) {
        this.namedTag.putShort("PotionType", potionType & 0xFFFF);
    }

    public int getPotionType() {
        return this.namedTag.getShort("PotionType") & 0xFFFF;
    }

    public boolean isSplashPotion() {
        return this.namedTag.getShort("PotionType") == 1;
    }

    @Deprecated
    public void setSplashPotion(boolean value) {
        this.namedTag.putShort("PotionType", value ? 1 : 0);
    }

    public BlockColor getCustomColor() {
        if (this.isCustomColor()) {
            int color = this.namedTag.getInt("CustomColor");
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            return new BlockColor(red, green, blue);
        }
        return null;
    }

    public boolean isCustomColor() {
        return this.namedTag.contains("CustomColor");
    }

    public void setCustomColor(BlockColor color) {
        this.setCustomColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setCustomColor(int r, int g, int b) {
        int color = (r << 16 | g << 8 | b) & 0xFFFFFF;
        this.namedTag.putInt("CustomColor", color);
        Block block = this.getBlock();
        Player[] viewers = this.level.getChunkPlayers(this.getChunkX(), this.getChunkZ()).values().toArray(new Player[0]);
        UpdateBlockPacket air = new UpdateBlockPacket();
        air.blockRuntimeId = GlobalBlockPalette.getOrCreateRuntimeId(0, 0);
        air.flags = 11;
        air.x = (int)this.x;
        air.y = (int)this.y;
        air.z = (int)this.z;
        UpdateBlockPacket self = (UpdateBlockPacket)air.clone();
        self.blockRuntimeId = GlobalBlockPalette.getOrCreateRuntimeId(block.getId(), block.getDamage());
        for (Player viewer : viewers) {
            viewer.dataPacket(air);
            viewer.dataPacket(self);
        }
        this.spawnToAll();
    }

    public void clearCustomColor() {
        this.namedTag.remove("CustomColor");
        this.spawnToAll();
    }

    @Override
    public boolean isBlockEntityValid() {
        int id = this.getBlock().getId();
        return id == 118 || id == 465;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag compoundTag = new CompoundTag().putString("id", "Cauldron").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("PotionId", this.namedTag.getShort("PotionId")).putByte("PotionType", this.namedTag.getShort("PotionType"));
        if (this.namedTag.contains("CustomColor")) {
            compoundTag.putInt("CustomColor", this.namedTag.getInt("CustomColor"));
        }
        return compoundTag;
    }
}

