/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.api.Since;
import cn.nukkit.event.inventory.InventoryClickEvent;
import cn.nukkit.event.inventory.InventoryTransactionEvent;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.item.Item;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class InventoryTransaction {
    private long creationTime;
    protected boolean hasExecuted;
    protected Player source;
    protected Set<Inventory> inventories = new HashSet<Inventory>();
    protected List<InventoryAction> actions = new ArrayList<InventoryAction>();

    public InventoryTransaction(Player source, List<InventoryAction> actions) {
        this(source, actions, true);
    }

    public InventoryTransaction(Player source, List<InventoryAction> actions, boolean init) {
        if (init) {
            this.init(source, actions);
        }
    }

    protected void init(Player source, List<InventoryAction> actions) {
        this.creationTime = System.currentTimeMillis();
        this.source = source;
        for (InventoryAction action : actions) {
            this.addAction(action);
        }
    }

    public Player getSource() {
        return this.source;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Set<Inventory> getInventories() {
        return this.inventories;
    }

    @Since(value="1.3.0.0-PN")
    public List<InventoryAction> getActionList() {
        return this.actions;
    }

    public Set<InventoryAction> getActions() {
        return new HashSet<InventoryAction>(this.actions);
    }

    public void addAction(InventoryAction action) {
        if (action instanceof SlotChangeAction) {
            SlotChangeAction slotChangeAction = (SlotChangeAction)action;
            ListIterator<InventoryAction> iterator = this.actions.listIterator();
            while (iterator.hasNext()) {
                SlotChangeAction existingSlotChangeAction;
                InventoryAction existingAction = iterator.next();
                if (!(existingAction instanceof SlotChangeAction) || !(existingSlotChangeAction = (SlotChangeAction)existingAction).getInventory().equals(slotChangeAction.getInventory())) continue;
                Item existingTarget = existingSlotChangeAction.getTargetItem();
                if (existingSlotChangeAction.getSlot() != slotChangeAction.getSlot() || !slotChangeAction.getSourceItem().equals(existingTarget, existingTarget.hasMeta(), existingTarget.hasCompoundTag())) continue;
                iterator.set(new SlotChangeAction(existingSlotChangeAction.getInventory(), existingSlotChangeAction.getSlot(), existingSlotChangeAction.getSourceItem(), slotChangeAction.getTargetItem()));
                action.onAddToTransaction(this);
                return;
            }
        }
        this.actions.add(action);
        action.onAddToTransaction(this);
    }

    public void addInventory(Inventory inventory) {
        this.inventories.add(inventory);
    }

    protected boolean matchItems(List<Item> needItems, List<Item> haveItems) {
        for (InventoryAction action : this.actions) {
            if (action.getTargetItem().getId() != 0) {
                needItems.add(action.getTargetItem());
            }
            if (!action.isValid(this.source)) {
                return false;
            }
            if (action.getSourceItem().getId() == 0) continue;
            haveItems.add(action.getSourceItem());
        }
        block1: for (Item needItem : new ArrayList<Item>(needItems)) {
            for (Item haveItem : new ArrayList<Item>(haveItems)) {
                if (!needItem.equals(haveItem)) continue;
                int amount = Math.min(haveItem.getCount(), needItem.getCount());
                needItem.setCount(needItem.getCount() - amount);
                haveItem.setCount(haveItem.getCount() - amount);
                if (haveItem.getCount() == 0) {
                    haveItems.remove(haveItem);
                }
                if (needItem.getCount() != 0) continue;
                needItems.remove(needItem);
                continue block1;
            }
        }
        return haveItems.isEmpty() && needItems.isEmpty();
    }

    protected void sendInventories() {
        for (InventoryAction action : this.actions) {
            if (!(action instanceof SlotChangeAction)) continue;
            SlotChangeAction sca = (SlotChangeAction)action;
            sca.getInventory().sendSlot(sca.getSlot(), this.source);
        }
    }

    public boolean canExecute() {
        ArrayList<Item> needItems = new ArrayList<Item>();
        ArrayList<Item> haveItems = new ArrayList<Item>();
        return this.matchItems(needItems, haveItems) && this.actions.size() > 0 && haveItems.size() == 0 && needItems.size() == 0;
    }

    protected boolean callExecuteEvent() {
        InventoryTransactionEvent ev = new InventoryTransactionEvent(this);
        this.source.getServer().getPluginManager().callEvent(ev);
        InventoryAction from = null;
        SlotChangeAction to = null;
        Player who = null;
        for (InventoryAction action : this.actions) {
            if (!(action instanceof SlotChangeAction)) continue;
            SlotChangeAction slotChange = (SlotChangeAction)action;
            if (slotChange.getInventory().getHolder() instanceof Player) {
                who = (Player)slotChange.getInventory().getHolder();
            }
            if (from == null) {
                from = slotChange;
                continue;
            }
            to = slotChange;
        }
        if (who != null && to != null) {
            if (from.getTargetItem().getCount() > from.getSourceItem().getCount()) {
                from = to;
            }
            InventoryClickEvent ev2 = new InventoryClickEvent(who, ((SlotChangeAction)from).getInventory(), ((SlotChangeAction)from).getSlot(), from.getSourceItem(), from.getTargetItem());
            this.source.getServer().getPluginManager().callEvent(ev2);
            if (ev2.isCancelled()) {
                return false;
            }
        }
        return !ev.isCancelled();
    }

    public boolean execute() {
        if (this.hasExecuted() || !this.canExecute()) {
            this.sendInventories();
            return false;
        }
        if (!this.callExecuteEvent()) {
            this.sendInventories();
            return true;
        }
        for (InventoryAction action : this.actions) {
            if (action.onPreExecute(this.source)) continue;
            this.sendInventories();
            return true;
        }
        for (InventoryAction action : this.actions) {
            if (action.execute(this.source)) {
                action.onExecuteSuccess(this.source);
                continue;
            }
            action.onExecuteFail(this.source);
        }
        this.hasExecuted = true;
        return true;
    }

    public boolean hasExecuted() {
        return this.hasExecuted;
    }
}

