/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.enchantment.protection;

import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.enchantment.protection.EnchantmentProtection;

public class EnchantmentProtectionProjectile
extends EnchantmentProtection {
    public EnchantmentProtectionProjectile() {
        super(4, "projectile", 5, EnchantmentProtection.TYPE.PROJECTILE);
    }

    @Override
    public int getMinEnchantAbility(int level) {
        return 3 + (level - 1) * 6;
    }

    @Override
    public int getMaxEnchantAbility(int level) {
        return this.getMinEnchantAbility(level) + 15;
    }

    @Override
    public double getTypeModifier() {
        return 3.0;
    }

    @Override
    public float getProtectionFactor(EntityDamageEvent e) {
        EntityDamageEvent.DamageCause cause = e.getCause();
        if (this.level <= 0 || cause != EntityDamageEvent.DamageCause.PROJECTILE) {
            return 0.0f;
        }
        return (float)((double)this.getLevel() * this.getTypeModifier());
    }
}

