/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.palette;

import cn.nukkit.Server;
import cn.nukkit.level.format.anvil.palette.BitArray4096;
import cn.nukkit.level.format.anvil.palette.CharPalette;
import cn.nukkit.math.MathHelper;
import cn.nukkit.utils.ThreadCache;
import com.google.common.base.Preconditions;
import java.util.Arrays;

public final class BlockDataPalette
implements Cloneable {
    private static final int BLOCK_SIZE = 4096;
    private volatile char[] rawData;
    private volatile BitArray4096 encodedData;
    private volatile CharPalette palette;

    public BlockDataPalette() {
        this(new char[4096]);
    }

    public BlockDataPalette(char[] rawData) {
        Preconditions.checkArgument((rawData.length == 4096 ? 1 : 0) != 0, (Object)"Data is not 4096");
        this.rawData = rawData;
    }

    private char[] getCachedRaw() {
        char[] raw = this.rawData;
        if (raw != null) {
            return raw;
        }
        if (!Server.getInstance().isPrimaryThread()) {
            return this.getRaw();
        }
        return this.rawData;
    }

    public synchronized char[] getRaw() {
        CharPalette palette = this.palette;
        BitArray4096 encodedData = this.encodedData;
        this.encodedData = null;
        this.palette = null;
        char[] raw = this.rawData;
        if (raw == null && palette != null) {
            raw = encodedData != null ? encodedData.toRaw() : new char[4096];
            for (int i = 0; i < 4096; ++i) {
                raw[i] = palette.getKey(raw[i]);
            }
        } else {
            raw = new char[4096];
        }
        this.rawData = raw;
        return this.rawData;
    }

    private int getIndex(int x, int y, int z) {
        return (x << 8) + (z << 4) + y;
    }

    public int getBlockData(int x, int y, int z) {
        return this.getFullBlock(x, y, z) & 0xF;
    }

    public int getBlockId(int x, int y, int z) {
        return this.getFullBlock(x, y, z) >> 6;
    }

    public void setBlockId(int x, int y, int z, int id) {
        this.setFullBlock(x, y, z, (char)(id << 6));
    }

    public synchronized void setBlockData(int x, int y, int z, int data) {
        char fullId;
        int index = this.getIndex(x, y, z);
        char[] raw = this.getCachedRaw();
        if (raw != null) {
            fullId = raw[index];
            raw[index] = (char)(fullId & 0x3FFC0 | data);
        }
        if (this.palette != null && this.encodedData != null) {
            fullId = this.palette.getKey(this.encodedData.getAt(index));
            if ((fullId & 0x3F) != data) {
                this.setPaletteFullBlock(index, (char)(fullId & 0x3FFC0 | data));
            }
        } else {
            throw new IllegalStateException("Raw data and pallete was null");
        }
    }

    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(this.getIndex(x, y, z));
    }

    public void setFullBlock(int x, int y, int z, int value) {
        this.setFullBlock(this.getIndex(x, y, z), (char)value);
    }

    public int getAndSetFullBlock(int x, int y, int z, int value) {
        return this.getAndSetFullBlock(this.getIndex(x, y, z), (char)value);
    }

    private int getAndSetFullBlock(int index, char value) {
        char[] raw = this.getCachedRaw();
        if (raw != null) {
            char result = raw[index];
            raw[index] = value;
            return result;
        }
        if (this.palette != null && this.encodedData != null) {
            char result = this.palette.getKey(this.encodedData.getAt(index));
            if (result != value) {
                this.setPaletteFullBlock(index, value);
            }
            return result;
        }
        throw new IllegalStateException("Raw data and pallete was null");
    }

    private int getFullBlock(int index) {
        char[] raw = this.getCachedRaw();
        if (raw != null) {
            return raw[index];
        }
        if (this.palette != null && this.encodedData != null) {
            return this.palette.getKey(this.encodedData.getAt(index));
        }
        throw new IllegalStateException("Raw data and pallete was null");
    }

    private void setFullBlock(int index, char value) {
        char[] raw = this.getCachedRaw();
        if (raw != null) {
            raw[index] = value;
        } else if (!this.setPaletteFullBlock(index, value)) {
            throw new IllegalStateException("Raw data and pallete was null");
        }
    }

    private synchronized boolean setPaletteFullBlock(int index, char value) {
        CharPalette palette = this.palette;
        BitArray4096 encodedData = this.encodedData;
        if (palette != null && encodedData != null) {
            char encodedValue = palette.getValue(value);
            if (encodedValue != '\uffff') {
                encodedData.setAt(index, encodedValue);
            } else {
                char[] raw = encodedData.toRaw();
                for (int i = 0; i < 4096; ++i) {
                    raw[i] = palette.getKey(raw[i]);
                }
                raw[index] = value;
                this.rawData = raw;
                this.encodedData = null;
                this.palette = null;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean compress() {
        char[] raw = this.rawData;
        if (raw != null) {
            int unique = 0;
            boolean[] countTable = (boolean[])ThreadCache.boolCache4096.get();
            char[] mapFullTable = (char[])ThreadCache.charCache4096.get();
            char[] mapBitTable = (char[])ThreadCache.charCache4096v2.get();
            Arrays.fill(countTable, false);
            for (char c : raw) {
                if (countTable[c]) continue;
                mapBitTable[unique] = c;
                countTable[c] = true;
                unique = (char)(unique + 1);
            }
            char[] keys = Arrays.copyOfRange(mapBitTable, 0, unique);
            if (keys.length > 1) {
                Arrays.sort(keys);
                for (int c = 0; c < keys.length; c = (int)((char)(c + 1))) {
                    mapFullTable[keys[c]] = c;
                }
            } else {
                mapFullTable[keys[0]] = '\u0000';
            }
            CharPalette palette = new CharPalette();
            palette.set(keys);
            int bits = MathHelper.log2(unique - 1);
            BitArray4096 encodedData = new BitArray4096(bits);
            for (int i = 0; i < raw.length; ++i) {
                mapBitTable[i] = mapFullTable[raw[i]];
            }
            encodedData.fromRaw(mapBitTable);
            this.palette = palette;
            this.encodedData = encodedData;
            this.rawData = null;
            return true;
        }
        return false;
    }

    public synchronized BlockDataPalette clone() {
        char[] raw = this.getRaw();
        return new BlockDataPalette((char[])raw.clone());
    }
}

