/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.util;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.format.anvil.util.NibbleArray;
import com.google.common.base.Preconditions;
import java.util.Arrays;

public class BlockStorage {
    public static final int SECTION_SIZE = 4096;
    private final byte[] blockIds;
    private final byte[] blockIdsExtra;
    private final NibbleArray blockData;
    private final NibbleArray blockDataExtra;
    private final byte[] blockDataHyperA;
    private final short[] blockDataHyperB;
    private boolean hasBlockIds;
    private boolean hasBlockIdExtras;
    private boolean hasBlockDataExtras;
    private boolean hasBlockDataHyperA;
    private boolean hasBlockDataHyperB;

    public BlockStorage() {
        this.blockIds = new byte[4096];
        this.blockIdsExtra = new byte[4096];
        this.blockData = new NibbleArray(4096);
        this.blockDataExtra = new NibbleArray(4096);
        this.blockDataHyperA = new byte[4096];
        this.blockDataHyperB = new short[4096];
    }

    private BlockStorage(byte[] blockIds, byte[] blockIdsExtra, NibbleArray blockData, NibbleArray blockDataExtra, byte[] blockDataHyperA, short[] blockDataHyperB) {
        this.blockIds = blockIds;
        this.blockIdsExtra = blockIdsExtra;
        this.blockData = blockData;
        this.blockDataExtra = blockDataExtra;
        this.blockDataHyperA = blockDataHyperA;
        this.blockDataHyperB = blockDataHyperB;
        this.recheckBlocks();
    }

    private static int getIndex(int x, int y, int z) {
        int index = (x << 8) + (z << 4) + y;
        Preconditions.checkArgument((index >= 0 && index < 4096 ? 1 : 0) != 0, (Object)"Invalid index");
        return index;
    }

    public int getBlockData(int x, int y, int z) {
        if (!this.hasBlockIds) {
            return 0;
        }
        return this.getBlockData(BlockStorage.getIndex(x, y, z));
    }

    private int getBlockData(int index) {
        int base = this.blockData.get(index) & 0xF;
        int extra = this.hasBlockDataExtras ? (this.blockDataExtra.get(index) & 0xF) << 4 : 0;
        int hyperA = this.hasBlockDataHyperA ? (this.blockDataHyperA[index] & 0xFF) << 8 : 0;
        int hyperB = this.hasBlockDataHyperB ? (this.blockDataHyperB[index] & 0xFFFF) << 16 : 0;
        return base | extra | hyperA | hyperB;
    }

    public int getBlockDataExtra(int x, int y, int z) {
        if (!this.hasBlockDataExtras) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockDataExtra.get(index) & 0xF;
    }

    public int getBlockDataBase(int x, int y, int z) {
        if (!this.hasBlockIds) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockData.get(index) & 0xF;
    }

    public int getBlockId(int x, int y, int z) {
        if (!this.hasBlockIds) {
            return 0;
        }
        return this.getBlockId(BlockStorage.getIndex(x, y, z));
    }

    private int getBlockId(int index) {
        return this.blockIds[index] & 0xFF | (this.hasBlockIdExtras ? (this.blockIdsExtra[index] & 0xFF) << 8 : 0);
    }

    public int getBlockIdBase(int x, int y, int z) {
        if (!this.hasBlockIds) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockIds[index] & 0xFF;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public short getHyperDataB(int x, int y, int z) {
        if (!this.hasBlockDataHyperB) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockDataHyperB[index];
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public byte getHyperDataA(int x, int y, int z) {
        if (!this.hasBlockDataHyperA) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockDataHyperA[index];
    }

    public int getBlockIdExtra(int x, int y, int z) {
        if (!this.hasBlockIdExtras) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockIdsExtra[index] & 0xFF;
    }

    public void setBlockId(int x, int y, int z, int id) {
        this.setBlockId(BlockStorage.getIndex(x, y, z), id);
    }

    private void setBlockId(int index, int id) {
        byte extraBase;
        byte blockBase;
        this.blockIds[index] = blockBase = (byte)(id & 0xFF);
        this.blockIdsExtra[index] = extraBase = (byte)(id >> 8 & 0xFF);
        this.hasBlockIdExtras |= extraBase != 0;
        this.hasBlockIds |= blockBase != 0 || this.hasBlockIdExtras;
    }

    public void setBlockData(int x, int y, int z, int data) {
        this.setBlockData(BlockStorage.getIndex(x, y, z), data);
    }

    private void setBlockData(int index, int data) {
        byte data1 = (byte)(data & 0xF);
        byte data2 = (byte)(data >> 4 & 0xF);
        byte data3 = (byte)(data >> 8 & 0xFF);
        short data4 = (short)(data >> 16 & 0xFFFF);
        this.blockData.set(index, data1);
        this.blockDataExtra.set(index, data2);
        this.blockDataHyperA[index] = data3;
        this.blockDataHyperB[index] = data4;
        this.hasBlockDataExtras |= data2 != 0;
        this.hasBlockDataHyperA |= data3 != 0;
        this.hasBlockDataHyperB |= data4 != 0;
        this.hasBlockIds |= data1 != 0 || this.hasBlockDataExtras || this.hasBlockDataHyperA || this.hasBlockDataHyperB;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlock(int x, int y, int z, int id, int data) {
        int index = BlockStorage.getIndex(x, y, z);
        this.setBlockId(index, id);
        this.setBlockData(index, data);
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(BlockStorage.getIndex(x, y, z));
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    public void setFullBlock(int x, int y, int z, int value) {
        this.setFullBlock(BlockStorage.getIndex(x, y, z), value);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public int[] getAndSetBlock(int x, int y, int z, int id, int meta) {
        return this.getAndSetBlock(BlockStorage.getIndex(x, y, z), id, meta);
    }

    private int[] getAndSetBlock(int index, int id, int meta) {
        int oldId = this.getBlockId(index);
        int oldData = this.getBlockData(index);
        this.setBlockId(index, id);
        this.setBlockData(index, meta);
        return new int[]{oldId, oldData};
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN", replaceWith="getAndSetFullBlock")
    public int getAndSetFullBlock(int x, int y, int z, int value) {
        return this.getAndSetFullBlock(BlockStorage.getIndex(x, y, z), value);
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    private int getAndSetFullBlock(int index, int value) {
        Preconditions.checkArgument((value < Short.MAX_VALUE ? 1 : 0) != 0, (Object)"Invalid full block");
        byte oldBlockExtra = this.hasBlockIdExtras ? this.blockIdsExtra[index] : (byte)0;
        byte oldBlock = this.hasBlockIds ? this.blockIds[index] : (byte)0;
        byte oldData = this.hasBlockIds ? this.blockData.get(index) : (byte)0;
        byte oldDataExtra = this.hasBlockDataExtras ? this.blockDataExtra.get(index) : (byte)0;
        byte newBlockExtra = (byte)(value >> 14 & 0xFF);
        byte newBlock = (byte)(value >> 6 & 0xFF);
        byte newData = (byte)(value & 0xF);
        byte newDataExtra = (byte)(value >> 4 & 3 & 0xF);
        if (oldBlock != newBlock) {
            this.blockIds[index] = newBlock;
        }
        if (oldBlockExtra != newBlockExtra) {
            this.blockIdsExtra[index] = newBlockExtra;
        }
        if (oldData != newData) {
            this.blockData.set(index, newData);
        }
        if (oldDataExtra != newDataExtra) {
            this.blockDataExtra.set(index, newDataExtra);
        }
        this.blockDataHyperA[index] = 0;
        this.blockDataHyperB[index] = 0;
        this.hasBlockIdExtras |= newBlockExtra != 0;
        this.hasBlockDataExtras |= newDataExtra != 0;
        this.hasBlockIds |= newBlock != 0 || this.hasBlockIdExtras || this.hasBlockDataExtras;
        return (oldBlockExtra & 0xFF) << 14 | (oldBlock & 0xFF) << 6 | (oldDataExtra & 0xF) << 4 | oldData;
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    private int getFullBlock(int index) {
        if (!this.hasBlockIds) {
            return 0;
        }
        byte block = this.blockIds[index];
        byte extra = this.hasBlockIdExtras ? this.blockIdsExtra[index] : (byte)0;
        byte data = this.blockData.get(index);
        byte dataExtra = this.hasBlockDataExtras ? this.blockDataExtra.get(index) : (byte)0;
        return (extra & 0xFF) << 14 | (block & 0xFF) << 6 | (dataExtra & 0xF) << 4 | data;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    private int[] getBlockState(int index) {
        if (!this.hasBlockIds) {
            return new int[]{0, 0};
        }
        return new int[]{this.getBlockId(index), this.getBlockData(index)};
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    private void setFullBlock(int index, int value) {
        Preconditions.checkArgument((value < Short.MAX_VALUE ? 1 : 0) != 0, (Object)"Invalid full block");
        byte extra = (byte)(value >> 14 & 0xFF);
        byte block = (byte)(value >> 6 & 0xFF);
        byte dataExtra = (byte)(value >> 4 & 3 & 0xF);
        byte data = (byte)(value & 0xF);
        this.blockIds[index] = block;
        this.blockIdsExtra[index] = extra;
        this.blockData.set(index, data);
        this.blockDataExtra.set(index, dataExtra);
        this.blockDataHyperA[index] = 0;
        this.blockDataHyperB[index] = 0;
        this.hasBlockIdExtras |= extra != 0;
        this.hasBlockDataExtras |= dataExtra != 0;
        this.hasBlockIds |= block != 0 || this.hasBlockIdExtras || this.hasBlockDataExtras;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public int[] getBlockState(int x, int y, int z) {
        return this.getBlockState(BlockStorage.getIndex(x, y, z));
    }

    public byte[] getBlockIds() {
        if (this.hasBlockIds) {
            return Arrays.copyOf(this.blockIds, this.blockIds.length);
        }
        return new byte[4096];
    }

    public byte[] getBlockIdsExtra() {
        if (this.hasBlockIdExtras) {
            return Arrays.copyOf(this.blockIdsExtra, this.blockIdsExtra.length);
        }
        return new byte[4096];
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public byte[] getBlockDataHyperA() {
        if (this.hasBlockDataHyperB) {
            return Arrays.copyOf(this.blockDataHyperA, this.blockDataHyperA.length);
        }
        return new byte[4096];
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public short[] getBlockDataHyperB() {
        if (this.hasBlockDataHyperB) {
            return Arrays.copyOf(this.blockDataHyperB, this.blockDataHyperB.length);
        }
        return new short[4096];
    }

    public byte[] getBlockData() {
        if (this.hasBlockIds) {
            return this.blockData.getData();
        }
        return new byte[2048];
    }

    public byte[] getBlockDataExtra() {
        if (this.hasBlockDataExtras) {
            return this.blockDataExtra.getData();
        }
        return new byte[2048];
    }

    public int[] getBlockIdsExtended() {
        int[] ids;
        block4: {
            ids = new int[4096];
            if (!this.hasBlockIds) break block4;
            if (this.hasBlockIdExtras) {
                for (int i = 0; i < 4096; ++i) {
                    ids[i] = this.blockIds[i] & 0xFF | (this.blockIdsExtra[i] & 0xFF) << 8;
                }
            } else {
                for (int i = 0; i < 4096; ++i) {
                    ids[i] = this.blockIds[i] & 0xFF;
                }
            }
        }
        return ids;
    }

    public int[] getBlockDataExtended() {
        int[] data;
        block4: {
            data = new int[4096];
            if (!this.hasBlockIds) break block4;
            if (this.hasBlockDataExtras || this.hasBlockDataHyperA || this.hasBlockDataHyperB) {
                for (int i = 0; i < 4096; ++i) {
                    data[i] = this.blockData.get(i) & 0xF | (this.blockDataExtra.get(i) & 0xF) << 4 | (this.blockDataHyperA[i] & 0xFF) << 8 | (this.blockDataHyperB[i] & 0xFFFF) << 16;
                }
            } else {
                for (int i = 0; i < 4096; ++i) {
                    data[i] = this.blockData.get(i) & 0xF;
                }
            }
        }
        return data;
    }

    public void recheckBlocks() {
        boolean hasMeta = false;
        for (byte by : this.blockIdsExtra) {
            if (by == 0) continue;
            this.hasBlockIdExtras = true;
            hasMeta = true;
            break;
        }
        for (short s : this.blockDataHyperB) {
            if (s == 0) continue;
            this.hasBlockDataHyperB = true;
            hasMeta = true;
            break;
        }
        byte[] byArray = this.blockDataHyperA;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            short s = byArray[i];
            if (s == 0) continue;
            this.hasBlockDataHyperA = true;
            hasMeta = true;
            break;
        }
        for (byte by : this.blockDataExtra.getData()) {
            if (by == 0) continue;
            this.hasBlockDataExtras = true;
            hasMeta = true;
            break;
        }
        if (hasMeta) {
            this.hasBlockIds = true;
        } else {
            for (byte by : this.blockIds) {
                if (by == 0) continue;
                this.hasBlockIds = true;
                break;
            }
        }
    }

    public BlockStorage copy() {
        return new BlockStorage((byte[])this.blockIds.clone(), (byte[])this.blockIdsExtra.clone(), this.blockData.copy(), this.blockDataExtra.copy(), (byte[])this.blockDataHyperA.clone(), (short[])this.blockDataHyperB.clone());
    }

    public boolean hasBlockIds() {
        return this.hasBlockIds;
    }

    public boolean hasBlockIdExtras() {
        return this.hasBlockIdExtras;
    }

    public boolean hasBlockDataExtras() {
        return this.hasBlockDataExtras;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean hasBlockDataHyperA() {
        return this.hasBlockDataHyperA;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean hasBlockDataHyperB() {
        return this.hasBlockDataHyperB;
    }
}

