/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import cn.nukkit.level.MovingObjectPosition;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;

public interface AxisAlignedBB
extends Cloneable {
    default public AxisAlignedBB setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.setMinX(minX);
        this.setMinY(minY);
        this.setMinZ(minZ);
        this.setMaxX(maxX);
        this.setMaxY(maxY);
        this.setMaxZ(maxZ);
        return this;
    }

    default public AxisAlignedBB addCoord(double x, double y, double z) {
        double minX = this.getMinX();
        double minY = this.getMinY();
        double minZ = this.getMinZ();
        double maxX = this.getMaxX();
        double maxY = this.getMaxY();
        double maxZ = this.getMaxZ();
        if (x < 0.0) {
            minX += x;
        }
        if (x > 0.0) {
            maxX += x;
        }
        if (y < 0.0) {
            minY += y;
        }
        if (y > 0.0) {
            maxY += y;
        }
        if (z < 0.0) {
            minZ += z;
        }
        if (z > 0.0) {
            maxZ += z;
        }
        return new SimpleAxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    default public AxisAlignedBB grow(double x, double y, double z) {
        return new SimpleAxisAlignedBB(this.getMinX() - x, this.getMinY() - y, this.getMinZ() - z, this.getMaxX() + x, this.getMaxY() + y, this.getMaxZ() + z);
    }

    default public AxisAlignedBB expand(double x, double y, double z) {
        this.setMinX(this.getMinX() - x);
        this.setMinY(this.getMinY() - y);
        this.setMinZ(this.getMinZ() - z);
        this.setMaxX(this.getMaxX() + x);
        this.setMaxY(this.getMaxY() + y);
        this.setMaxZ(this.getMaxZ() + z);
        return this;
    }

    default public AxisAlignedBB offset(double x, double y, double z) {
        this.setMinX(this.getMinX() + x);
        this.setMinY(this.getMinY() + y);
        this.setMinZ(this.getMinZ() + z);
        this.setMaxX(this.getMaxX() + x);
        this.setMaxY(this.getMaxY() + y);
        this.setMaxZ(this.getMaxZ() + z);
        return this;
    }

    default public AxisAlignedBB shrink(double x, double y, double z) {
        return new SimpleAxisAlignedBB(this.getMinX() + x, this.getMinY() + y, this.getMinZ() + z, this.getMaxX() - x, this.getMaxY() - y, this.getMaxZ() - z);
    }

    default public AxisAlignedBB contract(double x, double y, double z) {
        this.setMinX(this.getMinX() + x);
        this.setMinY(this.getMinY() + y);
        this.setMinZ(this.getMinZ() + z);
        this.setMaxX(this.getMaxX() - x);
        this.setMaxY(this.getMaxY() - y);
        this.setMaxZ(this.getMaxZ() - z);
        return this;
    }

    default public AxisAlignedBB setBB(AxisAlignedBB bb) {
        this.setMinX(bb.getMinX());
        this.setMinY(bb.getMinY());
        this.setMinZ(bb.getMinZ());
        this.setMaxX(bb.getMaxX());
        this.setMaxY(bb.getMaxY());
        this.setMaxZ(bb.getMaxZ());
        return this;
    }

    default public AxisAlignedBB getOffsetBoundingBox(BlockFace face, double x, double y, double z) {
        return this.getOffsetBoundingBox((double)face.getXOffset() * x, (double)face.getYOffset() * y, (double)face.getZOffset() * z);
    }

    default public AxisAlignedBB getOffsetBoundingBox(double x, double y, double z) {
        return new SimpleAxisAlignedBB(this.getMinX() + x, this.getMinY() + y, this.getMinZ() + z, this.getMaxX() + x, this.getMaxY() + y, this.getMaxZ() + z);
    }

    default public double calculateXOffset(AxisAlignedBB bb, double x) {
        double x2;
        double x1;
        if (bb.getMaxY() <= this.getMinY() || bb.getMinY() >= this.getMaxY()) {
            return x;
        }
        if (bb.getMaxZ() <= this.getMinZ() || bb.getMinZ() >= this.getMaxZ()) {
            return x;
        }
        if (x > 0.0 && bb.getMaxX() <= this.getMinX() && (x1 = this.getMinX() - bb.getMaxX()) < x) {
            x = x1;
        }
        if (x < 0.0 && bb.getMinX() >= this.getMaxX() && (x2 = this.getMaxX() - bb.getMinX()) > x) {
            x = x2;
        }
        return x;
    }

    default public double calculateYOffset(AxisAlignedBB bb, double y) {
        double y2;
        double y1;
        if (bb.getMaxX() <= this.getMinX() || bb.getMinX() >= this.getMaxX()) {
            return y;
        }
        if (bb.getMaxZ() <= this.getMinZ() || bb.getMinZ() >= this.getMaxZ()) {
            return y;
        }
        if (y > 0.0 && bb.getMaxY() <= this.getMinY() && (y1 = this.getMinY() - bb.getMaxY()) < y) {
            y = y1;
        }
        if (y < 0.0 && bb.getMinY() >= this.getMaxY() && (y2 = this.getMaxY() - bb.getMinY()) > y) {
            y = y2;
        }
        return y;
    }

    default public double calculateZOffset(AxisAlignedBB bb, double z) {
        double z2;
        double z1;
        if (bb.getMaxX() <= this.getMinX() || bb.getMinX() >= this.getMaxX()) {
            return z;
        }
        if (bb.getMaxY() <= this.getMinY() || bb.getMinY() >= this.getMaxY()) {
            return z;
        }
        if (z > 0.0 && bb.getMaxZ() <= this.getMinZ() && (z1 = this.getMinZ() - bb.getMaxZ()) < z) {
            z = z1;
        }
        if (z < 0.0 && bb.getMinZ() >= this.getMaxZ() && (z2 = this.getMaxZ() - bb.getMinZ()) > z) {
            z = z2;
        }
        return z;
    }

    default public boolean intersectsWith(AxisAlignedBB bb) {
        if (bb.getMaxY() > this.getMinY() && bb.getMinY() < this.getMaxY() && bb.getMaxX() > this.getMinX() && bb.getMinX() < this.getMaxX()) {
            return bb.getMaxZ() > this.getMinZ() && bb.getMinZ() < this.getMaxZ();
        }
        return false;
    }

    default public boolean isVectorInside(Vector3 vector) {
        return vector.x >= this.getMinX() && vector.x <= this.getMaxX() && vector.y >= this.getMinY() && vector.y <= this.getMaxY() && vector.z >= this.getMinZ() && vector.z <= this.getMaxZ();
    }

    default public double getAverageEdgeLength() {
        return (this.getMaxX() - this.getMinX() + this.getMaxY() - this.getMinY() + this.getMaxZ() - this.getMinZ()) / 3.0;
    }

    default public boolean isVectorInYZ(Vector3 vector) {
        return vector.y >= this.getMinY() && vector.y <= this.getMaxY() && vector.z >= this.getMinZ() && vector.z <= this.getMaxZ();
    }

    default public boolean isVectorInXZ(Vector3 vector) {
        return vector.x >= this.getMinX() && vector.x <= this.getMaxX() && vector.z >= this.getMinZ() && vector.z <= this.getMaxZ();
    }

    default public boolean isVectorInXY(Vector3 vector) {
        return vector.x >= this.getMinX() && vector.x <= this.getMaxX() && vector.y >= this.getMinY() && vector.y <= this.getMaxY();
    }

    default public MovingObjectPosition calculateIntercept(Vector3 pos1, Vector3 pos2) {
        Vector3 v1 = pos1.getIntermediateWithXValue(pos2, this.getMinX());
        Vector3 v2 = pos1.getIntermediateWithXValue(pos2, this.getMaxX());
        Vector3 v3 = pos1.getIntermediateWithYValue(pos2, this.getMinY());
        Vector3 v4 = pos1.getIntermediateWithYValue(pos2, this.getMaxY());
        Vector3 v5 = pos1.getIntermediateWithZValue(pos2, this.getMinZ());
        Vector3 v6 = pos1.getIntermediateWithZValue(pos2, this.getMaxZ());
        if (v1 != null && !this.isVectorInYZ(v1)) {
            v1 = null;
        }
        if (v2 != null && !this.isVectorInYZ(v2)) {
            v2 = null;
        }
        if (v3 != null && !this.isVectorInXZ(v3)) {
            v3 = null;
        }
        if (v4 != null && !this.isVectorInXZ(v4)) {
            v4 = null;
        }
        if (v5 != null && !this.isVectorInXY(v5)) {
            v5 = null;
        }
        if (v6 != null && !this.isVectorInXY(v6)) {
            v6 = null;
        }
        Vector3 vector = null;
        if (v1 != null) {
            vector = v1;
        }
        if (v2 != null && (vector == null || pos1.distanceSquared(v2) < pos1.distanceSquared(vector))) {
            vector = v2;
        }
        if (v3 != null && (vector == null || pos1.distanceSquared(v3) < pos1.distanceSquared(vector))) {
            vector = v3;
        }
        if (v4 != null && (vector == null || pos1.distanceSquared(v4) < pos1.distanceSquared(vector))) {
            vector = v4;
        }
        if (v5 != null && (vector == null || pos1.distanceSquared(v5) < pos1.distanceSquared(vector))) {
            vector = v5;
        }
        if (v6 != null && (vector == null || pos1.distanceSquared(v6) < pos1.distanceSquared(vector))) {
            vector = v6;
        }
        if (vector == null) {
            return null;
        }
        int face = -1;
        if (vector == v1) {
            face = 4;
        } else if (vector == v2) {
            face = 5;
        } else if (vector == v3) {
            face = 0;
        } else if (vector == v4) {
            face = 1;
        } else if (vector == v5) {
            face = 2;
        } else if (vector == v6) {
            face = 3;
        }
        return MovingObjectPosition.fromBlock(0, 0, 0, face, vector);
    }

    default public void setMinX(double minX) {
        throw new UnsupportedOperationException("Not mutable");
    }

    default public void setMinY(double minY) {
        throw new UnsupportedOperationException("Not mutable");
    }

    default public void setMinZ(double minZ) {
        throw new UnsupportedOperationException("Not mutable");
    }

    default public void setMaxX(double maxX) {
        throw new UnsupportedOperationException("Not mutable");
    }

    default public void setMaxY(double maxY) {
        throw new UnsupportedOperationException("Not mutable");
    }

    default public void setMaxZ(double maxZ) {
        throw new UnsupportedOperationException("Not mutable");
    }

    public double getMinX();

    public double getMinY();

    public double getMinZ();

    public double getMaxX();

    public double getMaxY();

    public double getMaxZ();

    public AxisAlignedBB clone();

    default public void forEach(BBConsumer action) {
        int minX = NukkitMath.floorDouble(this.getMinX());
        int minY = NukkitMath.floorDouble(this.getMinY());
        int minZ = NukkitMath.floorDouble(this.getMinZ());
        int maxX = NukkitMath.floorDouble(this.getMaxX());
        int maxY = NukkitMath.floorDouble(this.getMaxY());
        int maxZ = NukkitMath.floorDouble(this.getMaxZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    action.accept(x, y, z);
                }
            }
        }
    }

    public static interface BBConsumer<T> {
        public void accept(int var1, int var2, int var3);

        default public T get() {
            return null;
        }
    }
}

