/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.scheduler;

import cn.nukkit.Server;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncPool
extends ThreadPoolExecutor {
    private final Server server;

    public AsyncPool(Server server, int size) {
        super(size, Integer.MAX_VALUE, 60L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        this.setThreadFactory(runnable -> new Thread(runnable){
            {
                this.setDaemon(true);
                this.setName(String.format("Nukkit Asynchronous Task Handler #%s", AsyncPool.this.getPoolSize()));
            }
        });
        this.server = server;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        if (throwable != null) {
            this.server.getLogger().critical("Exception in asynchronous task", throwable);
        }
    }

    public Server getServer() {
        return this.server;
    }
}

