/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallable;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockDragonEgg
extends BlockFallable {
    @Override
    public String getName() {
        return "Dragon Egg";
    }

    @Override
    public int getId() {
        return 122;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 45.0;
    }

    @Override
    public int getLightLevel() {
        return 1;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.OBSIDIAN_BLOCK_COLOR;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 5) {
            this.teleport();
        }
        return super.onUpdate(type);
    }

    public void teleport() {
        for (int i = 0; i < 1000; ++i) {
            Block t = this.getLevel().getBlock(this.add(ThreadLocalRandom.current().nextInt(-16, 16), ThreadLocalRandom.current().nextInt(-16, 16), ThreadLocalRandom.current().nextInt(-16, 16)));
            if (t.getId() != 0) continue;
            int diffX = this.getFloorX() - t.getFloorX();
            int diffY = this.getFloorY() - t.getFloorY();
            int diffZ = this.getFloorZ() - t.getFloorZ();
            LevelEventPacket pk = new LevelEventPacket();
            pk.evid = 2010;
            pk.data = Math.abs(diffX) << 16 | Math.abs(diffY) << 8 | Math.abs(diffZ) | (diffX < 0 ? 1 : 0) << 24 | (diffY < 0 ? 1 : 0) << 25 | (diffZ < 0 ? 1 : 0) << 26;
            pk.x = this.getFloorX();
            pk.y = this.getFloorY();
            pk.z = this.getFloorZ();
            this.getLevel().addChunkPacket(this.getFloorX() >> 4, this.getFloorZ() >> 4, pk);
            this.getLevel().setBlock((Vector3)this, BlockDragonEgg.get(0), true);
            this.getLevel().setBlock((Vector3)t, this, true);
            return;
        }
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

