/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRedstoneDiode;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityComparator;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemRedstoneComparator;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.BlockColor;

public abstract class BlockRedstoneComparator
extends BlockRedstoneDiode {
    public BlockRedstoneComparator() {
        this(0);
    }

    public BlockRedstoneComparator(int meta) {
        super(meta);
    }

    @Override
    protected int getDelay() {
        return 2;
    }

    @Override
    public BlockFace getFacing() {
        return BlockFace.fromHorizontalIndex(this.getDamage());
    }

    public Mode getMode() {
        return (this.getDamage() & 4) > 0 ? Mode.SUBTRACT : Mode.COMPARE;
    }

    @Override
    protected BlockRedstoneComparator getUnpowered() {
        return (BlockRedstoneComparator)Block.get(149, this.getDamage());
    }

    @Override
    protected BlockRedstoneComparator getPowered() {
        return (BlockRedstoneComparator)Block.get(150, this.getDamage());
    }

    @Override
    protected int getRedstoneSignal() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        return blockEntity instanceof BlockEntityComparator ? ((BlockEntityComparator)blockEntity).getOutputSignal() : 0;
    }

    @Override
    public void updateState() {
        if (!this.level.isBlockTickPending(this, this)) {
            int power;
            int output = this.calculateOutput();
            BlockEntity blockEntity = this.level.getBlockEntity(this);
            int n = power = blockEntity instanceof BlockEntityComparator ? ((BlockEntityComparator)blockEntity).getOutputSignal() : 0;
            if (output != power || this.isPowered() != this.shouldBePowered()) {
                this.level.scheduleUpdate(this, this, 2);
            }
        }
    }

    @Override
    protected int calculateInputStrength() {
        int power = super.calculateInputStrength();
        BlockFace face = this.getFacing();
        Block block = this.getSide(face);
        if (block.hasComparatorInputOverride()) {
            power = block.getComparatorInputOverride();
        } else if (power < 15 && block.isNormalBlock() && (block = block.getSide(face)).hasComparatorInputOverride()) {
            power = block.getComparatorInputOverride();
        }
        return power;
    }

    @Override
    protected boolean shouldBePowered() {
        int input = this.calculateInputStrength();
        if (input >= 15) {
            return true;
        }
        if (input == 0) {
            return false;
        }
        int sidePower = this.getPowerOnSides();
        return sidePower == 0 || input >= sidePower;
    }

    private int calculateOutput() {
        return this.getMode() == Mode.SUBTRACT ? Math.max(this.calculateInputStrength() - this.getPowerOnSides(), 0) : this.calculateInputStrength();
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (this.getMode() == Mode.SUBTRACT) {
            this.setDamage(this.getDamage() - 4);
        } else {
            this.setDamage(this.getDamage() + 4);
        }
        this.level.addSound(this, Sound.RANDOM_CLICK, 1.0f, this.getMode() == Mode.SUBTRACT ? 0.55f : 0.5f);
        this.level.setBlock((Vector3)this, this, true, false);
        this.onChange();
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            this.onChange();
            return type;
        }
        return super.onUpdate(type);
    }

    private void onChange() {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return;
        }
        int output = this.calculateOutput();
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        int currentOutput = 0;
        if (blockEntity instanceof BlockEntityComparator) {
            BlockEntityComparator blockEntityComparator = (BlockEntityComparator)blockEntity;
            currentOutput = blockEntityComparator.getOutputSignal();
            blockEntityComparator.setOutputSignal(output);
        }
        if (currentOutput != output || this.getMode() == Mode.COMPARE) {
            boolean shouldBePowered = this.shouldBePowered();
            boolean isPowered = this.isPowered();
            if (isPowered && !shouldBePowered) {
                this.level.setBlock((Vector3)this, this.getUnpowered(), true, false);
            } else if (!isPowered && shouldBePowered) {
                this.level.setBlock((Vector3)this, this.getPowered(), true, false);
            }
            Block side = this.getSide(this.getFacing().getOpposite());
            side.onUpdate(6);
            this.level.updateAroundRedstone(side, null);
        }
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (super.place(item, block, target, face, fx, fy, fz, player)) {
            CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", "Comparator").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
            BlockEntityComparator comparator = (BlockEntityComparator)BlockEntity.createBlockEntity("Comparator", this.level.getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
            if (comparator == null) {
                return false;
            }
            this.onUpdate(6);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPowered() {
        return this.isPowered || (this.getDamage() & 8) > 0;
    }

    @Override
    public Item toItem() {
        return new ItemRedstoneComparator();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    public static enum Mode {
        COMPARE,
        SUBTRACT;

    }
}

