/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockSlab;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.utils.BlockColor;

public class BlockSlabStone4
extends BlockSlab {
    public static final int MOSSY_STONE_BRICKS = 0;
    public static final int SMOOTH_QUARTZ = 1;
    public static final int STONE = 2;
    public static final int CUT_SANDSTONE = 3;
    public static final int CUT_RED_SANDSTONE = 4;

    public BlockSlabStone4() {
        this(0);
    }

    public BlockSlabStone4(int meta) {
        super(meta, 423);
    }

    @Override
    public int getId() {
        return 421;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Mossy Stone Brick", "Smooth Quartz", "Stone", "Cut Sandstone", "Cut Red Sandstone", "", "", ""};
        return ((this.getDamage() & 8) > 0 ? "Upper " : "") + names[this.getDamage() & 7] + " Slab";
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            default: {
                return BlockColor.STONE_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.QUARTZ_BLOCK_COLOR;
            }
            case 3: {
                return BlockColor.SAND_BLOCK_COLOR;
            }
            case 4: 
        }
        return BlockColor.ORANGE_BLOCK_COLOR;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)(this.getDamage() & 7));
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

