/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBell;
import cn.nukkit.block.BlockButton;
import cn.nukkit.block.BlockConnectable;
import cn.nukkit.block.BlockFenceGate;
import cn.nukkit.block.BlockLantern;
import cn.nukkit.block.BlockPressurePlateBase;
import cn.nukkit.block.BlockSignPost;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockTorch;
import cn.nukkit.block.BlockTransparentHyperMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.InvalidBlockDamageException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitDifference(info="Extends BlockTransparentHyperMeta instead of BlockTransparentMeta, implements BlockConnectable only on PowerNukkit", since="1.3.0.0-PN")
public class BlockWall
extends BlockTransparentHyperMeta
implements BlockConnectable {
    private static final Logger log = LogManager.getLogger(BlockWall.class);
    private static final boolean SHOULD_FAIL = false;
    private static final boolean SHOULD_VALIDATE_META = true;
    private static final double MIN_POST_BB = 0.3125;
    private static final double MAX_POST_BB = 0.6875;
    @Deprecated
    @DeprecationDetails(reason="No longer matches the meta directly", replaceWith="WallType.COBBLESTONE", since="1.3.0.0-PN")
    public static final int NONE_MOSSY_WALL = 0;
    @Deprecated
    @DeprecationDetails(reason="No longer matches the meta directly", replaceWith="WallType.MOSSY_COBBLESTONE", since="1.3.0.0-PN")
    public static final int MOSSY_WALL = 1;
    private static final int[] INVALID_META_COMBINATIONS = new int[]{48, 192, 768, 3072, 14, 15};

    public BlockWall() {
        this(0);
    }

    @PowerNukkitDifference(since="1.3.0.0-PN", info="If an invalid metadata is given, it will remove the invalid bits automatically")
    public BlockWall(int meta) {
        this.setDamage(meta);
    }

    @Override
    public int getId() {
        return 139;
    }

    @Override
    @PowerNukkitDifference(since="1.3.0.0-PN", info="If an invalid metadata is given, it will remove the invalid bits automatically")
    public void setDamage(int meta) {
        if (this.getDamage() == meta) {
            return;
        }
        for (int invalidMetaCombination : INVALID_META_COMBINATIONS) {
            if ((meta & invalidMetaCombination) != invalidMetaCombination) continue;
            InvalidBlockDamageException exception = new InvalidBlockDamageException(this.getId(), meta, this.getDamage());
            if (!BlockWall.isInitializing()) {
                log.warn("Tried to set an invalid wall meta, the bits " + invalidMetaCombination + " were removed." + (this.level != null ? " " + this.getLocation() : ""), (Throwable)exception);
            }
            meta &= ~invalidMetaCombination;
        }
        super.setDamage(meta);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)(this.getDamage() & 0xF));
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 30.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    @PowerNukkitDifference(since="1.3.0.0-PN", info="Return the actual material color instead of transparent")
    public BlockColor getColor() {
        return this.getWallType().color;
    }

    private boolean shouldBeTall(Block above, BlockFace face) {
        switch (above.getId()) {
            case 0: 
            case 144: {
                return false;
            }
            case 461: {
                BlockBell bell = (BlockBell)above;
                return bell.getAttachmentType() == 0 && bell.getBlockFace().getAxis() != face.getAxis();
            }
            case 139: {
                return ((BlockWall)above).getConnectionType(face) != WallConnectionType.NONE;
            }
        }
        if (above instanceof BlockConnectable) {
            return ((BlockConnectable)((Object)above)).isConnected(face);
        }
        if (above instanceof BlockPressurePlateBase || above instanceof BlockStairs) {
            return true;
        }
        return above.isSolid() && !above.isTransparent() || this.shouldBeTallBasedOnBoundingBox(above, face);
    }

    private boolean shouldBeTallBasedOnBoundingBox(Block above, BlockFace face) {
        AxisAlignedBB boundingBox = above.getBoundingBox();
        if (boundingBox == null) {
            return false;
        }
        if ((boundingBox = boundingBox.getOffsetBoundingBox(-above.x, -above.y, -above.z)).getMinY() > 0.0) {
            return false;
        }
        int offset = face.getXOffset();
        if (offset < 0) {
            return boundingBox.getMinX() < 0.3125 && boundingBox.getMinZ() < 0.3125 && 0.6875 < boundingBox.getMaxZ();
        }
        if (offset > 0) {
            return 0.6875 < boundingBox.getMaxX() && 0.6875 < boundingBox.getMaxZ() && boundingBox.getMinZ() < 0.6875;
        }
        offset = face.getZOffset();
        if (offset < 0) {
            return boundingBox.getMinZ() < 0.3125 && boundingBox.getMinX() < 0.3125 && 0.3125 < boundingBox.getMaxX();
        }
        if (offset > 0) {
            return 0.6875 < boundingBox.getMaxZ() && 0.6875 < boundingBox.getMaxX() && boundingBox.getMinX() < 0.6875;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean autoConfigureState() {
        int previousMeta = this.getDamage();
        this.setWallPost(true);
        Block above = this.up(1, 0);
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            Block side = this.getSideAtLayer(0, blockFace);
            if (this.canConnect(side)) {
                try {
                    this.connect(blockFace, above, false);
                    continue;
                }
                catch (RuntimeException e) {
                    log.error("Failed to connect the block " + this + " at " + this.getLocation() + " to " + (Object)((Object)blockFace) + " which is " + side + " at " + side.getLocation());
                    throw e;
                }
            }
            this.disconnect(blockFace);
        }
        this.recheckPostConditions(above);
        return this.getDamage() != previousMeta;
    }

    @Override
    @PowerNukkitDifference(info="Will connect as expected", since="1.3.0.0-PN")
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.autoConfigureState()) {
                this.level.setBlock((Vector3)this, this, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    @PowerNukkitDifference(info="Will be placed on the right state", since="1.3.0.0-PN")
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.autoConfigureState();
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean isWallPost() {
        return (this.getDamage() & 0x1000) == 4096;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setWallPost(boolean wallPost) {
        this.setDamage(this.getDamage() & 0xFFFFEFFF | (wallPost ? 4096 : 0));
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public WallType getWallType() {
        int type = this.getDamage() & 0xF;
        if (type > WallType.VALUES.length) {
            type = 0;
        }
        return WallType.VALUES[type];
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setWallType(WallType type) {
        this.setDamage(this.getDamage() & 0xFFFFFFF0 | type.ordinal() & 0xF);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void clearConnections() {
        this.setDamage(this.getDamage() & 0xFFFFF00F);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public Map<BlockFace, WallConnectionType> getWallConnections() {
        EnumMap<BlockFace, WallConnectionType> connections = new EnumMap<BlockFace, WallConnectionType>(BlockFace.class);
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            WallConnectionType connectionType = this.getConnectionType(blockFace);
            if (connectionType == WallConnectionType.NONE) continue;
            connections.put(blockFace, connectionType);
        }
        return connections;
    }

    private int getBitIndex(BlockFace face) {
        assert (face.getHorizontalIndex() >= 0);
        return 4 + face.getHorizontalIndex() * 2;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public WallConnectionType getConnectionType(BlockFace blockFace) {
        if (blockFace.getHorizontalIndex() < 0) {
            return WallConnectionType.NONE;
        }
        int bitIndex = this.getBitIndex(blockFace);
        int typeOrdinal = this.getDamage() >> bitIndex & 3;
        return WallConnectionType.VALUES[typeOrdinal];
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean setConnection(BlockFace blockFace, WallConnectionType type) {
        if (blockFace.getHorizontalIndex() < 0) {
            return false;
        }
        int bitIndex = this.getBitIndex(blockFace);
        int damage = this.getDamage() & ~(3 << bitIndex);
        this.setDamage(damage |= type.ordinal() << bitIndex);
        return true;
    }

    @PowerNukkitDifference
    @Since(value="1.3.0.0-PN")
    public void autoUpdatePostFlag() {
        this.setWallPost(this.recheckPostConditions(this.up(1, 0)));
    }

    private boolean recheckPostConditions(Block above) {
        if ((this.getDamage() & 0xFF0) == 0) {
            return true;
        }
        Map<BlockFace, WallConnectionType> connections = this.getWallConnections();
        if (connections.size() != 2) {
            return true;
        }
        Iterator<Map.Entry<BlockFace, WallConnectionType>> iterator = connections.entrySet().iterator();
        Map.Entry<BlockFace, WallConnectionType> entryA = iterator.next();
        Map.Entry<BlockFace, WallConnectionType> entryB = iterator.next();
        if (entryA.getValue() != entryB.getValue() || entryA.getKey().getOpposite() != entryB.getKey()) {
            return true;
        }
        BlockFace.Axis axis = entryA.getKey().getAxis();
        switch (above.getId()) {
            case 140: 
            case 144: 
            case 176: 
            case 412: {
                return true;
            }
            case 208: {
                if (((Faceable)((Object)above)).getBlockFace() != BlockFace.UP) break;
                return true;
            }
            case 139: {
                if (!((BlockWall)above).isWallPost()) break;
                return true;
            }
            case 461: {
                BlockBell bell = (BlockBell)above;
                if (bell.getAttachmentType() != 0 || bell.getBlockFace().getAxis() != axis) break;
                return true;
            }
            default: {
                if (above instanceof BlockLantern) {
                    if (above.getDamage() != 0) break;
                    return true;
                }
                if (above.getId() == 69 || above instanceof BlockTorch || above instanceof BlockButton) {
                    if (((Faceable)((Object)above)).getBlockFace() != BlockFace.UP) break;
                    return true;
                }
                if (above instanceof BlockFenceGate) {
                    if (((Faceable)((Object)above)).getBlockFace().getAxis() != axis) break;
                    return true;
                }
                if (!(above instanceof BlockConnectable)) break;
                int shared = 0;
                for (BlockFace connection : ((BlockConnectable)((Object)above)).getConnections()) {
                    if (connections.containsKey((Object)connection) && ++shared == 2) break;
                }
                if (shared >= 2) break;
                return true;
            }
        }
        return above instanceof BlockSignPost;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean isSameHeightStraight() {
        Map<BlockFace, WallConnectionType> connections = this.getWallConnections();
        if (connections.size() != 2) {
            return false;
        }
        Iterator<Map.Entry<BlockFace, WallConnectionType>> iterator = connections.entrySet().iterator();
        Map.Entry<BlockFace, WallConnectionType> a = iterator.next();
        Map.Entry<BlockFace, WallConnectionType> b = iterator.next();
        return a.getValue() == b.getValue() && a.getKey().getOpposite() == b.getKey();
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean connect(BlockFace blockFace) {
        return this.connect(blockFace, true);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean connect(BlockFace blockFace, boolean recheckPost) {
        if (blockFace.getHorizontalIndex() < 0) {
            return false;
        }
        Block above = this.getSideAtLayer(0, BlockFace.UP);
        return this.connect(blockFace, above, recheckPost);
    }

    private boolean connect(BlockFace blockFace, Block above, boolean recheckPost) {
        WallConnectionType type;
        WallConnectionType wallConnectionType = type = this.shouldBeTall(above, blockFace) ? WallConnectionType.TALL : WallConnectionType.SHORT;
        if (this.setConnection(blockFace, type)) {
            if (recheckPost) {
                this.recheckPostConditions(above);
            }
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean disconnect(BlockFace blockFace) {
        if (blockFace.getHorizontalIndex() < 0) {
            return false;
        }
        if (this.setConnection(blockFace, WallConnectionType.NONE)) {
            this.autoUpdatePostFlag();
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.getDamage() == 1) {
            return "Mossy Cobblestone Wall";
        }
        return "Cobblestone Wall";
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        double e;
        boolean north = this.canConnect(this.getSide(BlockFace.NORTH));
        boolean south = this.canConnect(this.getSide(BlockFace.SOUTH));
        boolean west = this.canConnect(this.getSide(BlockFace.WEST));
        boolean east = this.canConnect(this.getSide(BlockFace.EAST));
        double n = north ? 0.0 : 0.25;
        double s = south ? 1.0 : 0.75;
        double w = west ? 0.0 : 0.25;
        double d = e = east ? 1.0 : 0.75;
        if (north && south && !west && !east) {
            w = 0.3125;
            e = 0.6875;
        } else if (!north && !south && west && east) {
            n = 0.3125;
            s = 0.6875;
        }
        return new SimpleAxisAlignedBB(this.x + w, this.y, this.z + n, this.x + e, this.y + 1.5, this.z + s);
    }

    @Override
    @PowerNukkitDifference(info="Will connect to glass panes, iron bars and fence gates", since="1.3.0.0-PN")
    public boolean canConnect(Block block) {
        switch (block.getId()) {
            case 101: 
            case 102: 
            case 139: 
            case 160: {
                return true;
            }
        }
        if (block instanceof BlockFenceGate) {
            BlockFenceGate fenceGate = (BlockFenceGate)block;
            return fenceGate.getBlockFace().getAxis() != this.calculateAxis(block);
        }
        if (block instanceof BlockStairs) {
            return ((BlockStairs)block).getBlockFace() == this.calculateFace(block);
        }
        return block.isSolid() && !block.isTransparent();
    }

    private BlockFace.Axis calculateAxis(Block side) {
        Position vector = side.subtract(this);
        return vector.x != 0.0 ? BlockFace.Axis.X : (vector.z != 0.0 ? BlockFace.Axis.Z : BlockFace.Axis.Y);
    }

    private BlockFace calculateFace(Block side) {
        BlockFace.Axis axis;
        Position vector = side.subtract(this);
        BlockFace.Axis axis2 = vector.x != 0.0 ? BlockFace.Axis.X : (axis = vector.z != 0.0 ? BlockFace.Axis.Z : BlockFace.Axis.Y);
        double direction = axis == BlockFace.Axis.X ? vector.x : (axis == BlockFace.Axis.Y ? vector.y : vector.z);
        return BlockFace.fromAxis(direction < 0.0 ? BlockFace.AxisDirection.NEGATIVE : BlockFace.AxisDirection.POSITIVE, axis);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean isConnected(BlockFace face) {
        return this.getConnectionType(face) != WallConnectionType.NONE;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public static enum WallType {
        COBBLESTONE,
        MOSSY_COBBLESTONE,
        GRANITE(BlockColor.DIRT_BLOCK_COLOR),
        DIORITE(BlockColor.QUARTZ_BLOCK_COLOR),
        ANDESITE,
        SANDSTONE(BlockColor.SAND_BLOCK_COLOR),
        BRICK(BlockColor.RED_BLOCK_COLOR),
        STONE_BRICK,
        MOSSY_STONE_BRICK,
        NETHER_BRICK(BlockColor.NETHERRACK_BLOCK_COLOR),
        END_STONE_BRICK(BlockColor.SAND_BLOCK_COLOR),
        PRISMARINE(BlockColor.CYAN_BLOCK_COLOR),
        RED_SANDSTONE(BlockColor.ORANGE_BLOCK_COLOR),
        RED_NETHER_BRICK(BlockColor.NETHERRACK_BLOCK_COLOR);

        private static final WallType[] VALUES;
        private final BlockColor color;

        private WallType(BlockColor color) {
            this.color = color;
        }

        private WallType() {
            this(BlockColor.STONE_BLOCK_COLOR);
        }

        @Since(value="1.3.0.0-PN")
        public BlockColor getColor() {
            return this.color;
        }

        static {
            VALUES = WallType.values();
        }
    }

    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public static enum WallConnectionType {
        NONE,
        SHORT,
        TALL;

        private static final WallConnectionType[] VALUES;

        static {
            VALUES = WallConnectionType.values();
        }
    }
}

