/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRail;
import cn.nukkit.block.BlockRailActivator;
import cn.nukkit.block.BlockRailPowered;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityHuman;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.entity.item.EntityVehicle;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.vehicle.VehicleMoveEvent;
import cn.nukkit.event.vehicle.VehicleUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemMinecart;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Location;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.MinecartType;
import cn.nukkit.utils.Rail;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public abstract class EntityMinecartAbstract
extends EntityVehicle {
    private String entityName;
    private static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private double currentSpeed = 0.0;
    private Block blockInside;
    private boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    private double maxSpeed = 0.4;
    private final boolean devs = false;
    private boolean hasUpdated = false;

    public abstract MinecartType getType();

    public abstract boolean isRideable();

    public EntityMinecartAbstract(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        this.setMaxHealth(40);
        this.setHealth(40.0f);
    }

    @Override
    public float getHeight() {
        return 0.7f;
    }

    @Override
    public float getWidth() {
        return 0.98f;
    }

    @Override
    protected float getDrag() {
        return 0.1f;
    }

    public void setName(String name) {
        this.entityName = name;
    }

    @Override
    @PowerNukkitDifference(info="Will never return null, returns the getSaveId() if it has no custom name", since="1.3.1.2-PN")
    public String getName() {
        if (this.hasCustomName()) {
            return this.entityName;
        }
        return this.getSaveId();
    }

    @Override
    public float getBaseOffset() {
        return 0.35f;
    }

    @Override
    public boolean hasCustomName() {
        return this.entityName != null;
    }

    @Override
    public boolean canDoInteraction() {
        return this.passengers.isEmpty() && this.getDisplayBlock() == null;
    }

    @Override
    public void initEntity() {
        super.initEntity();
        this.prepareDataProperty();
    }

    @Override
    @PowerNukkitDifference(since="1.3.1.2-PN", info="Will despawn instantly after being 'killed'")
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        if (!this.isAlive()) {
            this.despawnFromAll();
            this.close();
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0) {
            return false;
        }
        this.lastUpdate = currentTick;
        if (this.isAlive()) {
            Block block;
            int dz;
            int dy;
            super.onUpdate(currentTick);
            if (this.getHealth() < 20.0f) {
                this.setHealth(this.getHealth() + 1.0f);
            }
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastZ = this.z;
            this.motionY -= (double)0.04f;
            int dx = MathHelper.floor(this.x);
            if (Rail.isRailBlock(this.level.getBlockIdAt(dx, (dy = MathHelper.floor(this.y)) - 1, dz = MathHelper.floor(this.z)))) {
                --dy;
            }
            if (Rail.isRailBlock(block = this.level.getBlock(new Vector3(dx, dy, dz)))) {
                this.processMovement(dx, dy, dz, (BlockRail)block);
                if (block instanceof BlockRailActivator && ((BlockRailActivator)block).isActive()) {
                    this.activate(dx, dy, dz, (block.getDamage() & 8) != 0);
                }
            } else {
                this.setFalling();
            }
            this.checkBlockCollision();
            this.pitch = 0.0;
            double diffX = this.lastX - this.x;
            double diffZ = this.lastZ - this.z;
            double yawToChange = this.yaw;
            if (diffX * diffX + diffZ * diffZ > 0.001) {
                yawToChange = Math.atan2(diffZ, diffX) * 180.0 / Math.PI;
            }
            if (yawToChange < 0.0) {
                yawToChange -= yawToChange - yawToChange;
            }
            this.setRotation(yawToChange, this.pitch);
            Location from = new Location(this.lastX, this.lastY, this.lastZ, this.lastYaw, this.lastPitch, this.level);
            Location to = new Location(this.x, this.y, this.z, this.yaw, this.pitch, this.level);
            this.getServer().getPluginManager().callEvent(new VehicleUpdateEvent(this));
            if (!from.equals(to)) {
                this.getServer().getPluginManager().callEvent(new VehicleMoveEvent(this, from, to));
            }
            for (Entity entity : this.level.getNearbyEntities(this.boundingBox.grow(0.2, 0.0, 0.2), this)) {
                if (this.passengers.contains(entity) || !(entity instanceof EntityMinecartAbstract)) continue;
                entity.applyEntityCollision(this);
            }
            Iterator linkedIterator = this.passengers.iterator();
            while (linkedIterator.hasNext()) {
                Entity linked = (Entity)linkedIterator.next();
                if (linked.isAlive()) continue;
                if (linked.riding == this) {
                    linked.riding = null;
                }
                linkedIterator.remove();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        if (this.invulnerable) {
            return false;
        }
        source.setDamage(source.getDamage() * 15.0f);
        boolean attack = super.attack(source);
        if (this.isAlive()) {
            this.performHurtAnimation();
        }
        return attack;
    }

    public void dropItem() {
        this.level.dropItem(this, new ItemMinecart());
    }

    @Override
    @PowerNukkitDifference(info="Fixes a dupe issue when attacking too quickly", since="1.3.1.2-PN")
    public void kill() {
        if (!this.isAlive()) {
            return;
        }
        super.kill();
        if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
            this.dropItem();
        }
    }

    @Override
    @PowerNukkitDifference(info="Will not make a smoke particle and will do a proper dismount on the entities", since="1.3.1.2-PN")
    public void close() {
        super.close();
        for (Entity passenger : new ArrayList(this.passengers)) {
            this.dismountEntity(passenger);
        }
    }

    @Override
    public boolean onInteract(Player p, Item item, Vector3 clickedPos) {
        if (!this.passengers.isEmpty() && this.isRideable()) {
            return false;
        }
        if (this.blockInside == null) {
            this.mountEntity(p);
        }
        return super.onInteract(p, item, clickedPos);
    }

    @Override
    public void applyEntityCollision(Entity entity) {
        if (!(entity == this.riding || entity instanceof Player && ((Player)entity).getGamemode() == 3)) {
            double motiveZ;
            double motiveX;
            double square;
            if (!(entity instanceof EntityLiving) || entity instanceof EntityHuman || !(this.motionX * this.motionX + this.motionZ * this.motionZ > 0.01) || !this.passengers.isEmpty() || entity.riding != null || this.blockInside != null || this.riding == null) {
                // empty if block
            }
            if ((square = (motiveX = entity.x - this.x) * motiveX + (motiveZ = entity.z - this.z) * motiveZ) >= (double)1.0E-4f) {
                square = Math.sqrt(square);
                motiveX /= square;
                motiveZ /= square;
                double next = 1.0 / square;
                if (next > 1.0) {
                    next = 1.0;
                }
                motiveX *= next;
                motiveZ *= next;
                motiveX *= (double)0.1f;
                motiveZ *= (double)0.1f;
                motiveX *= 1.0 + this.entityCollisionReduction;
                motiveZ *= 1.0 + this.entityCollisionReduction;
                motiveX *= 0.5;
                motiveZ *= 0.5;
                if (entity instanceof EntityMinecartAbstract) {
                    Vector3 vec;
                    EntityMinecartAbstract mine = (EntityMinecartAbstract)entity;
                    double desinityX = mine.x - this.x;
                    double desinityZ = mine.z - this.z;
                    Vector3 vector = new Vector3(desinityX, 0.0, desinityZ).normalize();
                    double desinityXZ = Math.abs(vector.dot(vec = new Vector3(MathHelper.cos((float)this.yaw * ((float)Math.PI / 180)), 0.0, MathHelper.sin((float)this.yaw * ((float)Math.PI / 180))).normalize()));
                    if (desinityXZ < (double)0.8f) {
                        return;
                    }
                    double motX = mine.motionX + this.motionX;
                    double motZ = mine.motionZ + this.motionZ;
                    if (mine.getType().getId() == 2 && this.getType().getId() != 2) {
                        this.motionX *= (double)0.2f;
                        this.motionZ *= (double)0.2f;
                        this.motionX += mine.motionX - motiveX;
                        this.motionZ += mine.motionZ - motiveZ;
                        mine.motionX *= (double)0.95f;
                        mine.motionZ *= (double)0.95f;
                    } else if (mine.getType().getId() != 2 && this.getType().getId() == 2) {
                        mine.motionX *= (double)0.2f;
                        mine.motionZ *= (double)0.2f;
                        this.motionX += mine.motionX + motiveX;
                        this.motionZ += mine.motionZ + motiveZ;
                        this.motionX *= (double)0.95f;
                        this.motionZ *= (double)0.95f;
                    } else {
                        this.motionX *= (double)0.2f;
                        this.motionZ *= (double)0.2f;
                        this.motionX += (motX /= 2.0) - motiveX;
                        this.motionZ += (motZ /= 2.0) - motiveZ;
                        mine.motionX *= (double)0.2f;
                        mine.motionZ *= (double)0.2f;
                        mine.motionX += motX + motiveX;
                        mine.motionZ += motZ + motiveZ;
                    }
                } else {
                    this.motionX -= motiveX;
                    this.motionZ -= motiveZ;
                }
            }
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.saveEntityData();
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    protected void activate(int x, int y, int z, boolean flag) {
    }

    private void setFalling() {
        this.motionX = NukkitMath.clamp(this.motionX, -this.getMaxSpeed(), this.getMaxSpeed());
        this.motionZ = NukkitMath.clamp(this.motionZ, -this.getMaxSpeed(), this.getMaxSpeed());
        if (!this.hasUpdated) {
            for (Entity linked : this.passengers) {
                linked.setSeatPosition(this.getMountedOffset(linked).add(0.0f, 0.35f));
                this.updatePassengerPosition(linked);
            }
            this.hasUpdated = true;
        }
        if (this.onGround) {
            this.motionX *= this.derailedX;
            this.motionY *= this.derailedY;
            this.motionZ *= this.derailedZ;
        }
        this.move(this.motionX, this.motionY, this.motionZ);
        if (!this.onGround) {
            this.motionX *= this.flyingX;
            this.motionY *= this.flyingY;
            this.motionZ *= this.flyingZ;
        }
    }

    private void processMovement(int dx, int dy, int dz, BlockRail block) {
        double motZ;
        double motX;
        double motion;
        double playerYawPos;
        double playerYawNeg;
        double expectedSpeed;
        double squareOfFame;
        this.fallDistance = 0.0f;
        Vector3 vector = this.getNextRail(this.x, this.y, this.z);
        this.y = dy;
        boolean isPowered = false;
        boolean isSlowed = false;
        if (block instanceof BlockRailPowered) {
            isPowered = block.isActive();
            isSlowed = !block.isActive();
        }
        switch (Rail.Orientation.byMetadata(block.getRealMeta())) {
            case ASCENDING_NORTH: {
                this.motionX -= 0.0078125;
                this.y += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.motionX += 0.0078125;
                this.y += 1.0;
                break;
            }
            case ASCENDING_EAST: {
                this.motionZ += 0.0078125;
                this.y += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.motionZ -= 0.0078125;
                this.y += 1.0;
            }
        }
        int[][] facing = matrix[block.getRealMeta()];
        double facing1 = facing[1][0] - facing[0][0];
        double facing2 = facing[1][2] - facing[0][2];
        double speedOnTurns = Math.sqrt(facing1 * facing1 + facing2 * facing2);
        double realFacing = this.motionX * facing1 + this.motionZ * facing2;
        if (realFacing < 0.0) {
            facing1 = -facing1;
            facing2 = -facing2;
        }
        if ((squareOfFame = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ)) > 2.0) {
            squareOfFame = 2.0;
        }
        this.motionX = squareOfFame * facing1 / speedOnTurns;
        this.motionZ = squareOfFame * facing2 / speedOnTurns;
        Entity linked = this.getPassenger();
        if (linked instanceof EntityLiving && (expectedSpeed = this.currentSpeed) > 0.0) {
            playerYawNeg = -Math.sin(linked.yaw * Math.PI / 180.0);
            playerYawPos = Math.cos(linked.yaw * Math.PI / 180.0);
            motion = this.motionX * this.motionX + this.motionZ * this.motionZ;
            if (motion < 0.01) {
                this.motionX += playerYawNeg * 0.1;
                this.motionZ += playerYawPos * 0.1;
                isSlowed = false;
            }
        }
        if (isSlowed) {
            expectedSpeed = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (expectedSpeed < 0.03) {
                this.motionX *= 0.0;
                this.motionY *= 0.0;
                this.motionZ *= 0.0;
            } else {
                this.motionX *= 0.5;
                this.motionY *= 0.0;
                this.motionZ *= 0.5;
            }
        }
        playerYawNeg = (double)dx + 0.5 + (double)facing[0][0] * 0.5;
        playerYawPos = (double)dz + 0.5 + (double)facing[0][2] * 0.5;
        motion = (double)dx + 0.5 + (double)facing[1][0] * 0.5;
        double wallOfFame = (double)dz + 0.5 + (double)facing[1][2] * 0.5;
        facing1 = motion - playerYawNeg;
        facing2 = wallOfFame - playerYawPos;
        if (facing1 == 0.0) {
            this.x = (double)dx + 0.5;
            expectedSpeed = this.z - (double)dz;
        } else if (facing2 == 0.0) {
            this.z = (double)dz + 0.5;
            expectedSpeed = this.x - (double)dx;
        } else {
            motX = this.x - playerYawNeg;
            motZ = this.z - playerYawPos;
            expectedSpeed = (motX * facing1 + motZ * facing2) * 2.0;
        }
        this.x = playerYawNeg + facing1 * expectedSpeed;
        this.z = playerYawPos + facing2 * expectedSpeed;
        this.setPosition(new Vector3(this.x, this.y, this.z));
        motX = this.motionX;
        motZ = this.motionZ;
        if (!this.passengers.isEmpty()) {
            motX *= 0.75;
            motZ *= 0.75;
        }
        motX = NukkitMath.clamp(motX, -this.getMaxSpeed(), this.getMaxSpeed());
        motZ = NukkitMath.clamp(motZ, -this.getMaxSpeed(), this.getMaxSpeed());
        this.move(motX, 0.0, motZ);
        if (facing[0][1] != 0 && MathHelper.floor(this.x) - dx == facing[0][0] && MathHelper.floor(this.z) - dz == facing[0][2]) {
            this.setPosition(new Vector3(this.x, this.y + (double)facing[0][1], this.z));
        } else if (facing[1][1] != 0 && MathHelper.floor(this.x) - dx == facing[1][0] && MathHelper.floor(this.z) - dz == facing[1][2]) {
            this.setPosition(new Vector3(this.x, this.y + (double)facing[1][1], this.z));
        }
        this.applyDrag();
        Vector3 vector1 = this.getNextRail(this.x, this.y, this.z);
        if (vector1 != null && vector != null) {
            double d14 = (vector.y - vector1.y) * 0.05;
            squareOfFame = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (squareOfFame > 0.0) {
                this.motionX = this.motionX / squareOfFame * (squareOfFame + d14);
                this.motionZ = this.motionZ / squareOfFame * (squareOfFame + d14);
            }
            this.setPosition(new Vector3(this.x, vector1.y, this.z));
        }
        int floorX = MathHelper.floor(this.x);
        int floorZ = MathHelper.floor(this.z);
        if (floorX != dx || floorZ != dz) {
            squareOfFame = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.motionX = squareOfFame * (double)(floorX - dx);
            this.motionZ = squareOfFame * (double)(floorZ - dz);
        }
        if (isPowered) {
            double newMovie = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (newMovie > 0.01) {
                double nextMovie = 0.06;
                this.motionX += this.motionX / newMovie * nextMovie;
                this.motionZ += this.motionZ / newMovie * nextMovie;
            } else if (block.getOrientation() == Rail.Orientation.STRAIGHT_NORTH_SOUTH) {
                if (this.level.getBlock(new Vector3(dx - 1, dy, dz)).isNormalBlock()) {
                    this.motionX = 0.02;
                } else if (this.level.getBlock(new Vector3(dx + 1, dy, dz)).isNormalBlock()) {
                    this.motionX = -0.02;
                }
            } else if (block.getOrientation() == Rail.Orientation.STRAIGHT_EAST_WEST) {
                if (this.level.getBlock(new Vector3(dx, dy, dz - 1)).isNormalBlock()) {
                    this.motionZ = 0.02;
                } else if (this.level.getBlock(new Vector3(dx, dy, dz + 1)).isNormalBlock()) {
                    this.motionZ = -0.02;
                }
            }
        }
    }

    private void applyDrag() {
        if (!this.passengers.isEmpty() || !this.slowWhenEmpty) {
            this.motionX *= (double)0.997f;
            this.motionY *= 0.0;
            this.motionZ *= (double)0.997f;
        } else {
            this.motionX *= (double)0.96f;
            this.motionY *= 0.0;
            this.motionZ *= (double)0.96f;
        }
    }

    private Vector3 getNextRail(double dx, double dy, double dz) {
        Block block;
        int checkZ;
        int checkY;
        int checkX = MathHelper.floor(dx);
        if (Rail.isRailBlock(this.level.getBlockIdAt(checkX, (checkY = MathHelper.floor(dy)) - 1, checkZ = MathHelper.floor(dz)))) {
            --checkY;
        }
        if (Rail.isRailBlock(block = this.level.getBlock(new Vector3(checkX, checkY, checkZ)))) {
            double rail;
            int[][] facing = matrix[((BlockRail)block).getRealMeta()];
            double nextOne = (double)checkX + 0.5 + (double)facing[0][0] * 0.5;
            double nextTwo = (double)checkY + 0.5 + (double)facing[0][1] * 0.5;
            double nextThree = (double)checkZ + 0.5 + (double)facing[0][2] * 0.5;
            double nextFour = (double)checkX + 0.5 + (double)facing[1][0] * 0.5;
            double nextFive = (double)checkY + 0.5 + (double)facing[1][1] * 0.5;
            double nextSix = (double)checkZ + 0.5 + (double)facing[1][2] * 0.5;
            double nextSeven = nextFour - nextOne;
            double nextEight = (nextFive - nextTwo) * 2.0;
            double nextMax = nextSix - nextThree;
            if (nextSeven == 0.0) {
                rail = dz - (double)checkZ;
            } else if (nextMax == 0.0) {
                rail = dx - (double)checkX;
            } else {
                double whatOne = dx - nextOne;
                double whatTwo = dz - nextThree;
                rail = (whatOne * nextSeven + whatTwo * nextMax) * 2.0;
            }
            dx = nextOne + nextSeven * rail;
            dy = nextTwo + nextEight * rail;
            dz = nextThree + nextMax * rail;
            if (nextEight < 0.0) {
                dy += 1.0;
            }
            if (nextEight > 0.0) {
                dy += 0.5;
            }
            return new Vector3(dx, dy, dz);
        }
        return null;
    }

    public void setCurrentSpeed(double speed) {
        this.currentSpeed = speed;
    }

    private void prepareDataProperty() {
        this.setRollingAmplitude(0);
        this.setRollingDirection(1);
        if (this.namedTag.contains("CustomDisplayTile")) {
            if (this.namedTag.getBoolean("CustomDisplayTile")) {
                int display = this.namedTag.getInt("DisplayTile");
                int offSet = this.namedTag.getInt("DisplayOffset");
                this.setDataProperty(new ByteEntityData(18, 1));
                this.setDataProperty(new IntEntityData(16, display));
                this.setDataProperty(new IntEntityData(17, offSet));
            }
        } else {
            int display;
            int n = display = this.blockInside == null ? 0 : this.blockInside.getId() | this.blockInside.getDamage() << 16;
            if (display == 0) {
                this.setDataProperty(new ByteEntityData(18, 0));
                return;
            }
            this.setDataProperty(new ByteEntityData(18, 1));
            this.setDataProperty(new IntEntityData(16, display));
            this.setDataProperty(new IntEntityData(17, 6));
        }
    }

    private void saveEntityData() {
        boolean hasDisplay = super.getDataPropertyByte(18) == 1 || this.blockInside != null;
        this.namedTag.putBoolean("CustomDisplayTile", hasDisplay);
        if (hasDisplay) {
            int display = this.blockInside.getId() | this.blockInside.getDamage() << 16;
            int offSet = this.getDataPropertyInt(17);
            this.namedTag.putInt("DisplayTile", display);
            this.namedTag.putInt("DisplayOffset", offSet);
        }
    }

    public boolean setDisplayBlock(Block block) {
        return this.setDisplayBlock(block, true);
    }

    public boolean setDisplayBlock(Block block, boolean update) {
        if (!update) {
            this.blockInside = block.isNormalBlock() ? block : null;
            return true;
        }
        if (block != null) {
            if (block.isNormalBlock()) {
                this.blockInside = block;
                int display = this.blockInside.getId() | this.blockInside.getDamage() << 16;
                this.setDataProperty(new ByteEntityData(18, 1));
                this.setDataProperty(new IntEntityData(16, display));
                this.setDisplayBlockOffset(6);
            }
        } else {
            this.blockInside = null;
            this.setDataProperty(new ByteEntityData(18, 0));
            this.setDataProperty(new IntEntityData(16, 0));
            this.setDisplayBlockOffset(0);
        }
        return true;
    }

    public Block getDisplayBlock() {
        return this.blockInside;
    }

    public void setDisplayBlockOffset(int offset) {
        this.setDataProperty(new IntEntityData(17, offset));
    }

    public int getDisplayBlockOffset() {
        return super.getDataPropertyInt(17);
    }

    public boolean isSlowWhenEmpty() {
        return this.slowWhenEmpty;
    }

    public void setSlowWhenEmpty(boolean slow) {
        this.slowWhenEmpty = slow;
    }

    public Vector3 getFlyingVelocityMod() {
        return new Vector3(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector3 flying) {
        Objects.requireNonNull(flying, "Flying velocity modifiers cannot be null");
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector3 getDerailedVelocityMod() {
        return new Vector3(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector3 derailed) {
        Objects.requireNonNull(derailed, "Derailed velocity modifiers cannot be null");
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public void setMaximumSpeed(double speed) {
        this.maxSpeed = speed;
    }
}

