/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.mcregion;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.anvil.palette.BiomePalette;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.mcregion.McRegion;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.ByteArrayTag;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntArrayTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Zlib;
import java.io.ByteArrayInputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Chunk
extends BaseFullChunk {
    private CompoundTag nbt;

    public Chunk(LevelProvider level) {
        this(level, null);
    }

    public Chunk(Class<? extends LevelProvider> providerClass) {
        this((LevelProvider)null, null);
        this.providerClass = providerClass;
    }

    public Chunk(Class<? extends LevelProvider> providerClass, CompoundTag nbt) {
        this((LevelProvider)null, nbt);
        this.providerClass = providerClass;
    }

    public Chunk(LevelProvider level, CompoundTag nbt) {
        int i;
        this.provider = level;
        if (level != null) {
            this.providerClass = level.getClass();
        }
        if (nbt == null) {
            return;
        }
        this.nbt = nbt;
        if (!this.nbt.contains("Entities") || !(this.nbt.get("Entities") instanceof ListTag)) {
            this.nbt.putList(new ListTag("Entities"));
        }
        if (!this.nbt.contains("TileEntities") || !(this.nbt.get("TileEntities") instanceof ListTag)) {
            this.nbt.putList(new ListTag("TileEntities"));
        }
        if (!this.nbt.contains("TileTicks") || !(this.nbt.get("TileTicks") instanceof ListTag)) {
            this.nbt.putList(new ListTag("TileTicks"));
        }
        if (!this.nbt.contains("Biomes") || !(this.nbt.get("Biomes") instanceof ByteArrayTag)) {
            this.nbt.putByteArray("Biomes", new byte[256]);
        }
        if (!this.nbt.contains("HeightMap") || !(this.nbt.get("HeightMap") instanceof IntArrayTag)) {
            this.nbt.putIntArray("HeightMap", new int[256]);
        }
        if (!this.nbt.contains("Blocks")) {
            this.nbt.putByteArray("Blocks", new byte[32768]);
        }
        if (!this.nbt.contains("Data")) {
            this.nbt.putByteArray("Data", new byte[16384]);
            this.nbt.putByteArray("SkyLight", new byte[16384]);
            this.nbt.putByteArray("BlockLight", new byte[16384]);
        }
        HashMap<Integer, Integer> extraData = new HashMap<Integer, Integer>();
        if (!this.nbt.contains("ExtraData") || !(this.nbt.get("ExtraData") instanceof ByteArrayTag)) {
            this.nbt.putByteArray("ExtraData", Binary.writeInt(0));
        } else {
            BinaryStream stream = new BinaryStream(this.nbt.getByteArray("ExtraData"));
            for (i = 0; i < stream.getInt(); ++i) {
                int key = stream.getInt();
                extraData.put(key, stream.getShort());
            }
        }
        this.setPosition(this.nbt.getInt("xPos"), this.nbt.getInt("zPos"));
        this.blocks = this.nbt.getByteArray("Blocks");
        this.data = this.nbt.getByteArray("Data");
        this.skyLight = this.nbt.getByteArray("SkyLight");
        this.blockLight = this.nbt.getByteArray("BlockLight");
        if (this.nbt.contains("BiomeColors")) {
            this.biomes = new byte[256];
            int[] biomeColors = this.nbt.getIntArray("BiomeColors");
            if (biomeColors.length == 256) {
                BiomePalette palette = new BiomePalette(biomeColors);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        this.biomes[x << 4 | z] = (byte)(palette.get(x, z) >> 24);
                    }
                }
            }
        } else {
            this.biomes = this.nbt.getByteArray("Biomes");
        }
        int[] heightMap = this.nbt.getIntArray("HeightMap");
        this.heightMap = new byte[256];
        if (heightMap.length != 256) {
            Arrays.fill(this.heightMap, (byte)-1);
        } else {
            for (i = 0; i < heightMap.length; ++i) {
                this.heightMap[i] = (byte)heightMap[i];
            }
        }
        if (!extraData.isEmpty()) {
            this.extraData = extraData;
        }
        this.NBTentities = this.nbt.getList("Entities").getAll();
        this.NBTtiles = this.nbt.getList("TileEntities").getAll();
        this.nbt.remove("Blocks");
        this.nbt.remove("Data");
        this.nbt.remove("SkyLight");
        this.nbt.remove("BlockLight");
        this.nbt.remove("BiomeColors");
        this.nbt.remove("HeightMap");
        this.nbt.remove("Biomes");
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.blocks[x << 11 | z << 7 | y] & 0xFF;
    }

    @Override
    public int getBlockId(int x, int y, int z, int layer) {
        if (layer == 0) {
            return this.getBlockId(x, y, z);
        }
        return 0;
    }

    @Override
    public void setBlockId(int x, int y, int z, int id) {
        this.blocks[x << 11 | z << 7 | y] = (byte)id;
        this.setChanged();
    }

    @Override
    public void setBlockId(int x, int y, int z, int layer, int id) {
        if (layer == 0) {
            this.setBlockId(x, y, z, id);
        }
    }

    @Override
    public int getBlockData(int x, int y, int z) {
        int b = this.data[x << 10 | z << 6 | y >> 1] & 0xFF;
        if ((y & 1) == 0) {
            return b & 0xF;
        }
        return b >> 4;
    }

    @Override
    public int getBlockData(int x, int y, int z, int layer) {
        if (layer == 0) {
            return this.getBlockData(x, y, z);
        }
        return 0;
    }

    @Override
    public void setBlockData(int x, int y, int z, int data) {
        int i = x << 10 | z << 6 | y >> 1;
        int old = this.data[i] & 0xFF;
        this.data[i] = (y & 1) == 0 ? (byte)(old & 0xF0 | data & 0xF) : (byte)((data & 0xF) << 4 | old & 0xF);
        this.setChanged();
    }

    @Override
    public void setBlockData(int x, int y, int z, int layer, int data) {
        if (layer == 0) {
            this.setBlockData(x, y, z, data);
        }
    }

    @Override
    public int getFullBlock(int x, int y, int z) {
        int i = x << 11 | z << 7 | y;
        int block = this.blocks[i] & 0xFF;
        int data = this.data[i >> 1] & 0xFF;
        if ((y & 1) == 0) {
            return block << 4 | data & 0xF;
        }
        return block << 4 | data >> 4;
    }

    @Override
    public int getFullBlock(int x, int y, int z, int layer) {
        if (layer == 0) {
            return this.getFullBlock(x, y, z);
        }
        return 0;
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId) {
        return this.setBlock(x, y, z, blockId, 0);
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId, int meta) {
        int i = x << 11 | z << 7 | y;
        boolean changed = false;
        byte id = (byte)blockId;
        if (this.blocks[i] != id) {
            this.blocks[i] = id;
            changed = true;
        }
        if (Block.hasMeta[blockId]) {
            int old = this.data[i >>= 1] & 0xFF;
            if ((y & 1) == 0) {
                this.data[i] = (byte)(old & 0xF0 | meta & 0xF);
                if ((old & 0xF) != meta) {
                    changed = true;
                }
            } else {
                this.data[i] = (byte)((meta & 0xF) << 4 | old & 0xF);
                if (meta != old >> 4) {
                    changed = true;
                }
            }
        }
        if (changed) {
            this.setChanged();
        }
        return changed;
    }

    @Override
    public Block getAndSetBlock(int x, int y, int z, Block block) {
        int previousData;
        int i = x << 11 | z << 7 | y;
        boolean changed = false;
        byte previousId = this.blocks[i];
        byte id = (byte)block.getId();
        if (previousId != id) {
            this.blocks[i] = id;
            changed = true;
        }
        int old = this.data[i >>= 1] & 0xFF;
        if ((y & 1) == 0) {
            previousData = old & 0xF;
            if (Block.hasMeta[block.getId()]) {
                this.data[i] = (byte)(old & 0xF0 | block.getDamage() & 0xF);
                if (block.getDamage() != previousData) {
                    changed = true;
                }
            }
        } else {
            previousData = old >> 4;
            if (Block.hasMeta[block.getId()]) {
                this.data[i] = (byte)((block.getDamage() & 0xF) << 4 | old & 0xF);
                if (block.getDamage() != previousData) {
                    changed = true;
                }
            }
        }
        if (changed) {
            this.setChanged();
        }
        return Block.get((int)previousId, previousData);
    }

    @Override
    public Block getAndSetBlock(int x, int y, int z, int layer, Block block) {
        if (layer == 0) {
            return this.getAndSetBlock(x, y, z, block);
        }
        return Block.get(0);
    }

    @Override
    public int getBlockSkyLight(int x, int y, int z) {
        int sl = this.skyLight[x << 10 | z << 6 | y >> 1] & 0xFF;
        if ((y & 1) == 0) {
            return sl & 0xF;
        }
        return sl >> 4;
    }

    @Override
    public void setBlockSkyLight(int x, int y, int z, int level) {
        int i = x << 10 | z << 6 | y >> 1;
        int old = this.skyLight[i] & 0xFF;
        this.skyLight[i] = (y & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
        this.setChanged();
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        int b = this.blockLight[x << 10 | z << 6 | y >> 1] & 0xFF;
        if ((y & 1) == 0) {
            return b & 0xF;
        }
        return b >> 4;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int level) {
        int i = x << 10 | z << 6 | y >> 1;
        int old = this.blockLight[i] & 0xFF;
        this.blockLight[i] = (y & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
        this.setChanged();
    }

    @Override
    public boolean isLightPopulated() {
        return this.nbt.getBoolean("LightPopulated");
    }

    @Override
    public void setLightPopulated() {
        this.setLightPopulated(true);
    }

    @Override
    public void setLightPopulated(boolean value) {
        this.nbt.putBoolean("LightPopulated", value);
        this.setChanged();
    }

    @Override
    public boolean isPopulated() {
        return this.nbt.contains("TerrainPopulated") && this.nbt.getBoolean("TerrainPopulated");
    }

    @Override
    public void setPopulated() {
        this.setPopulated(true);
    }

    @Override
    public void setPopulated(boolean value) {
        this.nbt.putBoolean("TerrainPopulated", value);
        this.setChanged();
    }

    @Override
    public boolean isGenerated() {
        if (this.nbt.contains("TerrainGenerated")) {
            return this.nbt.getBoolean("TerrainGenerated");
        }
        if (this.nbt.contains("TerrainPopulated")) {
            return this.nbt.getBoolean("TerrainPopulated");
        }
        return false;
    }

    @Override
    public void setGenerated() {
        this.setGenerated(true);
    }

    @Override
    public void setGenerated(boolean value) {
        this.nbt.putBoolean("TerrainGenerated", value);
        this.setChanged();
    }

    @Override
    public byte[] getBlockIdArray(int layer) {
        if (layer == 0) {
            return this.getBlockIdArray();
        }
        return new byte[this.blocks.length];
    }

    @Override
    public byte[] getBlockDataArray(int layer) {
        if (layer == 0) {
            return this.getBlockDataArray();
        }
        return new byte[this.data.length];
    }

    public static Chunk fromBinary(byte[] data) {
        return Chunk.fromBinary(data, null);
    }

    public static Chunk fromBinary(byte[] data, LevelProvider provider) {
        try {
            CompoundTag chunk = NBTIO.read(new ByteArrayInputStream(Zlib.inflate(data)), ByteOrder.BIG_ENDIAN);
            if (!chunk.contains("Level") || !(chunk.get("Level") instanceof CompoundTag)) {
                return null;
            }
            return new Chunk(provider != null ? provider : (LevelProvider)McRegion.class.newInstance(), chunk.getCompound("Level"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Chunk fromFastBinary(byte[] data) {
        return Chunk.fromFastBinary(data, null);
    }

    public static Chunk fromFastBinary(byte[] data, LevelProvider provider) {
        try {
            int offset = 0;
            Chunk chunk = new Chunk(provider != null ? provider : (LevelProvider)McRegion.class.newInstance(), null);
            chunk.provider = provider;
            int chunkX = Binary.readInt(Arrays.copyOfRange(data, offset, offset + 3));
            int chunkZ = Binary.readInt(Arrays.copyOfRange(data, offset += 4, offset + 3));
            chunk.setPosition(chunkX, chunkZ);
            chunk.blocks = Arrays.copyOfRange(data, offset += 4, offset + Short.MAX_VALUE);
            chunk.data = Arrays.copyOfRange(data, offset += 32768, offset + 16383);
            chunk.skyLight = Arrays.copyOfRange(data, offset += 16384, offset + 16383);
            chunk.blockLight = Arrays.copyOfRange(data, offset += 16384, offset + 16383);
            chunk.heightMap = Arrays.copyOfRange(data, offset += 16384, offset + 256);
            chunk.biomes = Arrays.copyOfRange(data, offset += 256, offset + 256);
            offset += 256;
            byte flags = data[offset++];
            chunk.nbt.putByte("TerrainGenerated", flags & 1);
            chunk.nbt.putByte("TerrainPopulated", flags >> 1 & 1);
            chunk.nbt.putByte("LightPopulated", flags >> 2 & 1);
            return chunk;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] toFastBinary() {
        BinaryStream stream = new BinaryStream(new byte[65536]);
        stream.put(Binary.writeInt(this.getX()));
        stream.put(Binary.writeInt(this.getZ()));
        stream.put(this.getBlockIdArray());
        stream.put(this.getBlockDataArray());
        stream.put(this.getBlockSkyLightArray());
        stream.put(this.getBlockLightArray());
        stream.put(this.getHeightMapArray());
        stream.put(this.getBiomeIdArray());
        stream.putByte((byte)((this.isLightPopulated() ? 4 : 0) + (this.isPopulated() ? 4 : 0) + (this.isGenerated() ? 1 : 0)));
        return stream.getBuffer();
    }

    @Override
    public byte[] toBinary() {
        CompoundTag nbt = this.getNBT().copy();
        nbt.remove("BiomeColors");
        nbt.putInt("xPos", this.getX());
        nbt.putInt("zPos", this.getZ());
        if (this.isGenerated()) {
            nbt.putByteArray("Blocks", this.getBlockIdArray());
            nbt.putByteArray("Data", this.getBlockDataArray());
            nbt.putByteArray("SkyLight", this.getBlockSkyLightArray());
            nbt.putByteArray("BlockLight", this.getBlockLightArray());
            nbt.putByteArray("Biomes", this.getBiomeIdArray());
            int[] heightInts = new int[256];
            Object heightBytes = this.getHeightMapArray();
            for (int i = 0; i < heightInts.length; ++i) {
                heightInts[i] = heightBytes[i] & 0xFF;
            }
            nbt.putIntArray("HeightMap", heightInts);
        }
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (Entity entity : this.getEntities().values()) {
            if (entity instanceof Player || entity.closed) continue;
            entity.saveNBT();
            entities.add(entity.namedTag);
        }
        ListTag<CompoundTag> entityListTag = new ListTag<CompoundTag>("Entities");
        entityListTag.setAll(entities);
        nbt.putList(entityListTag);
        ArrayList<CompoundTag> tiles = new ArrayList<CompoundTag>();
        for (BlockEntity blockEntity : this.getBlockEntities().values()) {
            blockEntity.saveNBT();
            tiles.add(blockEntity.namedTag);
        }
        ListTag<CompoundTag> tileListTag = new ListTag<CompoundTag>("TileEntities");
        tileListTag.setAll(tiles);
        nbt.putList(tileListTag);
        BinaryStream extraData = new BinaryStream();
        Map<Integer, Integer> extraDataArray = this.getBlockExtraDataArray();
        extraData.putInt(extraDataArray.size());
        for (Integer key : extraDataArray.keySet()) {
            extraData.putInt(key);
            extraData.putShort(extraDataArray.get(key));
        }
        nbt.putByteArray("ExtraData", extraData.getBuffer());
        CompoundTag chunk = new CompoundTag("");
        chunk.putCompound("Level", nbt);
        try {
            return Zlib.deflate(NBTIO.write(chunk, ByteOrder.BIG_ENDIAN), 7);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CompoundTag getNBT() {
        return this.nbt;
    }

    public static Chunk getEmptyChunk(int chunkX, int chunkZ) {
        return Chunk.getEmptyChunk(chunkX, chunkZ, null);
    }

    public static Chunk getEmptyChunk(int chunkX, int chunkZ, LevelProvider provider) {
        try {
            Chunk chunk = provider != null ? new Chunk(provider, null) : new Chunk(McRegion.class, null);
            chunk.setPosition(chunkX, chunkZ);
            chunk.data = new byte[16384];
            chunk.blocks = new byte[32768];
            byte[] skyLight = new byte[16384];
            Arrays.fill(skyLight, (byte)-1);
            chunk.skyLight = skyLight;
            chunk.blockLight = chunk.data;
            chunk.heightMap = new byte[256];
            chunk.biomes = new byte[256];
            chunk.nbt.putByte("V", 1);
            chunk.nbt.putLong("InhabitedTime", 0L);
            chunk.nbt.putBoolean("TerrainGenerated", false);
            chunk.nbt.putBoolean("TerrainPopulated", false);
            chunk.nbt.putBoolean("LightPopulated", false);
            return chunk;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getBlockIdAt(int x, int y, int z, int layer) {
        if (layer == 0) {
            return this.getBlockIdAt(x, y, z);
        }
        return 0;
    }

    @Override
    public void setBlockIdAt(int x, int y, int z, int layer, int id) {
        if (layer == 0) {
            this.setBlockIdAt(x, y, z, id);
        }
    }

    @Override
    public int getBlockDataAt(int x, int y, int z, int layer) {
        if (layer == 0) {
            return this.getBlockDataAt(x, y, z);
        }
        return 0;
    }

    @Override
    public void setBlockDataAt(int x, int y, int z, int layer, int data) {
        if (layer == 0) {
            this.setBlockDataAt(x, y, z, data);
        }
    }
}

