/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.tree;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.generator.object.tree.TreeGenerator;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;

public abstract class HugeTreesGenerator
extends TreeGenerator {
    protected final int baseHeight;
    protected final Block woodMetadata;
    protected final Block leavesMetadata;
    protected int extraRandomHeight;

    public HugeTreesGenerator(int baseHeightIn, int extraRandomHeightIn, Block woodMetadataIn, Block leavesMetadataIn) {
        this.baseHeight = baseHeightIn;
        this.extraRandomHeight = extraRandomHeightIn;
        this.woodMetadata = woodMetadataIn;
        this.leavesMetadata = leavesMetadataIn;
    }

    protected int getHeight(NukkitRandom rand) {
        int i = rand.nextBoundedInt(3) + this.baseHeight;
        if (this.extraRandomHeight > 1) {
            i += rand.nextBoundedInt(this.extraRandomHeight);
        }
        return i;
    }

    private boolean isSpaceAt(ChunkManager worldIn, Vector3 leavesPos, int height) {
        boolean flag = true;
        if (leavesPos.getY() >= 1.0 && leavesPos.getY() + (double)height + 1.0 <= 256.0) {
            for (int i = 0; i <= 1 + height; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + height - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        Vector3 blockPos = leavesPos.add(k, i, l);
                        if (!(leavesPos.getY() + (double)i < 0.0) && !(leavesPos.getY() + (double)i >= 256.0) && this.canGrowInto(worldIn.getBlockIdAt((int)blockPos.x, (int)blockPos.y, (int)blockPos.z))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean ensureDirtsUnderneath(Vector3 pos, ChunkManager worldIn) {
        Vector3 blockpos = pos.down();
        int block = worldIn.getBlockIdAt((int)blockpos.x, (int)blockpos.y, (int)blockpos.z);
        if ((block == 2 || block == 3) && pos.getY() >= 2.0) {
            this.setDirtAt(worldIn, blockpos);
            this.setDirtAt(worldIn, blockpos.east());
            this.setDirtAt(worldIn, blockpos.south());
            this.setDirtAt(worldIn, blockpos.south().east());
            return true;
        }
        return false;
    }

    protected boolean ensureGrowable(ChunkManager worldIn, NukkitRandom rand, Vector3 treePos, int p_175929_4_) {
        return this.isSpaceAt(worldIn, treePos, p_175929_4_) && this.ensureDirtsUnderneath(treePos, worldIn);
    }

    protected void growLeavesLayerStrict(ChunkManager worldIn, Vector3 layerCenter, int width) {
        int i = width * width;
        for (int j = -width; j <= width + 1; ++j) {
            for (int k = -width; k <= width + 1; ++k) {
                int l = j - 1;
                int i1 = k - 1;
                if (j * j + k * k > i && l * l + i1 * i1 > i && j * j + i1 * i1 > i && l * l + k * k > i) continue;
                Vector3 blockpos = layerCenter.add(j, 0.0, k);
                int id = worldIn.getBlockIdAt((int)blockpos.x, (int)blockpos.y, (int)blockpos.z);
                if (id != 0 && id != 18) continue;
                this.setBlockAndNotifyAdequately(worldIn, blockpos, this.leavesMetadata);
            }
        }
    }

    protected void growLeavesLayer(ChunkManager worldIn, Vector3 layerCenter, int width) {
        int i = width * width;
        for (int j = -width; j <= width; ++j) {
            for (int k = -width; k <= width; ++k) {
                if (j * j + k * k > i) continue;
                Vector3 blockpos = layerCenter.add(j, 0.0, k);
                int id = worldIn.getBlockIdAt((int)blockpos.x, (int)blockpos.y, (int)blockpos.z);
                if (id != 0 && id != 18) continue;
                this.setBlockAndNotifyAdequately(worldIn, blockpos, this.leavesMetadata);
            }
        }
    }
}

