/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.math.BlockFace;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;

@PowerNukkitOnly
@Since(value="1.3.0.0-PN")
public interface BlockConnectable {
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public Block getSideAtLayer(int var1, BlockFace var2);

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public boolean canConnect(Block var1);

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public boolean isStraight() {
        Set<BlockFace> connections = this.getConnections();
        if (connections.size() != 2) {
            return false;
        }
        Iterator<BlockFace> iterator = connections.iterator();
        BlockFace a = iterator.next();
        BlockFace b = iterator.next();
        return a.getOpposite() == b;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public Set<BlockFace> getConnections() {
        EnumSet<BlockFace> connections = EnumSet.noneOf(BlockFace.class);
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            if (!this.isConnected(blockFace)) continue;
            connections.add(blockFace);
        }
        return connections;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public boolean isConnected(BlockFace face) {
        return this.canConnect(this.getSideAtLayer(0, face));
    }
}

