/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDoubleSlabStone;
import cn.nukkit.block.BlockSlabStone4;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.utils.BlockColor;

public class BlockDoubleSlabStone4
extends BlockDoubleSlabStone {
    public static final int MOSSY_STONE_BRICKS = 0;
    public static final int SMOOTH_QUARTZ = 1;
    public static final int STONE = 2;
    public static final int CUT_SANDSTONE = 3;
    public static final int CUT_RED_SANDSTONE = 4;

    public BlockDoubleSlabStone4() {
        this(0);
    }

    public BlockDoubleSlabStone4(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 423;
    }

    @Override
    public double getResistance() {
        return this.getToolType() > 1 ? 30.0 : 15.0;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Mossy Stone Brick", "Smooth Quartz", "Stone", "Cut Sandstone", "Cut Red Sandstone", "", "", ""};
        return "Double " + names[this.getDamage() & 7] + " Slab";
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockSlabStone4(), (Integer)(this.getDamage() & 7));
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            Item drop = Block.get(421, this.getDamage() & 7).toItem();
            drop.setCount(2);
            return new Item[]{drop};
        }
        return new Item[0];
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            default: {
                return BlockColor.STONE_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.QUARTZ_BLOCK_COLOR;
            }
            case 3: {
                return BlockColor.SAND_BLOCK_COLOR;
            }
            case 4: 
        }
        return BlockColor.ORANGE_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

