/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockFenceGate
extends BlockTransparentMeta
implements Faceable {
    private static final double[] offMinX = new double[2];
    private static final double[] offMinZ = new double[2];
    private static final double[] offMaxX = new double[2];
    private static final double[] offMaxZ = new double[2];

    public BlockFenceGate() {
        this(0);
    }

    public BlockFenceGate(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 107;
    }

    @Override
    public String getName() {
        return "Oak Fence Gate";
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    private int getOffsetIndex() {
        switch (this.getDamage() & 3) {
            case 0: 
            case 2: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public double getMinX() {
        return this.x + offMinX[this.getOffsetIndex()];
    }

    @Override
    public double getMinZ() {
        return this.z + offMinZ[this.getOffsetIndex()];
    }

    @Override
    public double getMaxX() {
        return this.x + offMaxX[this.getOffsetIndex()];
    }

    @Override
    public double getMaxZ() {
        return this.z + offMaxZ[this.getOffsetIndex()];
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(player != null ? player.getDirection().getHorizontalIndex() : 0);
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player == null) {
            return false;
        }
        if (!this.toggle(player)) {
            return false;
        }
        this.level.addSound(this, this.isOpen() ? Sound.RANDOM_DOOR_OPEN : Sound.RANDOM_DOOR_CLOSE);
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    public boolean toggle(Player player) {
        int direction;
        DoorToggleEvent event = new DoorToggleEvent(this, player);
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        player = event.getPlayer();
        if (player != null) {
            int originDirection;
            double yaw = player.yaw;
            double rotation = (yaw - 90.0) % 360.0;
            if (rotation < 0.0) {
                rotation += 360.0;
            }
            direction = (originDirection = this.getDamage() & 1) == 0 ? (rotation >= 0.0 && rotation < 180.0 ? 2 : 0) : (rotation >= 90.0 && rotation < 270.0 ? 3 : 1);
        } else {
            int originDirection = this.getDamage() & 1;
            direction = originDirection == 0 ? 0 : 1;
        }
        this.setDamage(direction | ~this.getDamage() & 4);
        this.level.setBlock((Vector3)this, this, false, false);
        return true;
    }

    public boolean isOpen() {
        return (this.getDamage() & 4) > 0;
    }

    @Override
    public int onUpdate(int type) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        if (type == 6 && (!this.isOpen() && this.level.isBlockPowered(this.getLocation()) || this.isOpen() && !this.level.isBlockPowered(this.getLocation()))) {
            this.toggle(null);
            return type;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return Item.get(107, 0, 1);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    static {
        BlockFenceGate.offMinX[0] = 0.0;
        BlockFenceGate.offMinZ[0] = 0.375;
        BlockFenceGate.offMaxX[0] = 1.0;
        BlockFenceGate.offMaxZ[0] = 0.625;
        BlockFenceGate.offMinX[1] = 0.375;
        BlockFenceGate.offMinZ[1] = 0.0;
        BlockFenceGate.offMaxX[1] = 0.625;
        BlockFenceGate.offMaxZ[1] = 1.0;
    }
}

