/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.block.BlockAir;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.inventory.DropperInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;

public class BlockEntityDropper
extends BlockEntitySpawnable
implements BlockEntityContainer,
InventoryHolder,
BlockEntityNameable {
    protected DropperInventory inventory;

    public BlockEntityDropper(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.inventory = new DropperInventory(this);
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        for (int i = 0; i < this.getSize(); ++i) {
            this.inventory.setItem(i, this.getItem(i));
        }
        super.initBlockEntity();
    }

    @Override
    public int getSize() {
        return 9;
    }

    protected int getSlotIndex(int index) {
        ListTag<CompoundTag> list = this.namedTag.getList("Items", CompoundTag.class);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getByte("Slot") != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item getItem(int index) {
        int i = this.getSlotIndex(index);
        if (i < 0) {
            return new ItemBlock(new BlockAir(), (Integer)0, 0);
        }
        CompoundTag data = (CompoundTag)this.namedTag.getList("Items").get(i);
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        int i = this.getSlotIndex(index);
        CompoundTag d = NBTIO.putItemHelper(item, index);
        if (item.getId() == 0 || item.getCount() <= 0) {
            if (i >= 0) {
                this.namedTag.getList("Items").getAll().remove(i);
            }
        } else if (i < 0) {
            this.namedTag.getList("Items", CompoundTag.class).add(d);
        } else {
            this.namedTag.getList("Items", CompoundTag.class).add(i, d);
        }
    }

    @Override
    public DropperInventory getInventory() {
        return this.inventory;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", "Dropper").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (this.hasName()) {
            c.put("CustomName", this.namedTag.get("CustomName"));
        }
        return c;
    }

    @Override
    public void saveNBT() {
        this.namedTag.putList(new ListTag("Items"));
        for (int index = 0; index < this.getSize(); ++index) {
            this.setItem(index, this.inventory.getItem(index));
        }
        super.saveNBT();
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getLevelBlock().getId() == 125;
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Dropper";
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }

    @Override
    public void onBreak() {
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
    }
}

