/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDispenser;
import cn.nukkit.block.BlockShulkerBox;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;

public class ShulkerBoxDispenseBehavior
extends DefaultDispenseBehavior {
    @Override
    public Item dispense(BlockDispenser block, BlockFace face, Item item) {
        BlockShulkerBox shulkerBox = new BlockShulkerBox();
        Block target = block.getSide(face);
        boolean bl = this.success = block.level.getCollidingEntities(shulkerBox.getBoundingBox()).length == 0;
        if (this.success) {
            CompoundTag tag;
            BlockFace shulkerBoxFace = target.down().getId() == 0 ? face : BlockFace.UP;
            CompoundTag nbt = BlockEntity.getDefaultCompound(target, "ShulkerBox");
            nbt.putByte("facing", shulkerBoxFace.getIndex());
            if (item.hasCustomName()) {
                nbt.putString("CustomName", item.getCustomName());
            }
            if ((tag = item.getNamedTag()) != null && tag.contains("Items")) {
                nbt.putList(tag.getList("Items"));
            }
            BlockEntity.createBlockEntity("ShulkerBox", (Position)target, nbt, new Object[0]);
            block.level.updateComparatorOutputLevel(target);
        }
        return null;
    }
}

