/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.inventory;

import cn.nukkit.blockentity.BlockEntityBrewingStand;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.inventory.InventoryEvent;
import cn.nukkit.item.Item;

public class StartBrewEvent
extends InventoryEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final BlockEntityBrewingStand brewingStand;
    private final Item ingredient;
    private final Item[] potions;

    public static HandlerList getHandlers() {
        return handlers;
    }

    public StartBrewEvent(BlockEntityBrewingStand blockEntity) {
        super(blockEntity.getInventory());
        this.brewingStand = blockEntity;
        this.ingredient = blockEntity.getInventory().getIngredient();
        this.potions = new Item[3];
        for (int i = 0; i < 3; ++i) {
            this.potions[i] = blockEntity.getInventory().getItem(i);
        }
    }

    public BlockEntityBrewingStand getBrewingStand() {
        return this.brewingStand;
    }

    public Item getIngredient() {
        return this.ingredient;
    }

    public Item[] getPotions() {
        return this.potions;
    }

    public Item getPotion(int index) {
        return this.potions[index];
    }
}

