/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.noise.nukkit.f.SimplexF;
import cn.nukkit.level.generator.object.ore.OreType;
import cn.nukkit.level.generator.populator.impl.PopulatorGlowStone;
import cn.nukkit.level.generator.populator.impl.PopulatorGroundFire;
import cn.nukkit.level.generator.populator.impl.PopulatorLava;
import cn.nukkit.level.generator.populator.impl.PopulatorOre;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Nether
extends Generator {
    private ChunkManager level;
    private NukkitRandom nukkitRandom;
    private Random random;
    private double lavaHeight = 32.0;
    private double bedrockDepth = 5.0;
    private SimplexF[] noiseGen = new SimplexF[3];
    private final List<Populator> populators = new ArrayList<Populator>();
    private List<Populator> generationPopulators = new ArrayList<Populator>();
    private long localSeed1;
    private long localSeed2;

    public Nether() {
        this(new HashMap<String, Object>());
    }

    public Nether(Map<String, Object> options) {
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public String getName() {
        return "nether";
    }

    @Override
    public Map<String, Object> getSettings() {
        return new HashMap<String, Object>();
    }

    @Override
    public ChunkManager getChunkManager() {
        return this.level;
    }

    @Override
    public void init(ChunkManager level, NukkitRandom random) {
        this.level = level;
        this.nukkitRandom = random;
        this.random = new Random();
        this.nukkitRandom.setSeed(this.level.getSeed());
        for (int i = 0; i < this.noiseGen.length; ++i) {
            this.noiseGen[i] = new SimplexF(this.nukkitRandom, 4.0f, 0.25f, 0.015625f);
        }
        this.nukkitRandom.setSeed(this.level.getSeed());
        this.localSeed1 = this.random.nextLong();
        this.localSeed2 = this.random.nextLong();
        PopulatorOre ores = new PopulatorOre(87, new OreType[]{new OreType(Block.get(153), 20, 16, 0, 128), new OreType(Block.get(88), 5, 64, 0, 128), new OreType(Block.get(13), 5, 64, 0, 128), new OreType(Block.get(10), 1, 16, 0, (int)this.lavaHeight)});
        this.populators.add(ores);
        PopulatorGroundFire groundFire = new PopulatorGroundFire();
        groundFire.setBaseAmount(1);
        groundFire.setRandomAmount(1);
        this.populators.add(groundFire);
        PopulatorLava lava = new PopulatorLava();
        lava.setBaseAmount(1);
        lava.setRandomAmount(2);
        this.populators.add(lava);
        this.populators.add(new PopulatorGlowStone());
        PopulatorOre ore = new PopulatorOre(87, new OreType[]{new OreType(Block.get(153), 40, 16, 0, 128, 87), new OreType(Block.get(88), 1, 64, 30, 35, 87), new OreType(Block.get(10), 32, 1, 0, 32, 87), new OreType(Block.get(213), 32, 16, 26, 37, 87)});
        this.populators.add(ore);
    }

    @Override
    public void generateChunk(int chunkX, int chunkZ) {
        int baseX = chunkX << 4;
        int baseZ = chunkZ << 4;
        this.nukkitRandom.setSeed((long)chunkX * this.localSeed1 ^ (long)chunkZ * this.localSeed2 ^ this.level.getSeed());
        BaseFullChunk chunk = this.level.getChunk(chunkX, chunkZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                Biome biome = EnumBiome.HELL.biome;
                chunk.setBiomeId(x, z, biome.getId());
                chunk.setBlockId(x, 0, z, 7);
                for (y = 115; y < 127; ++y) {
                    chunk.setBlockId(x, y, z, 87);
                }
                chunk.setBlockId(x, 127, z, 7);
                for (y = 1; y < 127; ++y) {
                    if (this.getNoise(baseX | x, y, baseZ | z) > 0.0f) {
                        chunk.setBlockId(x, y, z, 87);
                        continue;
                    }
                    if (!((double)y <= this.lavaHeight)) continue;
                    chunk.setBlockId(x, y, z, 11);
                    chunk.setBlockLight(x, y + 1, z, 15);
                }
            }
        }
        for (Populator populator : this.generationPopulators) {
            populator.populate(this.level, chunkX, chunkZ, this.nukkitRandom, chunk);
        }
    }

    @Override
    public void populateChunk(int chunkX, int chunkZ) {
        BaseFullChunk chunk = this.level.getChunk(chunkX, chunkZ);
        this.nukkitRandom.setSeed((long)(0xDEADBEEF ^ chunkX << 8 ^ chunkZ) ^ this.level.getSeed());
        for (Populator populator : this.populators) {
            populator.populate(this.level, chunkX, chunkZ, this.nukkitRandom, chunk);
        }
        Biome biome = EnumBiome.getBiome(chunk.getBiomeId(7, 7));
        biome.populateChunk(this.level, chunkX, chunkZ, this.nukkitRandom);
    }

    @Override
    public Vector3 getSpawn() {
        return new Vector3(0.0, 64.0, 0.0);
    }

    public float getNoise(int x, int y, int z) {
        float val = 0.0f;
        for (int i = 0; i < this.noiseGen.length; ++i) {
            val += this.noiseGen[i].noise3D(x >> i, y, z >> i, true);
        }
        return val;
    }
}

