/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.plugin;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.inventory.InventoryOpenEvent;
import cn.nukkit.event.server.DataPacketReceiveEvent;
import cn.nukkit.event.server.DataPacketSendEvent;
import cn.nukkit.inventory.PlayerEnderChestInventory;
import cn.nukkit.plugin.PluginBase;
import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.UUID;

@PowerNukkitOnly
@Since(value="1.3.0.0-PN")
public class PowerNukkitPlugin
extends PluginBase {
    private static final PowerNukkitPlugin INSTANCE = new PowerNukkitPlugin();

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public static PowerNukkitPlugin getInstance() {
        return INSTANCE;
    }

    @Override
    public void onEnable() {
        this.getServer().getPluginManager().registerEvents(new HotFixes(), this);
    }

    private class HotFixes
    implements Listener {
        private final Map<UUID, Boolean> cancelNextSend = new MapMaker().weakKeys().makeMap();

        private HotFixes() {
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
        public void onFixCrash(DataPacketSendEvent e) {
            if (e.getPacket().pid() == 47 && this.cancelNextSend.getOrDefault(e.getPlayer().getUniqueId(), true).booleanValue()) {
                e.setCancelled();
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
        public void onDataPacketReceive(DataPacketReceiveEvent e) {
            if (e.getPacket().pid() == 47) {
                this.cancelNextSend.put(e.getPlayer().getUniqueId(), false);
                e.getPlayer().dataPacket(e.getPacket());
                this.cancelNextSend.put(e.getPlayer().getUniqueId(), true);
            }
        }

        @EventHandler
        public void onOpenEC(InventoryOpenEvent e) {
            if (!e.isCancelled() && e.getInventory() instanceof PlayerEnderChestInventory) {
                Player p = e.getPlayer();
                Server.getInstance().getScheduler().scheduleDelayedTask(PowerNukkitPlugin.this, () -> {
                    if (p != null && p.isOnline() && p.getTopWindow().isPresent() && p.getTopWindow().get() instanceof PlayerEnderChestInventory) {
                        PlayerEnderChestInventory ec = (PlayerEnderChestInventory)p.getTopWindow().get();
                        ec.sendContents(p);
                    }
                }, 3);
            }
        }
    }
}

