/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemDurable;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.GameRules;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3f;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.types.EntityLink;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.PersonaPiece;
import cn.nukkit.utils.PersonaPieceTint;
import cn.nukkit.utils.SerializedImage;
import cn.nukkit.utils.SkinAnimation;
import cn.nukkit.utils.VarInt;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class BinaryStream {
    public int offset;
    private byte[] buffer;
    private int count;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public BinaryStream() {
        this.buffer = new byte[32];
        this.offset = 0;
        this.count = 0;
    }

    public BinaryStream(byte[] buffer) {
        this(buffer, 0);
    }

    public BinaryStream(byte[] buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.count = buffer.length;
    }

    public BinaryStream reset() {
        this.offset = 0;
        this.count = 0;
        return this;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.count = buffer == null ? -1 : buffer.length;
    }

    public void setBuffer(byte[] buffer, int offset) {
        this.setBuffer(buffer);
        this.setOffset(offset);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getBuffer() {
        return Arrays.copyOf(this.buffer, this.count);
    }

    public int getCount() {
        return this.count;
    }

    public byte[] get() {
        return this.get(this.count - this.offset);
    }

    public byte[] get(int len) {
        if (len < 0) {
            this.offset = this.count - 1;
            return new byte[0];
        }
        len = Math.min(len, this.getCount() - this.offset);
        this.offset += len;
        return Arrays.copyOfRange(this.buffer, this.offset - len, this.offset);
    }

    public void put(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        this.ensureCapacity(this.count + bytes.length);
        System.arraycopy(bytes, 0, this.buffer, this.count, bytes.length);
        this.count += bytes.length;
    }

    public long getLong() {
        return Binary.readLong(this.get(8));
    }

    public void putLong(long l) {
        this.put(Binary.writeLong(l));
    }

    public int getInt() {
        return Binary.readInt(this.get(4));
    }

    public void putInt(int i) {
        this.put(Binary.writeInt(i));
    }

    public long getLLong() {
        return Binary.readLLong(this.get(8));
    }

    public void putLLong(long l) {
        this.put(Binary.writeLLong(l));
    }

    public int getLInt() {
        return Binary.readLInt(this.get(4));
    }

    public void putLInt(int i) {
        this.put(Binary.writeLInt(i));
    }

    public int getShort() {
        return Binary.readShort(this.get(2));
    }

    public void putShort(int s) {
        this.put(Binary.writeShort(s));
    }

    public int getLShort() {
        return Binary.readLShort(this.get(2));
    }

    public void putLShort(int s) {
        this.put(Binary.writeLShort(s));
    }

    public float getFloat() {
        return this.getFloat(-1);
    }

    public float getFloat(int accuracy) {
        return Binary.readFloat(this.get(4), accuracy);
    }

    public void putFloat(float v) {
        this.put(Binary.writeFloat(v));
    }

    public float getLFloat() {
        return this.getLFloat(-1);
    }

    public float getLFloat(int accuracy) {
        return Binary.readLFloat(this.get(4), accuracy);
    }

    public void putLFloat(float v) {
        this.put(Binary.writeLFloat(v));
    }

    public int getTriad() {
        return Binary.readTriad(this.get(3));
    }

    public void putTriad(int triad) {
        this.put(Binary.writeTriad(triad));
    }

    public int getLTriad() {
        return Binary.readLTriad(this.get(3));
    }

    public void putLTriad(int triad) {
        this.put(Binary.writeLTriad(triad));
    }

    public boolean getBoolean() {
        return this.getByte() == 1;
    }

    public void putBoolean(boolean bool) {
        this.putByte((byte)(bool ? 1 : 0));
    }

    public int getByte() {
        return this.buffer[this.offset++] & 0xFF;
    }

    public void putByte(byte b) {
        this.put(new byte[]{b});
    }

    public Attribute[] getAttributeList() throws Exception {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        long count = this.getUnsignedVarInt();
        int i = 0;
        while ((long)i < count) {
            String name = this.getString();
            Attribute attr = Attribute.getAttributeByName(name);
            if (attr == null) {
                throw new Exception("Unknown attribute type \"" + name + "\"");
            }
            attr.setMinValue(this.getLFloat());
            attr.setValue(this.getLFloat());
            attr.setMaxValue(this.getLFloat());
            list.add(attr);
            ++i;
        }
        return list.toArray(new Attribute[0]);
    }

    public void putAttributeList(Attribute[] attributes) {
        this.putUnsignedVarInt(attributes.length);
        for (Attribute attribute : attributes) {
            this.putString(attribute.getName());
            this.putLFloat(attribute.getMinValue());
            this.putLFloat(attribute.getValue());
            this.putLFloat(attribute.getMaxValue());
        }
    }

    public void putUUID(UUID uuid) {
        this.put(Binary.writeUUID(uuid));
    }

    public UUID getUUID() {
        return Binary.readUUID(this.get(16));
    }

    public void putSkin(Skin skin) {
        this.putString(skin.getSkinId());
        this.putString(skin.getSkinResourcePatch());
        this.putImage(skin.getSkinData());
        List<SkinAnimation> animations = skin.getAnimations();
        this.putLInt(animations.size());
        for (SkinAnimation skinAnimation : animations) {
            this.putImage(skinAnimation.image);
            this.putLInt(skinAnimation.type);
            this.putLFloat(skinAnimation.frames);
        }
        this.putImage(skin.getCapeData());
        this.putString(skin.getGeometryData());
        this.putString(skin.getAnimationData());
        this.putBoolean(skin.isPremium());
        this.putBoolean(skin.isPersona());
        this.putBoolean(skin.isCapeOnClassic());
        this.putString(skin.getCapeId());
        this.putString(skin.getFullSkinId());
        this.putString(skin.getArmSize());
        this.putString(skin.getSkinColor());
        List<PersonaPiece> pieces = skin.getPersonaPieces();
        this.putLInt(pieces.size());
        for (PersonaPiece piece : pieces) {
            this.putString(piece.id);
            this.putString(piece.type);
            this.putString(piece.packId);
            this.putBoolean(piece.isDefault);
            this.putString(piece.productId);
        }
        List<PersonaPieceTint> list = skin.getTintColors();
        this.putLInt(list.size());
        for (PersonaPieceTint tint : list) {
            this.putString(tint.pieceType);
            ImmutableList<String> colors = tint.colors;
            this.putLInt(colors.size());
            for (String color : colors) {
                this.putString(color);
            }
        }
    }

    public Skin getSkin() {
        Skin skin = new Skin();
        skin.setSkinId(this.getString());
        skin.setSkinResourcePatch(this.getString());
        skin.setSkinData(this.getImage());
        int animationCount = this.getLInt();
        for (int i = 0; i < animationCount; ++i) {
            SerializedImage image = this.getImage();
            int type = this.getLInt();
            float frames = this.getLFloat();
            skin.getAnimations().add(new SkinAnimation(image, type, frames));
        }
        skin.setCapeData(this.getImage());
        skin.setGeometryData(this.getString());
        skin.setAnimationData(this.getString());
        skin.setPremium(this.getBoolean());
        skin.setPersona(this.getBoolean());
        skin.setCapeOnClassic(this.getBoolean());
        skin.setCapeId(this.getString());
        this.getString();
        skin.setArmSize(this.getString());
        skin.setSkinColor(this.getString());
        int piecesLength = this.getLInt();
        for (int i = 0; i < piecesLength; ++i) {
            String pieceId = this.getString();
            String pieceType = this.getString();
            String packId = this.getString();
            boolean isDefault = this.getBoolean();
            String productId = this.getString();
            skin.getPersonaPieces().add(new PersonaPiece(pieceId, pieceType, packId, isDefault, productId));
        }
        int tintsLength = this.getLInt();
        for (int i = 0; i < tintsLength; ++i) {
            String pieceType = this.getString();
            ArrayList<String> colors = new ArrayList<String>();
            int colorsLength = this.getLInt();
            for (int i2 = 0; i2 < colorsLength; ++i2) {
                colors.add(this.getString());
            }
            skin.getTintColors().add(new PersonaPieceTint(pieceType, colors));
        }
        return skin;
    }

    public void putImage(SerializedImage image) {
        this.putLInt(image.width);
        this.putLInt(image.height);
        this.putByteArray(image.data);
    }

    public SerializedImage getImage() {
        int width = this.getLInt();
        int height = this.getLInt();
        byte[] data = this.getByteArray();
        return new SerializedImage(width, height, data);
    }

    public Item getSlot() {
        int id = this.getVarInt();
        if (id == 0) {
            return Item.get(0, 0, 0);
        }
        int auxValue = this.getVarInt();
        int data = auxValue >> 8;
        if (data == Short.MAX_VALUE) {
            data = -1;
        }
        int cnt = auxValue & 0xFF;
        int nbtLen = this.getLShort();
        byte[] nbt = new byte[]{};
        if (nbtLen < Short.MAX_VALUE) {
            nbt = this.get(nbtLen);
        } else if (nbtLen == 65535) {
            int nbtTagCount = (int)this.getUnsignedVarInt();
            int offset = this.getOffset();
            FastByteArrayInputStream stream = new FastByteArrayInputStream(this.get());
            for (int i = 0; i < nbtTagCount; ++i) {
                try {
                    CompoundTag tag = NBTIO.read((InputStream)stream, ByteOrder.LITTLE_ENDIAN, true);
                    if (tag.contains("Damage")) {
                        data = tag.getInt("Damage");
                        tag.remove("Damage");
                    }
                    if (tag.contains("__DamageConflict__")) {
                        tag.put("Damage", (Tag)tag.removeAndGet("__DamageConflict__"));
                    }
                    if (tag.getAllTags().size() <= 0) continue;
                    nbt = NBTIO.write(tag, ByteOrder.LITTLE_ENDIAN, false);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setOffset(offset + (int)stream.position());
        }
        String[] canPlaceOn = new String[this.getVarInt()];
        for (int i = 0; i < canPlaceOn.length; ++i) {
            canPlaceOn[i] = this.getString();
        }
        String[] canDestroy = new String[this.getVarInt()];
        for (int i = 0; i < canDestroy.length; ++i) {
            canDestroy[i] = this.getString();
        }
        Item item = Item.get(id, data, cnt, nbt);
        if (canDestroy.length > 0 || canPlaceOn.length > 0) {
            ListTag<StringTag> listTag;
            CompoundTag namedTag = item.getNamedTag();
            if (namedTag == null) {
                namedTag = new CompoundTag();
            }
            if (canDestroy.length > 0) {
                listTag = new ListTag<StringTag>("CanDestroy");
                for (String blockName : canDestroy) {
                    listTag.add(new StringTag("", blockName));
                }
                namedTag.put("CanDestroy", listTag);
            }
            if (canPlaceOn.length > 0) {
                listTag = new ListTag("CanPlaceOn");
                for (String blockName : canPlaceOn) {
                    listTag.add(new StringTag("", blockName));
                }
                namedTag.put("CanPlaceOn", listTag);
            }
            item.setNamedTag(namedTag);
        }
        if (item.getId() == 513) {
            this.getVarLong();
        }
        return item;
    }

    public void putSlot(Item item) {
        if (item == null || item.getId() == 0) {
            this.putVarInt(0);
            return;
        }
        boolean isDurable = item instanceof ItemDurable;
        this.putVarInt(item.getId());
        int auxValue = item.getCount();
        if (!isDurable) {
            auxValue |= ((item.hasMeta() ? item.getDamage() : -1) & Short.MAX_VALUE) << 8;
        }
        this.putVarInt(auxValue);
        if (item.hasCompoundTag() || isDurable) {
            try {
                byte[] nbt = item.getCompoundTag();
                CompoundTag tag = nbt == null || nbt.length == 0 ? new CompoundTag() : NBTIO.read(nbt, ByteOrder.LITTLE_ENDIAN, false);
                if (tag.contains("Damage")) {
                    tag.put("__DamageConflict__", (Tag)tag.removeAndGet("Damage"));
                }
                if (isDurable) {
                    tag.putInt("Damage", item.getDamage());
                }
                this.putLShort(65535);
                this.putByte((byte)1);
                this.put(NBTIO.write(tag, ByteOrder.LITTLE_ENDIAN, true));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.putLShort(0);
        }
        List<String> canPlaceOn = this.extractStringList(item, "CanPlaceOn");
        List<String> canDestroy = this.extractStringList(item, "CanDestroy");
        this.putVarInt(canPlaceOn.size());
        for (String block : canPlaceOn) {
            this.putString(block);
        }
        this.putVarInt(canDestroy.size());
        for (String block : canDestroy) {
            this.putString(block);
        }
        if (item.getId() == 513) {
            this.putVarLong(0L);
        }
    }

    public Item getRecipeIngredient() {
        int id = this.getVarInt();
        if (id == 0) {
            return Item.get(0, 0, 0);
        }
        int damage = this.getVarInt();
        if (damage == Short.MAX_VALUE) {
            damage = -1;
        }
        int count = this.getVarInt();
        return Item.get(id, damage, count);
    }

    public void putRecipeIngredient(Item ingredient) {
        if (ingredient == null || ingredient.getId() == 0) {
            this.putVarInt(0);
            return;
        }
        this.putVarInt(ingredient.getId());
        int damage = ingredient.hasMeta() ? ingredient.getDamage() : Short.MAX_VALUE;
        this.putVarInt(damage);
        this.putVarInt(ingredient.getCount());
    }

    private List<String> extractStringList(Item item, String tagName) {
        CompoundTag namedTag = item.getNamedTag();
        if (namedTag == null) {
            return Collections.emptyList();
        }
        ListTag<StringTag> listTag = namedTag.getList(tagName, StringTag.class);
        if (listTag == null) {
            return Collections.emptyList();
        }
        int size = listTag.size();
        ArrayList<String> values = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            StringTag stringTag = listTag.get(i);
            if (stringTag == null) continue;
            values.add(stringTag.data);
        }
        return values;
    }

    public byte[] getByteArray() {
        return this.get((int)this.getUnsignedVarInt());
    }

    public void putByteArray(byte[] b) {
        this.putUnsignedVarInt(b.length);
        this.put(b);
    }

    public String getString() {
        return new String(this.getByteArray(), StandardCharsets.UTF_8);
    }

    public void putString(String string) {
        byte[] b = string.getBytes(StandardCharsets.UTF_8);
        this.putByteArray(b);
    }

    public long getUnsignedVarInt() {
        return VarInt.readUnsignedVarInt(this);
    }

    public void putUnsignedVarInt(long v) {
        VarInt.writeUnsignedVarInt(this, v);
    }

    public int getVarInt() {
        return VarInt.readVarInt(this);
    }

    public void putVarInt(int v) {
        VarInt.writeVarInt(this, v);
    }

    public long getVarLong() {
        return VarInt.readVarLong(this);
    }

    public void putVarLong(long v) {
        VarInt.writeVarLong(this, v);
    }

    public long getUnsignedVarLong() {
        return VarInt.readUnsignedVarLong(this);
    }

    public void putUnsignedVarLong(long v) {
        VarInt.writeUnsignedVarLong(this, v);
    }

    public BlockVector3 getBlockVector3() {
        return new BlockVector3(this.getVarInt(), (int)this.getUnsignedVarInt(), this.getVarInt());
    }

    public BlockVector3 getSignedBlockPosition() {
        return new BlockVector3(this.getVarInt(), this.getVarInt(), this.getVarInt());
    }

    public void putSignedBlockPosition(BlockVector3 v) {
        this.putVarInt(v.x);
        this.putVarInt(v.y);
        this.putVarInt(v.z);
    }

    public void putBlockVector3(BlockVector3 v) {
        this.putBlockVector3(v.x, v.y, v.z);
    }

    public void putBlockVector3(int x, int y, int z) {
        this.putVarInt(x);
        this.putUnsignedVarInt(y);
        this.putVarInt(z);
    }

    public Vector3f getVector3f() {
        return new Vector3f(this.getLFloat(4), this.getLFloat(4), this.getLFloat(4));
    }

    public void putVector3f(Vector3f v) {
        this.putVector3f(v.x, v.y, v.z);
    }

    public void putVector3f(float x, float y, float z) {
        this.putLFloat(x);
        this.putLFloat(y);
        this.putLFloat(z);
    }

    public void putGameRules(GameRules gameRules) {
        Map<GameRule, GameRules.Value> rules = gameRules.getGameRules();
        this.putUnsignedVarInt(rules.size());
        rules.forEach((gameRule, value) -> {
            this.putString(gameRule.getName().toLowerCase());
            value.write(this);
        });
    }

    public long getEntityUniqueId() {
        return this.getVarLong();
    }

    public void putEntityUniqueId(long eid) {
        this.putVarLong(eid);
    }

    public long getEntityRuntimeId() {
        return this.getUnsignedVarLong();
    }

    public void putEntityRuntimeId(long eid) {
        this.putUnsignedVarLong(eid);
    }

    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getVarInt());
    }

    public void putBlockFace(BlockFace face) {
        this.putVarInt(face.getIndex());
    }

    public void putEntityLink(EntityLink link) {
        this.putEntityUniqueId(link.fromEntityUniquieId);
        this.putEntityUniqueId(link.toEntityUniquieId);
        this.putByte(link.type);
        this.putBoolean(link.immediate);
        this.putBoolean(link.riderInitiated);
    }

    public EntityLink getEntityLink() {
        return new EntityLink(this.getEntityUniqueId(), this.getEntityUniqueId(), (byte)this.getByte(), this.getBoolean(), this.getBoolean());
    }

    public <T> T[] getArray(Class<T> clazz, Function<BinaryStream, T> function) {
        ArrayDeque<T> deque = new ArrayDeque<T>();
        int count = (int)this.getUnsignedVarInt();
        for (int i = 0; i < count; ++i) {
            deque.add(function.apply(this));
        }
        return deque.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public boolean feof() {
        return this.offset < 0 || this.offset >= this.buffer.length;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buffer.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = BinaryStream.hugeCapacity(minCapacity);
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }
}

