/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockVine
extends BlockTransparentMeta {
    public BlockVine(int meta) {
        super(meta);
    }

    public BlockVine() {
        this(0);
    }

    @Override
    public String getName() {
        return "Vines";
    }

    @Override
    public int getId() {
        return 106;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public double getResistance() {
        return 1.0;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public boolean canBeClimbed() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.resetFallDistance();
        entity.onGround = true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        boolean flag;
        double f1 = 1.0;
        double f2 = 1.0;
        double f3 = 1.0;
        double f4 = 0.0;
        double f5 = 0.0;
        double f6 = 0.0;
        boolean bl = flag = this.getDamage() > 0;
        if ((this.getDamage() & 2) > 0) {
            f4 = Math.max(f4, 0.0625);
            f1 = 0.0;
            f2 = 0.0;
            f5 = 1.0;
            f3 = 0.0;
            f6 = 1.0;
            flag = true;
        }
        if ((this.getDamage() & 8) > 0) {
            f1 = Math.min(f1, 0.9375);
            f4 = 1.0;
            f2 = 0.0;
            f5 = 1.0;
            f3 = 0.0;
            f6 = 1.0;
            flag = true;
        }
        if ((this.getDamage() & 1) > 0) {
            f3 = Math.min(f3, 0.9375);
            f6 = 1.0;
            f1 = 0.0;
            f4 = 1.0;
            f2 = 0.0;
            f5 = 1.0;
            flag = true;
        }
        if (!flag && this.up().isSolid()) {
            f2 = Math.min(f2, 0.9375);
            f5 = 1.0;
            f1 = 0.0;
            f4 = 1.0;
            f3 = 0.0;
            f6 = 1.0;
        }
        return new SimpleAxisAlignedBB(this.x + f1, this.y + f2, this.z + f3, this.x + f4, this.y + f5, this.z + f6);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.isSolid() && face.getHorizontalIndex() != -1) {
            this.setDamage(this.getMetaFromFace(face.getOpposite()));
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public int onUpdate(int type) {
        Block up;
        if (!(type != 1 || this.getSide(this.getFace()).isSolid() || (up = this.up()).getId() == this.getId() && up.getDamage() == this.getDamage())) {
            this.getLevel().useBreakOn(this, null, null, true);
            return 1;
        }
        return 0;
    }

    private BlockFace getFace() {
        int meta = this.getDamage();
        if ((meta & 1) > 0) {
            return BlockFace.SOUTH;
        }
        if ((meta & 2) > 0) {
            return BlockFace.WEST;
        }
        if ((meta & 4) > 0) {
            return BlockFace.NORTH;
        }
        if ((meta & 8) > 0) {
            return BlockFace.EAST;
        }
        return BlockFace.SOUTH;
    }

    private int getMetaFromFace(BlockFace face) {
        switch (face) {
            default: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case NORTH: {
                return 4;
            }
            case EAST: 
        }
        return 8;
    }

    @Override
    public int getToolType() {
        return 5;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

