/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.item.Item;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.AngryVillagerParticle;
import cn.nukkit.level.particle.BlockForceFieldParticle;
import cn.nukkit.level.particle.BubbleParticle;
import cn.nukkit.level.particle.CriticalParticle;
import cn.nukkit.level.particle.DustParticle;
import cn.nukkit.level.particle.EnchantParticle;
import cn.nukkit.level.particle.EnchantmentTableParticle;
import cn.nukkit.level.particle.ExplodeParticle;
import cn.nukkit.level.particle.FlameParticle;
import cn.nukkit.level.particle.HappyVillagerParticle;
import cn.nukkit.level.particle.HeartParticle;
import cn.nukkit.level.particle.HugeExplodeParticle;
import cn.nukkit.level.particle.HugeExplodeSeedParticle;
import cn.nukkit.level.particle.InkParticle;
import cn.nukkit.level.particle.InstantEnchantParticle;
import cn.nukkit.level.particle.ItemBreakParticle;
import cn.nukkit.level.particle.LavaDripParticle;
import cn.nukkit.level.particle.LavaParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.level.particle.PortalParticle;
import cn.nukkit.level.particle.RainSplashParticle;
import cn.nukkit.level.particle.RedstoneParticle;
import cn.nukkit.level.particle.SmokeParticle;
import cn.nukkit.level.particle.SplashParticle;
import cn.nukkit.level.particle.SporeParticle;
import cn.nukkit.level.particle.TerrainParticle;
import cn.nukkit.level.particle.WaterDripParticle;
import cn.nukkit.level.particle.WaterParticle;
import cn.nukkit.math.Vector3;
import java.util.Random;

public class ParticleCommand
extends VanillaCommand {
    private static final String[] ENUM_VALUES = new String[]{"explode", "hugeexplosion", "hugeexplosionseed", "bubble", "splash", "wake", "water", "crit", "smoke", "spell", "instantspell", "dripwater", "driplava", "townaura", "spore", "portal", "flame", "lava", "reddust", "snowballpoof", "slime", "itembreak", "terrain", "heart", "ink", "droplet", "enchantmenttable", "happyvillager", "angryvillager", "forcefield"};

    public ParticleCommand(String name) {
        super(name, "%nukkit.command.particle.description", "%nukkit.command.particle.usage");
        this.setPermission("nukkit.command.particle");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{new CommandParameter("name", false, ENUM_VALUES), new CommandParameter("position", CommandParamType.POSITION, false), new CommandParameter("count", CommandParamType.INT, true), new CommandParameter("data", true)});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        Particle particle;
        double z;
        double y;
        double x;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 4) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        Position defaultPosition = sender instanceof Player ? ((Player)sender).getPosition() : new Position(0.0, 0.0, 0.0, sender.getServer().getDefaultLevel());
        String name = args[0].toLowerCase();
        try {
            x = this.parseTilde(args[1], defaultPosition.getX());
            y = this.parseTilde(args[2], defaultPosition.getY());
            z = this.parseTilde(args[3], defaultPosition.getZ());
        }
        catch (Exception e) {
            return false;
        }
        Position position = new Position(x, y, z, defaultPosition.getLevel());
        int count = 1;
        if (args.length > 4) {
            try {
                double c = Double.valueOf(args[4]);
                count = (int)c;
            }
            catch (Exception c) {
                // empty catch block
            }
        }
        count = Math.max(1, count);
        int data = -1;
        if (args.length > 5) {
            try {
                double d = Double.valueOf(args[5]);
                data = (int)d;
            }
            catch (Exception d) {
                // empty catch block
            }
        }
        if ((particle = this.getParticle(name, position, data)) == null) {
            position.level.addParticleEffect(position.asVector3f(), args[0], -1L, position.level.getDimension(), new Player[0]);
            return true;
        }
        sender.sendMessage(new TranslationContainer("commands.particle.success", name, String.valueOf(count)));
        Random random = new Random(System.currentTimeMillis());
        for (int i = 0; i < count; ++i) {
            particle.setComponents(position.x + (double)(random.nextFloat() * 2.0f - 1.0f), position.y + (double)(random.nextFloat() * 2.0f - 1.0f), position.z + (double)(random.nextFloat() * 2.0f - 1.0f));
            position.getLevel().addParticle(particle);
        }
        return true;
    }

    private Particle getParticle(String name, Vector3 pos, int data) {
        String[] d;
        switch (name) {
            case "explode": {
                return new ExplodeParticle(pos);
            }
            case "hugeexplosion": {
                return new HugeExplodeParticle(pos);
            }
            case "hugeexplosionseed": {
                return new HugeExplodeSeedParticle(pos);
            }
            case "bubble": {
                return new BubbleParticle(pos);
            }
            case "splash": {
                return new SplashParticle(pos);
            }
            case "wake": 
            case "water": {
                return new WaterParticle(pos);
            }
            case "crit": {
                return new CriticalParticle(pos);
            }
            case "smoke": {
                return new SmokeParticle(pos, data != -1 ? data : 0);
            }
            case "spell": {
                return new EnchantParticle(pos);
            }
            case "instantspell": {
                return new InstantEnchantParticle(pos);
            }
            case "dripwater": {
                return new WaterDripParticle(pos);
            }
            case "driplava": {
                return new LavaDripParticle(pos);
            }
            case "townaura": 
            case "spore": {
                return new SporeParticle(pos);
            }
            case "portal": {
                return new PortalParticle(pos);
            }
            case "flame": {
                return new FlameParticle(pos);
            }
            case "lava": {
                return new LavaParticle(pos);
            }
            case "reddust": {
                return new RedstoneParticle(pos, data != -1 ? data : 1);
            }
            case "snowballpoof": {
                return new ItemBreakParticle(pos, Item.get(332));
            }
            case "slime": {
                return new ItemBreakParticle(pos, Item.get(341));
            }
            case "itembreak": {
                if (data == -1 || data == 0) break;
                return new ItemBreakParticle(pos, Item.get(data));
            }
            case "terrain": {
                if (data == -1 || data == 0) break;
                return new TerrainParticle(pos, Block.get(data));
            }
            case "heart": {
                return new HeartParticle(pos, data != -1 ? data : 0);
            }
            case "ink": {
                return new InkParticle(pos, data != -1 ? data : 0);
            }
            case "droplet": {
                return new RainSplashParticle(pos);
            }
            case "enchantmenttable": {
                return new EnchantmentTableParticle(pos);
            }
            case "happyvillager": {
                return new HappyVillagerParticle(pos);
            }
            case "angryvillager": {
                return new AngryVillagerParticle(pos);
            }
            case "forcefield": {
                return new BlockForceFieldParticle(pos);
            }
        }
        if (name.startsWith("iconcrack_")) {
            d = name.split("_");
            if (d.length == 3) {
                return new ItemBreakParticle(pos, Item.get(Integer.valueOf(d[1]), Integer.valueOf(d[2])));
            }
        } else if (name.startsWith("blockcrack_")) {
            d = name.split("_");
            if (d.length == 2) {
                return new TerrainParticle(pos, Block.get(Integer.valueOf(d[1]) & 0xFF, Integer.valueOf(d[1]) >> 12));
            }
        } else if (name.startsWith("blockdust_") && (d = name.split("_")).length >= 4) {
            return new DustParticle(pos, (int)(Integer.valueOf(d[1]) & 0xFF), (int)(Integer.valueOf(d[2]) & 0xFF), (int)(Integer.valueOf(d[3]) & 0xFF), d.length >= 5 ? Integer.valueOf(d[4]) & 0xFF : 255);
        }
        return null;
    }
}

