/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.entity.data.NBTEntityData;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemFirework;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import cn.nukkit.utils.DyeColor;
import java.util.Random;

public class EntityFirework
extends Entity {
    public static final int NETWORK_ID = 72;
    private int fireworkAge = 0;
    private int lifetime;
    private Item firework;

    @PowerNukkitDifference(info="Will default to a black-creeper-face if the firework data is missing", since="1.3.1.2-PN")
    public EntityFirework(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        Random rand = new Random();
        this.lifetime = 30 + rand.nextInt(6) + rand.nextInt(7);
        this.motionX = rand.nextGaussian() * 0.001;
        this.motionZ = rand.nextGaussian() * 0.001;
        this.motionY = 0.05;
        this.firework = nbt.contains("FireworkItem") ? NBTIO.getItemHelper(nbt.getCompound("FireworkItem")) : new ItemFirework();
        if (!this.firework.hasCompoundTag() || !this.firework.getNamedTag().contains("Fireworks")) {
            CompoundTag tag = this.firework.getNamedTag();
            if (tag == null) {
                tag = new CompoundTag();
            }
            CompoundTag ex = new CompoundTag().putByteArray("FireworkColor", new byte[]{(byte)DyeColor.BLACK.getDyeData()}).putByteArray("FireworkFade", new byte[0]).putBoolean("FireworkFlicker", false).putBoolean("FireworkTrail", false).putByte("FireworkType", ItemFirework.FireworkExplosion.ExplosionType.CREEPER_SHAPED.ordinal());
            tag.putCompound("Fireworks", new CompoundTag("Fireworks").putList(new ListTag<CompoundTag>("Explosions").add(ex)).putByte("Flight", 1));
            this.firework.setNamedTag(tag);
        }
        this.setDataProperty(new NBTEntityData(16, this.firework.getNamedTag()));
        this.setDataProperty(new IntEntityData(17, 1));
        this.setDataProperty(new ByteEntityData(18, 1));
    }

    @Override
    public int getNetworkId() {
        return 72;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        this.timing.startTiming();
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            this.motionX *= 1.15;
            this.motionZ *= 1.15;
            this.motionY += 0.04;
            this.move(this.motionX, this.motionY, this.motionZ);
            this.updateMovement();
            float f = (float)Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.yaw = (float)(Math.atan2(this.motionX, this.motionZ) * 57.29577951308232);
            this.pitch = (float)(Math.atan2(this.motionY, f) * 57.29577951308232);
            if (this.fireworkAge == 0) {
                this.getLevel().addLevelSoundEvent(this, 56);
            }
            ++this.fireworkAge;
            hasUpdate = true;
            if (this.fireworkAge >= this.lifetime) {
                EntityEventPacket pk = new EntityEventPacket();
                pk.data = 0;
                pk.event = 25;
                pk.eid = this.getId();
                this.level.addLevelSoundEvent(this, 58, -1, 72);
                Server.broadcastPacket(this.getViewers().values(), (DataPacket)pk);
                this.kill();
                hasUpdate = true;
            }
        }
        this.timing.stopTiming();
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return (source.getCause() == EntityDamageEvent.DamageCause.VOID || source.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || source.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || source.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && super.attack(source);
    }

    public void setFirework(Item item) {
        this.firework = item;
        this.setDataProperty(new NBTEntityData(16, item.getNamedTag()));
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.25f;
    }
}

