/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.helper.EnsureCover;
import cn.nukkit.level.generator.populator.helper.EnsureGrassBelow;
import cn.nukkit.level.generator.populator.type.PopulatorSurfaceBlock;
import cn.nukkit.math.NukkitRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class PopulatorFlower
extends PopulatorSurfaceBlock {
    private final List<int[]> flowerTypes = new ArrayList<int[]>();

    public void addType(int a, int b) {
        int[] c = new int[]{a, b};
        this.flowerTypes.add(c);
    }

    public List<int[]> getTypes() {
        return this.flowerTypes;
    }

    @Override
    protected void placeBlock(int x, int y, int z, int id, FullChunk chunk, NukkitRandom random) {
        if (this.flowerTypes.size() != 0) {
            int[] type = this.flowerTypes.get(ThreadLocalRandom.current().nextInt(this.flowerTypes.size()));
            chunk.setFullBlockId(x, y, z, type[0] << 6 | type[1]);
            if (type[0] == 175) {
                chunk.setFullBlockId(x, y + 1, z, type[0] << 6 | (8 | type[1]));
            }
        }
    }

    @Override
    protected boolean canStay(int x, int y, int z, FullChunk chunk) {
        return EnsureCover.ensureCover(x, y, z, chunk) && EnsureGrassBelow.ensureGrassBelow(x, y, z, chunk);
    }

    @Override
    protected int getBlockId(int x, int z, NukkitRandom random, FullChunk chunk) {
        return 0;
    }
}

