/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.scheduler;

import cn.nukkit.block.Block;
import cn.nukkit.level.Level;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockUpdateEntry;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BlockUpdateScheduler {
    private final Level level;
    private long lastTick;
    private Map<Long, LinkedHashSet<BlockUpdateEntry>> queuedUpdates = Maps.newHashMap();
    private Set<BlockUpdateEntry> pendingUpdates;

    public BlockUpdateScheduler(Level level, long currentTick) {
        this.lastTick = currentTick;
        this.level = level;
    }

    public synchronized void tick(long currentTick) {
        if (currentTick - this.lastTick < 32767L) {
            for (long tick = this.lastTick + 1L; tick <= currentTick; ++tick) {
                this.perform(tick);
            }
        } else {
            long tick;
            ArrayList<Long> times = new ArrayList<Long>(this.queuedUpdates.keySet());
            Collections.sort(times);
            Iterator<Long> iterator = times.iterator();
            while (iterator.hasNext() && (tick = iterator.next().longValue()) <= currentTick) {
                this.perform(tick);
            }
        }
        this.lastTick = currentTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perform(long tick) {
        try {
            this.lastTick = tick;
            Set updates = this.pendingUpdates = (Set)this.queuedUpdates.remove(tick);
            if (updates != null) {
                Iterator updateIterator = updates.iterator();
                while (updateIterator.hasNext()) {
                    BlockUpdateEntry entry = (BlockUpdateEntry)updateIterator.next();
                    Vector3 pos = entry.pos;
                    if (this.level.isChunkLoaded(NukkitMath.floorDouble(pos.x) >> 4, NukkitMath.floorDouble(pos.z) >> 4)) {
                        Block block = this.level.getBlock(entry.pos, entry.block.layer);
                        updateIterator.remove();
                        if (!Block.equals(block, entry.block, false)) continue;
                        block.onUpdate(3);
                        continue;
                    }
                    this.level.scheduleUpdate(entry.block, entry.pos, 0);
                }
            }
        }
        finally {
            this.pendingUpdates = null;
        }
    }

    public Set<BlockUpdateEntry> getPendingBlockUpdates(AxisAlignedBB boundingBox) {
        LinkedHashSet<BlockUpdateEntry> set = null;
        for (Map.Entry<Long, LinkedHashSet<BlockUpdateEntry>> tickEntries : this.queuedUpdates.entrySet()) {
            LinkedHashSet<BlockUpdateEntry> tickSet = tickEntries.getValue();
            for (BlockUpdateEntry update : tickSet) {
                Vector3 pos = update.pos;
                if (!(pos.getX() >= boundingBox.getMinX()) || !(pos.getX() < boundingBox.getMaxX()) || !(pos.getZ() >= boundingBox.getMinZ()) || !(pos.getZ() < boundingBox.getMaxZ())) continue;
                if (set == null) {
                    set = new LinkedHashSet<BlockUpdateEntry>();
                }
                set.add(update);
            }
        }
        return set;
    }

    public boolean isBlockTickPending(Vector3 pos, Block block) {
        Set<BlockUpdateEntry> tmpUpdates = this.pendingUpdates;
        if (tmpUpdates == null || tmpUpdates.isEmpty()) {
            return false;
        }
        return tmpUpdates.contains(new BlockUpdateEntry(pos, block));
    }

    private long getMinTime(BlockUpdateEntry entry) {
        return Math.max(entry.delay, this.lastTick + 1L);
    }

    public void add(BlockUpdateEntry entry) {
        long time = this.getMinTime(entry);
        LinkedHashSet<BlockUpdateEntry> updateSet = this.queuedUpdates.get(time);
        if (updateSet == null) {
            updateSet = new LinkedHashSet();
            LinkedHashSet tmp = this.queuedUpdates.putIfAbsent(time, updateSet);
            if (tmp != null) {
                updateSet = tmp;
            }
        }
        updateSet.add(entry);
    }

    public boolean contains(BlockUpdateEntry entry) {
        for (Map.Entry<Long, LinkedHashSet<BlockUpdateEntry>> tickUpdateSet : this.queuedUpdates.entrySet()) {
            if (!tickUpdateSet.getValue().contains(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(BlockUpdateEntry entry) {
        for (Map.Entry<Long, LinkedHashSet<BlockUpdateEntry>> tickUpdateSet : this.queuedUpdates.entrySet()) {
            if (!tickUpdateSet.getValue().remove(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Vector3 pos) {
        for (Map.Entry<Long, LinkedHashSet<BlockUpdateEntry>> tickUpdateSet : this.queuedUpdates.entrySet()) {
            if (!tickUpdateSet.getValue().remove(pos)) continue;
            return true;
        }
        return false;
    }
}

