/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;

public abstract class IterableThreadLocal<T>
extends ThreadLocal<T>
implements Iterable<T> {
    private ThreadLocal<T> flag;
    private ConcurrentLinkedDeque<T> allValues = new ConcurrentLinkedDeque();

    @Override
    protected final T initialValue() {
        T value = this.init();
        if (value != null) {
            this.allValues.add(value);
        }
        return value;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.getAll().iterator();
    }

    public T init() {
        return null;
    }

    public void clean() {
        IterableThreadLocal.clean(this);
    }

    public static void clean(ThreadLocal instance) {
        try {
            ThreadGroup parentGroup;
            ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
            while ((parentGroup = rootGroup.getParent()) != null) {
                rootGroup = parentGroup;
            }
            Thread[] threads = new Thread[rootGroup.activeCount()];
            if (threads.length != 0) {
                while (rootGroup.enumerate(threads, true) == threads.length) {
                    threads = new Thread[threads.length * 2];
                }
            }
            Field tl = Thread.class.getDeclaredField("threadLocals");
            tl.setAccessible(true);
            Method methodRemove = null;
            for (Thread thread : threads) {
                Object tlm;
                if (thread == null || (tlm = tl.get(thread)) == null) continue;
                if (methodRemove == null) {
                    methodRemove = tlm.getClass().getDeclaredMethod("remove", ThreadLocal.class);
                    methodRemove.setAccessible(true);
                }
                if (methodRemove == null) continue;
                try {
                    methodRemove.invoke(tlm, instance);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cleanAll() {
        try {
            Thread thread = Thread.currentThread();
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Object threadLocalTable = threadLocalsField.get(thread);
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = threadLocalMapClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Object table = tableField.get(threadLocalTable);
            Field referentField = Reference.class.getDeclaredField("referent");
            referentField.setAccessible(true);
            for (int i = 0; i < Array.getLength(table); ++i) {
                Object entry = Array.get(table, i);
                if (entry == null) continue;
                ThreadLocal threadLocal = (ThreadLocal)referentField.get(entry);
                IterableThreadLocal.clean(threadLocal);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public final Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.allValues);
    }

    protected void finalize() throws Throwable {
        IterableThreadLocal.clean(this);
        super.finalize();
    }
}

