/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.utils.MainLogger;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;

public enum LogLevel implements Comparable<LogLevel>
{
    NONE((logger, message) -> {}, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)(mainLogger, s, throwable) -> {})),
    EMERGENCY(MainLogger::emergency, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)MainLogger::emergency)),
    ALERT(MainLogger::alert, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)MainLogger::alert)),
    CRITICAL(MainLogger::critical, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)MainLogger::critical)),
    ERROR(MainLogger::error, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)MainLogger::error)),
    WARNING(MainLogger::warning, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)MainLogger::warning)),
    NOTICE(MainLogger::notice, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)MainLogger::notice)),
    INFO(MainLogger::info, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)MainLogger::info)),
    DEBUG(MainLogger::debug, (TriConsumer<MainLogger, String, Throwable>)((TriConsumer)MainLogger::debug));

    public static final LogLevel DEFAULT_LEVEL;
    private final BiConsumer<MainLogger, String> logTo;
    private final TriConsumer<MainLogger, String, Throwable> logThrowableTo;

    private LogLevel(BiConsumer<MainLogger, String> logTo, TriConsumer<MainLogger, String, Throwable> logThrowableTo) {
        this.logTo = logTo;
        this.logThrowableTo = logThrowableTo;
    }

    public void log(MainLogger logger, String message) {
        this.logTo.accept(logger, message);
    }

    public void log(MainLogger logger, String message, Throwable throwable) {
        this.logThrowableTo.accept((Object)logger, (Object)message, (Object)throwable);
    }

    public int getLevel() {
        return this.ordinal();
    }

    static {
        DEFAULT_LEVEL = INFO;
    }
}

