/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBambooSapling;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.AnimatePacket;
import cn.nukkit.utils.BlockColor;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public class BlockBamboo
extends BlockTransparentMeta {
    public static final int LEAF_SIZE_NONE = 0;
    public static final int LEAF_SIZE_SMALL = 1;
    public static final int LEAF_SIZE_LARGE = 2;

    public BlockBamboo() {
        this(0);
    }

    public BlockBamboo(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 418;
    }

    @Override
    public String getName() {
        return "Bamboo";
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.isSupportInvalid()) {
                this.level.scheduleUpdate(this, 0);
            }
            return type;
        }
        if (type == 3) {
            this.level.useBreakOn(this, null, null, true);
        } else if (type == 2) {
            Block up = this.up();
            if (this.getAge() == 0 && up.getId() == 0 && this.level.getFullLight(up) >= 9 && ThreadLocalRandom.current().nextInt(3) == 0) {
                this.grow(up);
            }
            return type;
        }
        return 0;
    }

    public boolean grow(Block up) {
        BlockBamboo newState = new BlockBamboo();
        if (this.isThick()) {
            newState.setThick(true);
            newState.setLeafSize(2);
        } else {
            newState.setLeafSize(1);
        }
        BlockGrowEvent blockGrowEvent = new BlockGrowEvent(up, newState);
        this.level.getServer().getPluginManager().callEvent(blockGrowEvent);
        if (!blockGrowEvent.isCancelled()) {
            Block newState1 = blockGrowEvent.getNewState();
            newState1.x = this.x;
            newState1.y = up.y;
            newState1.z = this.z;
            newState1.level = this.level;
            newState1.place(this.toItem(), up, this, BlockFace.DOWN, 0.5, 0.5, 0.5, null);
            return true;
        }
        return false;
    }

    public int countHeight() {
        Optional<Block> opt;
        int count = 0;
        Block down = this;
        while ((opt = down.down().firstInLayers(b -> b.getId() == 418)).isPresent()) {
            down = opt.get();
            if (++count < 16) continue;
            break;
        }
        return count;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        int height;
        Block down = this.down();
        int downId = down.getId();
        if (downId != 418 && downId != 419) {
            BlockBambooSapling sampling = new BlockBambooSapling();
            sampling.x = this.x;
            sampling.y = this.y;
            sampling.z = this.z;
            sampling.level = this.level;
            return sampling.place(item, block, target, face, fx, fy, fz, player);
        }
        boolean canGrow = true;
        if (downId == 419) {
            if (player != null) {
                AnimatePacket animatePacket = new AnimatePacket();
                animatePacket.action = AnimatePacket.Action.SWING_ARM;
                animatePacket.eid = player.getId();
                this.getLevel().addChunkPacket(player.getChunkX(), player.getChunkZ(), animatePacket);
            }
            this.setLeafSize(1);
        }
        if (down instanceof BlockBamboo) {
            BlockBamboo bambooDown = (BlockBamboo)down;
            canGrow = bambooDown.getAge() == 0;
            boolean thick = bambooDown.isThick();
            if (!thick) {
                boolean setThick = true;
                for (int i = 2; i <= 3; ++i) {
                    if (this.getSide(BlockFace.DOWN, i).getId() == 418) continue;
                    setThick = false;
                }
                if (setThick) {
                    this.setThick(true);
                    this.setLeafSize(2);
                    bambooDown.setLeafSize(1);
                    bambooDown.setThick(true);
                    bambooDown.setAge(1);
                    this.level.setBlock((Vector3)bambooDown, bambooDown, false, true);
                    while ((down = down.down()) instanceof BlockBamboo) {
                        bambooDown = (BlockBamboo)down;
                        bambooDown.setThick(true);
                        bambooDown.setLeafSize(0);
                        bambooDown.setAge(1);
                        this.level.setBlock((Vector3)bambooDown, bambooDown, false, true);
                    }
                } else {
                    this.setLeafSize(1);
                    bambooDown.setAge(1);
                    this.level.setBlock((Vector3)bambooDown, bambooDown, false, true);
                }
            } else {
                this.setThick(true);
                this.setLeafSize(2);
                this.setAge(0);
                bambooDown.setLeafSize(2);
                bambooDown.setAge(1);
                this.level.setBlock((Vector3)bambooDown, bambooDown, false, true);
                down = bambooDown.down();
                if (down instanceof BlockBamboo) {
                    bambooDown = (BlockBamboo)down;
                    bambooDown.setLeafSize(1);
                    bambooDown.setAge(1);
                    this.level.setBlock((Vector3)bambooDown, bambooDown, false, true);
                    down = bambooDown.down();
                    if (down instanceof BlockBamboo) {
                        bambooDown = (BlockBamboo)down;
                        bambooDown.setLeafSize(0);
                        bambooDown.setAge(1);
                        this.level.setBlock((Vector3)bambooDown, bambooDown, false, true);
                    }
                }
            }
        } else if (this.isSupportInvalid()) {
            return false;
        }
        int n = height = canGrow ? this.countHeight() : 0;
        if (!canGrow || height >= 15 || height >= 11 && ThreadLocalRandom.current().nextFloat() < 0.25f) {
            this.setAge(1);
        }
        this.level.setBlock((Vector3)this, this, false, true);
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        BlockBamboo bambooDown;
        int height;
        Optional<Block> down = this.down().firstInLayers(b -> b instanceof BlockBamboo);
        if (down.isPresent() && (height = (bambooDown = (BlockBamboo)down.get()).countHeight()) < 15 && (height < 11 || !(ThreadLocalRandom.current().nextFloat() < 0.25f))) {
            bambooDown.setAge(0);
            this.level.setBlock(bambooDown, bambooDown.layer, bambooDown, false, true);
        }
        return super.onBreak(item);
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    private boolean isSupportInvalid() {
        int downId = this.down().getId();
        return downId != 418 && downId != 3 && downId != 2 && downId != 12 && downId != 13 && downId != 243 && downId != 419;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockBamboo());
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    public boolean isThick() {
        return (this.getDamage() & 1) == 1;
    }

    public void setThick(boolean thick) {
        this.setDamage(this.getDamage() & 0x3E | (thick ? 1 : 0));
    }

    @Override
    public int getToolType() {
        return 4;
    }

    public int getLeafSize() {
        return this.getDamage() >> 1 & 3;
    }

    public void setLeafSize(int leafSize) {
        leafSize = MathHelper.clamp(leafSize, 0, 2) & 3;
        this.setDamage(this.getDamage() & 0x39 | leafSize << 1);
    }

    @Override
    public double getBreakTime(Item item, Player player) {
        double breakTime = super.getBreakTime(item, player);
        if (item.isSword()) {
            breakTime /= 30.0;
        }
        return breakTime;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        boolean itemIsBoneMeal = item.isFertilizer();
        if (itemIsBoneMeal || item.getBlock() != null && item.getBlock().getId() == 418) {
            int id;
            int i;
            int top = (int)this.y;
            int count = 1;
            for (i = 1; i <= 16 && (id = this.level.getBlockIdAt(this.getFloorX(), this.getFloorY() - i, this.getFloorZ())) == 418; ++i) {
                ++count;
            }
            for (i = 1; i <= 16 && (id = this.level.getBlockIdAt(this.getFloorX(), this.getFloorY() + i, this.getFloorZ())) == 418; ++i) {
                ++top;
                ++count;
            }
            if (itemIsBoneMeal && count >= 15) {
                return false;
            }
            boolean success = false;
            Block block = this.up(top - (int)this.y + 1);
            if (block.getId() == 0) {
                success = this.grow(block);
            }
            if (success) {
                if (player != null && player.isSurvival()) {
                    --item.count;
                }
                if (itemIsBoneMeal) {
                    this.level.addParticle(new BoneMealParticle(this));
                } else {
                    this.level.addSound(block, Sound.BLOCK_BAMBOO_PLACE, 0.8f, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    public int getAge() {
        return (this.getDamage() & 8) >> 3;
    }

    public void setAge(int age) {
        age = MathHelper.clamp(age, 0, 1) << 3;
        this.setDamage(this.getDamage() & 0x37 | age);
    }
}

