/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDaylightDetectorInverted;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockDaylightDetector
extends BlockTransparentMeta {
    @Override
    public int getId() {
        return 151;
    }

    @Override
    public String getName() {
        return "Daylight Detector";
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (super.place(item, block, target, face, fx, fy, fz, player)) {
            if (this.getLevel().getDimension() == 0) {
                this.updatePower();
                BlockEntity.createBlockEntity("DaylightDetector", (Position)this, new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockDaylightDetectorInverted block = new BlockDaylightDetectorInverted();
        this.getLevel().setBlock((Vector3)this, block, true, true);
        block.updatePower();
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        if (super.onBreak(item)) {
            if (this.getLevel().getDimension() == 0) {
                this.getLevel().updateAroundRedstone(new Vector3(this.x, this.y, this.z), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getWeakPower(BlockFace face) {
        return this.getLevel().getBlockDataAt(this.getFloorX(), this.getFloorY(), this.getFloorZ());
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    public boolean isInverted() {
        return false;
    }

    public void updatePower() {
        int i;
        if (this.getLevel().getDimension() == 0) {
            i = this.getLevel().getBlockSkyLightAt((int)this.x, (int)this.y, (int)this.z) - this.getLevel().calculateSkylightSubtracted(1.0f);
            float f = this.getLevel().getCelestialAngle(1.0f);
            if (this.isInverted()) {
                i = 15 - i;
            }
            if (i > 0 && !this.isInverted()) {
                float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
                f += (f1 - f) * 0.2f;
                i = Math.round((float)i * MathHelper.cos(f));
            }
            i = MathHelper.clamp(i, 0, 15);
        } else {
            i = 0;
        }
        if (i != this.getLevel().getBlockDataAt(this.getFloorX(), this.getFloorY(), this.getFloorZ())) {
            this.getLevel().setBlockDataAt(this.getFloorX(), this.getFloorY(), this.getFloorZ(), i);
            this.getLevel().updateAroundRedstone(this, null);
        }
    }
}

